/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.model.ClassUser;
import edu.harvard.med.countway.dl.model.ClassUserList;
import edu.harvard.med.countway.dl.model.SelectClassUserListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import java.util.Date;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class ClassUserResource {
    private static final Logger log = Logger.getLogger(ClassUserResource.class);
    @Context
    UriInfo uriInfo;
    private final ClassUserDAO dao = new ClassUserDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassUserList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="classId") Integer classId, @QueryParam(value="userId") Integer userId, @QueryParam(value="active") Boolean active, @QueryParam(value="future") Boolean future, @DefaultValue(value="title") @QueryParam(value="sort") SelectClassUserListParams.Sort sort) throws SQLException {
        SelectClassUserListParams select = new SelectClassUserListParams();
        select.setOffset(offset);
        select.setClassId(classId);
        select.setUserId(userId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        ClassUserList result = this.dao.selectClassUserList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("class users not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassUser(@PathParam(value="id") Integer id) throws SQLException {
        ClassUser classUser = this.dao.selectClassUser(id);
        if (classUser == null) {
            return Utils.getNotFoundResponse("class user " + id + " not found");
        }
        return Response.ok((Object)classUser).build();
    }
}

