/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.CourseTypeDAO;
import edu.harvard.med.countway.dl.model.CourseType;
import edu.harvard.med.countway.dl.model.CourseTypeList;
import edu.harvard.med.countway.dl.model.SelectCourseTypeListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="course_type")
public class CourseTypeResource {
    private static final Logger log = Logger.getLogger(CourseTypeResource.class);
    @Context
    UriInfo uriInfo;
    private final CourseTypeDAO dao = new CourseTypeDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseTypeList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="name") @QueryParam(value="sort") SelectCourseTypeListParams.Sort sort) throws SQLException {
        SelectCourseTypeListParams select = new SelectCourseTypeListParams();
        select.setOffset(offset);
        select.setSort(sort);
        CourseTypeList result = this.dao.selectCourseTypeList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("course types not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseType(@PathParam(value="id") Integer id) throws SQLException {
        CourseType courseType = this.dao.selectCourseType(id);
        if (courseType == null) {
            return Utils.getNotFoundResponse("course type " + id + " not found");
        }
        return Response.ok((Object)courseType).build();
    }
}

