/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.HarvardLdapAttributeDAO;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.TocFeedDAO;
import edu.harvard.med.countway.dl.dao.UserDAO;
import edu.harvard.med.countway.dl.model.ClassList;
import edu.harvard.med.countway.dl.model.HarvardLdapAttribute;
import edu.harvard.med.countway.dl.model.HarvardLdapAttributeList;
import edu.harvard.med.countway.dl.model.ResourceList;
import edu.harvard.med.countway.dl.model.SelectClassListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectResourceListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectTocFeedListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectUserListParams;
import edu.harvard.med.countway.dl.model.TocFeedList;
import edu.harvard.med.countway.dl.model.User;
import edu.harvard.med.countway.dl.model.UserList;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import java.util.Date;
import javax.naming.NamingException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class UserResource {
    private static final Logger log = Logger.getLogger(UserResource.class);
    @Context
    UriInfo uriInfo;
    private final UserDAO userDao = new UserDAO();
    private final ClassDAO classDao = new ClassDAO();
    private final ResourceDAO resourceDao = new ResourceDAO();
    private final TocFeedDAO tocFeedDao = new TocFeedDAO();
    private final HarvardLdapAttributeDAO harvardLdapAttributeDao = new HarvardLdapAttributeDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectUserList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="ecid") String ecid, @QueryParam(value="huid") String huid, @DefaultValue(value="ecid") @QueryParam(value="sort") SelectUserListParams.Sort sort) throws SQLException {
        SelectUserListParams select = new SelectUserListParams();
        select.setOffset(offset);
        select.setEcid(ecid);
        select.setHuid(huid);
        select.setSort(sort);
        UserList result = this.userDao.selectUserList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("users not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectUser(@PathParam(value="id") Integer id) throws SQLException {
        User user = this.userDao.selectUser(id);
        if (user == null) {
            return Utils.getNotFoundResponse("user " + id + " not found");
        }
        return Response.ok((Object)user).build();
    }

    @GET
    @Path(value="{id}/class")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassListByUserId(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @PathParam(value="id") Integer userId, @QueryParam(value="active") Boolean active, @QueryParam(value="future") Boolean future, @DefaultValue(value="date") @QueryParam(value="sort") SelectClassListByUserIdParams.Sort sort) throws SQLException {
        SelectClassListByUserIdParams select = new SelectClassListByUserIdParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        ClassList result = this.classDao.selectClassListByUserId(select);
        if (result == null) {
            return Utils.getNotFoundResponse("classes not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/resource")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResourceListByUserId(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @PathParam(value="id") Integer userId, @DefaultValue(value="title") @QueryParam(value="sort") SelectResourceListByUserIdParams.Sort sort) throws SQLException {
        SelectResourceListByUserIdParams select = new SelectResourceListByUserIdParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setSort(sort);
        ResourceList result = this.resourceDao.selectResourceListByUserId(select);
        if (result == null) {
            return Utils.getNotFoundResponse("resources not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/toc_feed")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectTocFeedListByUserId(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @PathParam(value="id") Integer userId) throws SQLException {
        SelectTocFeedListByUserIdParams select = new SelectTocFeedListByUserIdParams();
        select.setOffset(offset);
        select.setLimit(Integer.valueOf(20));
        select.setUserId(userId);
        TocFeedList result = this.tocFeedDao.selectTocFeedListByUserId(select);
        if (result == null) {
            return Utils.getNotFoundResponse("toc feeds not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/huldap")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectHarvardLdapAttributeList(@PathParam(value="id") Integer userId) throws SQLException, NamingException {
        User user = this.userDao.selectUser(userId);
        if (user == null) {
            return Utils.getNotFoundResponse("user " + userId + " not found");
        }
        if (user.getHuid() == null) {
            return Utils.getNotFoundResponse("huid for user " + userId + " not found");
        }
        HarvardLdapAttributeList result = this.harvardLdapAttributeDao.selectAttributeList(user.getHuid());
        if (result == null) {
            return Utils.getNotFoundResponse("harvard ldap attributes not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/huldap/{key}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectHarvardLdapAttribute(@PathParam(value="id") Integer userId, @PathParam(value="key") String key) throws SQLException, NamingException {
        User user = this.userDao.selectUser(userId);
        if (user == null) {
            return Utils.getNotFoundResponse("user " + userId + " not found");
        }
        if (user.getHuid() == null) {
            return Utils.getNotFoundResponse("huid for user " + userId + " not found");
        }
        HarvardLdapAttribute attr = this.harvardLdapAttributeDao.selectAttribute(user.getHuid(), key);
        if (attr == null) {
            return Utils.getNotFoundResponse("attribute not found");
        }
        return Response.ok((Object)attr).build();
    }
}

