/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.UserResourceDAO;
import edu.harvard.med.countway.dl.model.SelectUserResourceListParams;
import edu.harvard.med.countway.dl.model.UserResource;
import edu.harvard.med.countway.dl.model.UserResourceList;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class UserResourceResource {
    private static final Logger log = Logger.getLogger(UserResourceResource.class);
    @Context
    UriInfo uriInfo;
    private final UserResourceDAO dao = new UserResourceDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectUserResourceList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="userId") Integer userId, @QueryParam(value="resourceId") Integer resourceId, @DefaultValue(value="title") @QueryParam(value="sort") SelectUserResourceListParams.Sort sort) throws SQLException {
        SelectUserResourceListParams select = new SelectUserResourceListParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setResourceId(resourceId);
        select.setSort(sort);
        UserResourceList result = this.dao.selectUserResourceList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("user resources not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectUserResource(@PathParam(value="id") Integer id) throws SQLException {
        UserResource userResource = this.dao.selectUserResource(id);
        if (userResource == null) {
            return Utils.getNotFoundResponse("user resource " + id + " not found");
        }
        return Response.ok((Object)userResource).build();
    }
}

