/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ClassInstructorDAO;
import edu.harvard.med.countway.dl.model.ClassInstructor;
import edu.harvard.med.countway.dl.model.ClassInstructorList;
import edu.harvard.med.countway.dl.model.SelectClassInstructorListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="class_instructor")
public class ClassInstructorResource {
    private static final Logger log = Logger.getLogger(ClassInstructorResource.class);
    @Context
    UriInfo uriInfo;
    private final ClassInstructorDAO dao = new ClassInstructorDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassInstructorList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="name") @QueryParam(value="sort") SelectClassInstructorListParams.Sort sort) throws SQLException {
        SelectClassInstructorListParams select = new SelectClassInstructorListParams();
        select.setOffset(offset);
        select.setSort(sort);
        ClassInstructorList result = this.dao.selectClassInstructorList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("class instructors not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassInstructor(@PathParam(value="id") Integer id) throws SQLException {
        ClassInstructor classInstructor = this.dao.selectClassInstructor(id);
        if (classInstructor == null) {
            return Utils.getNotFoundResponse("class instructor " + id + " not found");
        }
        return Response.ok((Object)classInstructor).build();
    }
}

