/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.CourseDAO;
import edu.harvard.med.countway.dl.model.Course;
import edu.harvard.med.countway.dl.model.CourseList;
import edu.harvard.med.countway.dl.model.SelectCourseListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="course")
public class CourseResource {
    private static final Logger log = Logger.getLogger(CourseResource.class);
    @Context
    UriInfo uriInfo;
    private final CourseDAO dao = new CourseDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseList(@QueryParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="typeId") List<Integer> typeId, @QueryParam(value="institutionId") List<Integer> institutionId, @QueryParam(value="active") Boolean active, @DefaultValue(value="title") @QueryParam(value="sort") SelectCourseListParams.Sort sort) throws SQLException {
        SelectCourseListParams select = new SelectCourseListParams();
        select.setQuery(query);
        select.setOffset(offset);
        select.setTypeId(typeId);
        select.setInstitutionId(institutionId);
        select.setActive(active);
        select.setSort(sort);
        CourseList result = this.dao.selectCourseList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("courses not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourse(@PathParam(value="id") Integer id) throws SQLException {
        Course course = this.dao.selectCourse(id);
        if (course == null) {
            return Utils.getNotFoundResponse("course " + id + " not found");
        }
        return Response.ok((Object)course).build();
    }
}

