/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.util.ValidationEventCollector;

public class Utils {
    public static Response getBadRequestResponse(String msg) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)msg).build();
    }

    public static Response getBadRequestResponse(Throwable thr) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)(thr.getClass().getName() + ": " + thr.getMessage() + ": " + Utils.getStackTrace(thr))).build();
    }

    public static Response getNotFoundResponse(String msg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)msg).build();
    }

    public static Response getServerErrorResponse(String msg) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)msg).build();
    }

    public static Response getServerErrorResponse(Throwable thr) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(thr.getClass().getName() + ": " + thr.getMessage() + ": " + Utils.getStackTrace(thr))).build();
    }

    public static Response getOkResponse(String msg) {
        return Response.ok().type("text/plain").entity((Object)msg).build();
    }

    public static Response getCreatedResponse(URI uri) {
        String uristr = uri.toString();
        StringBuffer res = new StringBuffer();
        res.append("<html>");
        res.append("<body>");
        res.append("resource successfully created:<br/>");
        res.append("<a href=\"" + uristr + "\">" + uristr + "</a>");
        res.append("</body></html>");
        return Response.created((URI)uri).type("text/html").entity((Object)res.toString()).build();
    }

    public static Response getUpdatedResponse(URI uri) {
        String uristr = uri.toString();
        StringBuffer res = new StringBuffer();
        res.append("<html><body>");
        res.append("resource successfully updated:<br/>");
        res.append("<a href=\"" + uristr + "\">" + uristr + "</a>");
        res.append("</body></html>");
        return Response.ok().type("text/html").entity((Object)res.toString()).build();
    }

    public static Response getDeletedResponse() {
        StringBuffer res = new StringBuffer();
        res.append("<html><body>");
        res.append("resource successfully deleted");
        res.append("</body></html>");
        return Response.ok().type("text/html").entity((Object)res.toString()).build();
    }

    public static String getStackTrace(Throwable thr) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        thr.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static Integer stringToInteger(String string) {
        Integer integer = null;
        if (string != null && !string.trim().equals("")) {
            integer = new Integer(string);
        }
        return integer;
    }

    public static <T> T unmarshal(JAXBContext jaxbc, String xml) throws JAXBException {
        Unmarshaller um = jaxbc.createUnmarshaller();
        Object obj = um.unmarshal((Reader)new StringReader(xml));
        ValidationEventCollector vec = (ValidationEventCollector)um.getEventHandler();
        if (vec != null && vec.hasEvents()) {
            ValidationEvent ve = vec.getEvents()[0];
            ValidationEventLocator vel = ve.getLocator();
            StringBuffer msg = new StringBuffer("XML validation error at");
            msg.append(" row " + vel.getLineNumber());
            msg.append(" column " + vel.getLineNumber());
            msg.append(": " + ve.getMessage());
            throw new UnmarshalException(msg.toString());
        }
        return (T)obj;
    }

    public static <T> String marshal(JAXBContext jaxbc, T obj) throws JAXBException {
        Marshaller m = jaxbc.createMarshaller();
        StringWriter xmlwr = new StringWriter();
        m.marshal(obj, (Writer)xmlwr);
        ValidationEventCollector vec = (ValidationEventCollector)m.getEventHandler();
        if (vec != null && vec.hasEvents()) {
            ValidationEvent ve = vec.getEvents()[0];
            ValidationEventLocator vel = ve.getLocator();
            StringBuffer msg = new StringBuffer("XML validation error at");
            msg.append(" row " + vel.getLineNumber());
            msg.append(" column " + vel.getLineNumber());
            msg.append(": " + ve.getMessage());
            throw new UnmarshalException(msg.toString());
        }
        return xmlwr.toString();
    }

    public static List<Integer> getIntegerListFromStringList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (String str : list) {
            try {
                Integer integer = Integer.parseInt(str);
                newList.add(integer);
            }
            catch (NumberFormatException e) {}
        }
        return newList;
    }

    public static Integer[] getIntegerArrayFromStringList(List<String> list) {
        return Utils.getIntegerListFromStringList(list).toArray(new Integer[0]);
    }
}

