/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.qep.querydb;

import com.typesafe.config.Config;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.shrine.config.package$;
import net.shrine.log.Log$;
import net.shrine.qep.querydb.QepQueryDbChangeNotifier;
import net.shrine.qep.querydb.QepQueryDbChangeNotifier$;
import net.shrine.source.ConfigSource$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.collection.concurrent.TrieMap$;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class QepQueryDbChangeNotifier$ {
    public static final QepQueryDbChangeNotifier$ MODULE$;
    private final Config config;
    private final BoxedUnit unit;
    private final Map<UUID, QepQueryDbChangeNotifier.Trigger> longPollRequestsToComplete;
    private final Duration interval;
    private final ScheduledExecutorService scheduler;
    private final Runnable runnable;
    private volatile byte bitmap$init$0;

    static {
        new QepQueryDbChangeNotifier$();
    }

    public Config config() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.config;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 28");
    }

    public void unit() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 31");
    }

    public Map<UUID, QepQueryDbChangeNotifier.Trigger> longPollRequestsToComplete() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.longPollRequestsToComplete;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 36");
    }

    public void putLongPollRequest(UUID requstId, long queryId, Promise<BoxedUnit> promise) {
        this.longPollRequestsToComplete().put((Object)requstId, (Object)new QepQueryDbChangeNotifier.Trigger(requstId, queryId, promise, System.currentTimeMillis()));
        Log$.MODULE$.debug((Function0)new Serializable(queryId){
            public static final long serialVersionUID = 0L;
            private final long queryId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"putLongPollRequest Pending requests when triggering ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.queryId$1), QepQueryDbChangeNotifier$.MODULE$.longPollRequestsToComplete()}));
            }
            {
                this.queryId$1 = queryId$1;
            }
        });
    }

    public Option<QepQueryDbChangeNotifier.Trigger> removeLongPollRequest(UUID requestId) {
        return this.longPollRequestsToComplete().remove((Object)requestId);
    }

    public void triggerDataChangeFor(long queryId) {
        Iterable fulfilled = (Iterable)((TraversableLike)this.longPollRequestsToComplete().values().filter((Function1)new Serializable(queryId){
            public static final long serialVersionUID = 0L;
            private final long queryId$2;

            public final boolean apply(QepQueryDbChangeNotifier.Trigger x$1) {
                return x$1.networkQueryId() == this.queryId$2;
            }
            {
                this.queryId$2 = queryId$2;
            }
        })).map((Function1)new Serializable(queryId){
            public static final long serialVersionUID = 0L;
            public final long queryId$2;

            public final long apply(QepQueryDbChangeNotifier.Trigger trigger) {
                if (trigger.promise().trySuccess((Object)BoxedUnit.UNIT)) {
                    Log$.MODULE$.debug((Function0)new Serializable(this, trigger){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.2 $outer;
                        private final QepQueryDbChangeNotifier.Trigger trigger$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully triggered ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.trigger$1, BoxesRunTime.boxToLong((long)this.$outer.queryId$2)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.trigger$1 = trigger$1;
                        }
                    });
                }
                return this.queryId$2;
            }
            {
                this.queryId$2 = queryId$2;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        fulfilled.headOption().getOrElse((Function0)new Serializable(queryId){
            public static final long serialVersionUID = 0L;
            public final long queryId$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Log$.MODULE$.debug((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.triggerDataChangeFor.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No promises fulfilled for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.queryId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.queryId$2 = queryId$2;
            }
        });
    }

    public Duration interval() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.interval;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 58");
    }

    public ScheduledExecutorService scheduler() {
        if ((byte)(this.bitmap$init$0 & 0x10) != 0) {
            return this.scheduler;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 59");
    }

    public Runnable runnable() {
        if ((byte)(this.bitmap$init$0 & 0x20) != 0) {
            return this.runnable;
        }
        throw new UninitializedFieldError("Uninitialized field: QepQueryDbChangeNotifier.scala: 61");
    }

    private QepQueryDbChangeNotifier$() {
        MODULE$ = this;
        this.config = ConfigSource$.MODULE$.config().getConfig("shrine.queryEntryPoint.changeNotifier");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.unit = BoxedUnit.UNIT;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.longPollRequestsToComplete = TrieMap$.MODULE$.empty();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.interval = (Duration)package$.MODULE$.ConfigExtensions(this.config()).get("interval", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$2) {
                return Duration$.MODULE$.apply(x$2);
            }
        });
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.runnable = new Runnable(){

            public void run() {
                long expireTime = System.currentTimeMillis() - QepQueryDbChangeNotifier$.MODULE$.interval().toMillis();
                QepQueryDbChangeNotifier$.MODULE$.longPollRequestsToComplete().retain((Function2)new Serializable(this, expireTime){
                    public static final long serialVersionUID = 0L;
                    private final long expireTime$1;

                    public final boolean apply(UUID id, QepQueryDbChangeNotifier.Trigger x) {
                        return x.instertTime() <= this.expireTime$1;
                    }
                    {
                        this.expireTime$1 = expireTime$1;
                    }
                });
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.scheduler().scheduleAtFixedRate(this.runnable(), this.interval().toMillis(), this.interval().toMillis(), TimeUnit.MILLISECONDS);
    }
}

