/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rmx!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d)AAF\u0005\u0001/\ty1\t\\1tgN+'/[1mSj,'\u000f\u0005\u0003\u000e1ii\u0013BA\r\u000f\u0005\u0019!V\u000f\u001d7feA\u00121\u0004\n\t\u00049}\u0011cBA\u0007\u001e\u0013\tqb\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0005\u0012Qa\u00117bgNT!A\b\b\u0011\u0005\r\"C\u0002\u0001\u0003\nKU\t\t\u0011!A\u0003\u0002\u0019\u00121a\u0018\u00132#\t9#\u0006\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u001d>$\b.\u001b8h!\ti1&\u0003\u0002-\u001d\t\u0019\u0011I\\=\u0011\u0005!q\u0013BA\u0018\u0003\u0005)\u0019VM]5bY&TXM\u001d\u0005\tc%\u0011\r\u0011\"\u0001\u0005e\u0005Y2-\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:,\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0005Yr\u0011\u0001B;uS2L!\u0001O\u001b\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u0004\"AO\u001e\u000e\u0003%1Q\u0001P\u0005C\tu\u00121\"\u00138g_Jl\u0017\r^5p]N!1\b\u0004 B!\tiq(\u0003\u0002A\u001d\t9\u0001K]8ek\u000e$\bCA\u0007C\u0013\t\u0019eB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005Fw\tU\r\u0011\"\u0001G\u0003\u001d\tG\r\u001a:fgN,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0012\tQ!Y2u_JL!\u0001T%\u0003\u000f\u0005#GM]3tg\"Aaj\u000fB\tB\u0003%q)\u0001\u0005bI\u0012\u0014Xm]:!\u0011!\u00016H!f\u0001\n\u0003\t\u0016AB:zgR,W.F\u0001S!\tA5+\u0003\u0002U\u0013\nY\u0011i\u0019;peNK8\u000f^3n\u0011!16H!E!\u0002\u0013\u0011\u0016aB:zgR,W\u000e\t\u0005\u0006'm\"\t\u0001\u0017\u000b\u0004seS\u0006\"B#X\u0001\u00049\u0005\"\u0002)X\u0001\u0004\u0011\u0006b\u0002/<\u0003\u0003%\t!X\u0001\u0005G>\u0004\u0018\u0010F\u0002:=~Cq!R.\u0011\u0002\u0003\u0007q\tC\u0004Q7B\u0005\t\u0019\u0001*\t\u000f\u0005\\\u0014\u0013!C\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A2+\u0005\u001d#7&A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!C;oG\",7m[3e\u0015\tQg\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004owE\u0005I\u0011A8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001O\u000b\u0002SI\"9!oOA\u0001\n\u0003\u001a\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0003mC:<'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014aa\u0015;sS:<\u0007bB?<\u0003\u0003%\tA`\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002\u007fB\u0019Q\"!\u0001\n\u0007\u0005\raBA\u0002J]RD\u0011\"a\u0002<\u0003\u0003%\t!!\u0003\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!&a\u0003\t\u0013\u00055\u0011QAA\u0001\u0002\u0004y\u0018a\u0001=%c!I\u0011\u0011C\u001e\u0002\u0002\u0013\u0005\u00131C\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0003\t\u0006\u0003/\tiBK\u0007\u0003\u00033Q1!a\u0007\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019cOA\u0001\n\u0003\t)#\u0001\u0005dC:,\u0015/^1m)\u0011\t9#!\f\u0011\u00075\tI#C\u0002\u0002,9\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u000e\u0005\u0005\u0012\u0011!a\u0001U!I\u0011\u0011G\u001e\u0002\u0002\u0013\u0005\u00131G\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0010C\u0005\u00028m\n\t\u0011\"\u0011\u0002:\u0005AAo\\*ue&tw\rF\u0001u\u0011%\tidOA\u0001\n\u0003\ny$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003O\t\t\u0005C\u0005\u0002\u000e\u0005m\u0012\u0011!a\u0001U!9\u0011QI\u0005!\u0002\u0013\u0019\u0014\u0001H2veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\t\u0004\u0007\u0003\u0013J\u0001!a\u0013\u0003\u0011M+G\u000f^5oON\u001c2!a\u0012\r\u0011-\ty%a\u0012\u0003\u0006\u0004%\t!!\u0015\u0002\r\r|gNZ5h+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005\u0005TBAA,\u0015\u0011\ty%!\u0017\u000b\t\u0005m\u0013QL\u0001\tif\u0004Xm]1gK*\u0011\u0011qL\u0001\u0004G>l\u0017\u0002BA2\u0003/\u0012aaQ8oM&<\u0007bCA4\u0003\u000f\u0012\t\u0011)A\u0005\u0003'\nqaY8oM&<\u0007\u0005C\u0004\u0014\u0003\u000f\"\t!a\u001b\u0015\t\u00055\u0014q\u000e\t\u0004u\u0005\u001d\u0003\u0002CA(\u0003S\u0002\r!a\u0015\t\u0015\u0005M\u0014q\tb\u0001\n\u0003\t)(A\u0006TKJL\u0017\r\\5{KJ\u001cXCAA<!\u001da\u0012\u0011PA?\u0003{J1!a\u001f\"\u0005\ri\u0015\r\u001d\t\u00049\u0005}\u0014BA>\"\u0011%\t\u0019)a\u0012!\u0002\u0013\t9(\u0001\u0007TKJL\u0017\r\\5{KJ\u001c\b\u0005\u0003\u0006\u0002\b\u0006\u001d#\u0019!C\u0001\u0003k\nQcU3sS\u0006d\u0017N_1uS>t')\u001b8eS:<7\u000fC\u0005\u0002\f\u0006\u001d\u0003\u0015!\u0003\u0002x\u000512+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b\u0005\u0003\u0005\u0002\u0010\u0006\u001dCQBAI\u0003-\u0019wN\u001c4jOR{W*\u00199\u0015\t\u0005]\u00141\u0013\u0005\t\u0003+\u000bi\t1\u0001\u0002T\u0005\u00191MZ4\b\u0015\u0005e\u0015\"!A\t\u0002\u0011\tY*A\u0006J]\u001a|'/\\1uS>t\u0007c\u0001\u001e\u0002\u001e\u001aIA(CA\u0001\u0012\u0003!\u0011qT\n\u0006\u0003;\u000b\t+\u0011\t\b\u0003G\u000bIk\u0012*:\u001b\t\t)KC\u0002\u0002(:\tqA];oi&lW-\u0003\u0003\u0002,\u0006\u0015&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!91#!(\u0005\u0002\u0005=FCAAN\u0011)\t9$!(\u0002\u0002\u0013\u0015\u0013\u0011\b\u0005\u000b\u0003k\u000bi*!A\u0005\u0002\u0006]\u0016!B1qa2LH#B\u001d\u0002:\u0006m\u0006BB#\u00024\u0002\u0007q\t\u0003\u0004Q\u0003g\u0003\rA\u0015\u0005\u000b\u0003\u007f\u000bi*!A\u0005\u0002\u0006\u0005\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fY\rE\u0003\u000e\u0003\u000b\fI-C\u0002\u0002H:\u0011aa\u00149uS>t\u0007\u0003B\u0007\u0019\u000fJC\u0011\"!4\u0002>\u0006\u0005\t\u0019A\u001d\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002R\u0006u\u0015\u0011!C\u0005\u0003'\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001b\t\u0004k\u0006]\u0017bAAmm\n1qJ\u00196fGRDq!!8\n\t\u0003\ty.A\ntKJL\u0017\r\\5{K\u0012\f5\r^8s!\u0006$\b\u000e\u0006\u0003\u0002~\u0005\u0005\b\u0002CAr\u00037\u0004\r!!:\u0002\u0011\u0005\u001cGo\u001c:SK\u001a\u00042\u0001SAt\u0013\r\tI/\u0013\u0002\t\u0003\u000e$xN\u001d*fM\u001a)!B\u0001\u0001\u0002nN)\u00111\u001e\u0007\u0002pB\u0019\u0001*!=\n\u0007\u0005M\u0018JA\u0005FqR,gn]5p]\"Q\u0001+a;\u0003\u0006\u0004%\t!a>\u0016\u0005\u0005e\bc\u0001%\u0002|&\u0019\u0011Q`%\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\t\u0015Y\u000bYO!A!\u0002\u0013\tI\u0010C\u0004\u0014\u0003W$\tAa\u0001\u0015\t\t\u0015!q\u0001\t\u0004\u0011\u0005-\bb\u0002)\u0003\u0002\u0001\u0007\u0011\u0011 \u0005\u000b\u0005\u0017\tYO1A\u0005\u0002\t5\u0011\u0001C:fiRLgnZ:\u0016\u0005\t=\u0001\u0003\u0002B\t\u0003\u000fr!\u0001\u0003\u0001\t\u0013\tU\u00111\u001eQ\u0001\n\t=\u0011!C:fiRLgnZ:!\u0011%\u0011I\"a;!\u0002\u0013\u0011Y\"\u0001\u0003`Y><\u0007\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005B!A\u0003fm\u0016tG/\u0003\u0003\u0003&\t}!\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'\u000f\u0003\u0006\u0003*\u0005-(\u0019!C\u0001\u0005W\t1\u0001\\8h+\t\u0011i\u0003\u0005\u0003\u0003\u001e\t=\u0012\u0002\u0002B\u0019\u0005?\u0011a\u0002T8hO&tw-\u00113baR,'\u000fC\u0005\u00036\u0005-\b\u0015!\u0003\u0003.\u0005!An\\4!\u0011)\u0011I$a;C\u0002\u0013%!1H\u0001\u000e[\u0006t\u0017NZ3ti\u000e\u000b7\r[3\u0016\u0005\tu\u0002C\u0002B \u0005\u0017\u0012y%\u0004\u0002\u0003B)!!1\tB#\u0003\u0019\tGo\\7jG*!!q\tB%\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003maLAA!\u0014\u0003B\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0005\u0003R\t]\u0013Q\u0010B-\u001b\t\u0011\u0019F\u0003\u0003\u0003V\u0005e\u0011!C5n[V$\u0018M\u00197f\u0013\u0011\tYHa\u0015\u0011\u000b5\t)Ma\u00171\t\tu#1\r\t\u0006k\n}#\u0011M\u0005\u0003AY\u00042a\tB2\t-\u0011)Ga\u001a\u0002\u0002\u0003\u0005)\u0011\u0001\u0014\u0003\u0007}##\u0007C\u0005\u0003j\u0005-\b\u0015!\u0003\u0003>\u0005qQ.\u00198jM\u0016\u001cHoQ1dQ\u0016\u0004\u0003\u0002\u0003B7\u0003W$\tAa\u001c\u0002\u0013M,'/[1mSj,G\u0003\u0002B9\u0005\u0007\u0003R\u0001\u000eB:\u0005oJ1A!\u001e6\u0005\r!&/\u001f\t\u0006\u001b\te$QP\u0005\u0004\u0005wr!!B!se\u0006L\bcA\u0007\u0003\u0000%\u0019!\u0011\u0011\b\u0003\t\tKH/\u001a\u0005\b\u0005\u000b\u0013Y\u00071\u0001\r\u0003\u0005y\u0007\u0002\u0003BE\u0003W$\tAa#\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u0005\u001b\u0013\u0019\n\u0006\u0005\u0003\u0010\n]%1\u0014BP!\u0015!$1\u000fBI!\r\u0019#1\u0013\u0003\b\u0005+\u00139I1\u0001'\u0005\u0005!\u0006\u0002\u0003BM\u0005\u000f\u0003\rAa\u001e\u0002\u000b\tLH/Z:\t\u000f\tu%q\u0011a\u0001\u007f\u0006a1/\u001a:jC2L'0\u001a:JI\"A!\u0011\u0015BD\u0001\u0004\u0011\u0019+A\u0003dY\u0006T(\u0010E\u0003\u000e\u0003\u000b\u0014)\u000b\r\u0003\u0003(\n-\u0006\u0003\u0002\u000f \u0005S\u00032a\tBV\t1\u0011iKa,\u0002\u0002\u0003\u0005)\u0011\u0001B`\u0005\ryF\u0005\u000e\u0005\t\u0005C\u00139\t1\u0001\u00032B)Q\"!2\u00034B\"!Q\u0017B]!\u0011arDa.\u0011\u0007\r\u0012I\f\u0002\u0007\u0003.\n=\u0016\u0011!A\u0001\u0006\u0003\u0011Y,E\u0002(\u0005{\u00032a\tBJ#\r9#\u0011\u0013\u0005\t\u0005\u0013\u000bY\u000f\"\u0001\u0003DRA!Q\u0019Bd\u0005\u0013\u0014Y\r\u0005\u00035\u0005gb\u0001\u0002\u0003BM\u0005\u0003\u0004\rAa\u001e\t\u000f\tu%\u0011\u0019a\u0001\u007f\"A!Q\u001aBa\u0001\u0004\ti(\u0001\u0005nC:Lg-Z:u\u0011!\u0011\t.a;\u0005\n\tM\u0017\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3BeJ\f\u0017\u0010F\u0004\r\u0005+\u00149Na7\t\u0011\te%q\u001aa\u0001\u0005oBqA!7\u0003P\u0002\u0007Q&\u0001\u0006tKJL\u0017\r\\5{KJD\u0001B!4\u0003P\u0002\u0007\u0011Q\u0010\u0005\t\u0005?\fY\u000f\"\u0001\u0003b\u0006)B-Z:fe&\fG.\u001b>f\u0005f$XMQ;gM\u0016\u0014Hc\u0002\u0007\u0003d\nM(Q\u001f\u0005\t\u0005K\u0014i\u000e1\u0001\u0003h\u0006\u0019!-\u001e4\u0011\t\t%(q^\u0007\u0003\u0005WT1A!<y\u0003\rq\u0017n\\\u0005\u0005\u0005c\u0014YO\u0001\u0006CsR,')\u001e4gKJDqA!(\u0003^\u0002\u0007q\u0010\u0003\u0005\u0003N\nu\u0007\u0019AA?\u0011!\u0011I)a;\u0005\u0002\teX\u0003\u0002B~\u0007\u0003!bA!@\u0004\u0004\r\u0015\u0001#\u0002\u001b\u0003t\t}\bcA\u0012\u0004\u0002\u00119!Q\u0013B|\u0005\u00041\u0003\u0002\u0003BM\u0005o\u0004\rAa\u001e\t\u0011\t\u0005&q\u001fa\u0001\u0007\u000f\u0001B\u0001H\u0010\u0003\u0000\"A11BAv\t\u0003\u0019i!A\tgS:$7+\u001a:jC2L'0\u001a:G_J$2!LB\b\u0011\u001d\u0011)i!\u0003A\u00021A\u0001ba\u0005\u0002l\u0012\u00051QC\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\u00075\u001a9\u0002\u0003\u0005\u0003\"\u000eE\u0001\u0019AB\ra\u0011\u0019Yba\b\u0011\tqy2Q\u0004\t\u0004G\r}AaCB\u0011\u0007/\t\t\u0011!A\u0003\u0002\u0019\u00121a\u0018\u00139\u0011!\u0019)#a;\u0005\u0002\r\u001d\u0012\u0001D:fe&\fG.\u001b>fe>3G\u0003BB\u0015\u0007W\u0001B\u0001\u000eB:[!A1QFB\u0012\u0001\u0004\ti(A\u0007tKJL\u0017\r\\5{KJ4\u0015K\u0014\u0005\u000b\u0007c\tYO1A\u0005\n\rM\u0012!E:fe&\fG.\u001b>fe\u0012+G/Y5mgV\u00111Q\u0007\t\u0007\u0005#\u001a9da\u000f\n\t\re\"1\u000b\u0002\u0004'\u0016\f\bc\u0001\u0005\u0004>%\u00191q\b\u0002\u0003#M+'/[1mSj,'\u000fR3uC&d7\u000fC\u0005\u0004D\u0005-\b\u0015!\u0003\u00046\u0005\u00112/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:!\u0011)\u00199%a;C\u0002\u0013%1\u0011J\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u0004LA1A$!\u001f\u0002~5B\u0011ba\u0014\u0002l\u0002\u0006Iaa\u0013\u0002\u0019M,'/[1mSj,'o\u001d\u0011\t\u0017\rM\u00131\u001eb\u0001\n\u0003!1QK\u0001\tE&tG-\u001b8hgV\u00111q\u000b\t\u0007\u0005#\u001a9d!\u0017\u0011\u0007\tEQ\u0003C\u0005\u0004^\u0005-\b\u0015!\u0003\u0004X\u0005I!-\u001b8eS:<7\u000f\t\u0005\t\u0007C\nY\u000f\"\u0003\u0004d\u0005\u00192\r[3dW\u001e{wn\u001a7f!J|Go\u001c2vMR!\u0011qEB3\u0011!\u00199ga\u0018A\u0002\u0005u\u0014!C2mCN\u001ch*Y7f\u0011!\u0019Y'a;\u0005\n\r5\u0014\u0001B:peR$Baa\u0016\u0004p!A1\u0011OB5\u0001\u0004\u0019\u0019(\u0001\u0002j]B11QOBC\u00073rAaa\u001e\u0004\u0002:!1\u0011PB@\u001b\t\u0019YHC\u0002\u0004~\u0019\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0007\r\re\"A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d5\u0011\u0012\u0002\t\u0013R,'/\u00192mK*\u001911\u0011\b\t\u0015\r5\u00151\u001eb\u0001\n\u0013\u0019y)A\u0007tKJL\u0017\r\\5{KJl\u0015\r]\u000b\u0003\u0007#\u0003raa%\u0004\u0016\u000eeU&\u0004\u0002\u0003F%!1q\u0013B#\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0019\u0005\u00077\u001by\n\u0005\u0003\u001d?\ru\u0005cA\u0012\u0004 \u0012Y1\u0011UBR\u0003\u0003\u0005\tQ!\u0001'\u0005\u0011yF%\r\u0019\t\u0013\r\u0015\u00161\u001eQ\u0001\n\r\u001d\u0016AD:fe&\fG.\u001b>fe6\u000b\u0007\u000f\t\t\b\u0007'\u001b)j!+.a\u0011\u0019Yka,\u0011\tqy2Q\u0016\t\u0004G\r=FaCBQ\u0007G\u000b\t\u0011!A\u0003\u0002\u0019B!ba-\u0002l\n\u0007I\u0011AB[\u0003Q\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5usV\u00111q\u0017\t\u00069\u0005et0\f\u0005\n\u0007w\u000bY\u000f)A\u0005\u0007o\u000bQc]3sS\u0006d\u0017N_3s\u0005fLE-\u001a8uSRL\b\u0005\u0003\u0006\u0004@\u0006-(\u0019!C\u0005\u0007\u0003\f\u0011$];jG.\u001cVM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5usV\u001111\u0019\t\u0005\u001b\teT\u0006C\u0005\u0004H\u0006-\b\u0015!\u0003\u0004D\u0006Q\u0012/^5dWN+'/[1mSj,'OQ=JI\u0016tG/\u001b;zA!A11ZAv\t\u0013\u0019i-A\thKR\u001cVM]5bY&TXM\u001d\"z\u0013\u0012$2!LBh\u0011\u001d\u0019\tn!3A\u0002}\f!!\u001b3\t\u0015\rU\u00171\u001eb\u0001\n\u0013\u00199.A\u0011jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G-\u0006\u0002\u0002(!I11\\AvA\u0003%\u0011qE\u0001#SNT\u0015M^1TKJL\u0017\r\\5{CRLwN\\,be:LgnZ#oC\ndW\r\u001a\u0011\t\u0015\r}\u00171\u001eb\u0001\n\u0013\u00199.\u0001\u0011jg^\u000b'O\\5oO>sgj\u001c,fe&4\u0017nY1uS>tWI\\1cY\u0016$\u0007\"CBr\u0003W\u0004\u000b\u0011BA\u0014\u0003\u0005J7oV1s]&twm\u00148O_Z+'/\u001b4jG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u0011!\u00199/a;\u0005\n\r%\u0018!H:i_VdGmV1s]\u0006\u0013w.\u001e;KCZ\f7+\u001a:jC2L'0\u001a:\u0015\r\u0005\u001d21^B}\u0011!\u0019io!:A\u0002\r=\u0018aD:fe&\fG.\u001b>fI\u000ec\u0017m]:1\t\rE8Q\u001f\t\u00059}\u0019\u0019\u0010E\u0002$\u0007k$1ba>\u0004l\u0006\u0005\t\u0011!B\u0001M\t!q\fJ\u00193\u0011\u001d\u0011In!:A\u00025\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> akka$serialization$Serialization$$serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    public Try<byte[]> serialize(Object o) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, o){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final Object o$1;

            public final byte[] apply() {
                return this.$outer.findSerializerFor(this.o$1).toBinary(this.o$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.o$1 = o$1;
            }
        });
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, serializerId, clazz){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$3;
            private final int serializerId$2;
            private final Option clazz$2;

            public final T apply() {
                Serializer serializer;
                try {
                    serializer = this.$outer.akka$serialization$Serialization$$getSerializerById(this.serializerId$2);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new NotSerializableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.serializerId$2)}))).append((Object)"akka.actor.serializers is not in synch between the two systems.").toString());
                }
                return (T)serializer.fromBinary(this.bytes$3, this.clazz$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$3 = bytes$3;
                this.serializerId$2 = serializerId$2;
                this.clazz$2 = clazz$2;
            }
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, serializerId, manifest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$2;
            private final int serializerId$1;
            private final String manifest$1;

            public final Object apply() {
                Serializer serializer;
                try {
                    serializer = this.$outer.akka$serialization$Serialization$$getSerializerById(this.serializerId$1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new NotSerializableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.serializerId$1)}))).append((Object)"akka.actor.serializers is not in synch between the two systems.").toString());
                }
                return this.$outer.akka$serialization$Serialization$$deserializeByteArray(this.bytes$2, serializer, this.manifest$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$2 = bytes$2;
                this.serializerId$1 = serializerId$1;
                this.manifest$1 = manifest$1;
            }
        });
    }

    public Object akka$serialization$Serialization$$deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Option option;
        block10: {
            Try try_;
            block11: {
                Object object;
                block5: {
                    Object object2;
                    block7: {
                        Object object3;
                        block9: {
                            Object object4;
                            Map<String, Option<Class<?>>> cache;
                            Serializer serializer2;
                            block8: {
                                block6: {
                                    block4: {
                                        serializer2 = serializer;
                                        if (!(serializer2 instanceof SerializerWithStringManifest)) break block4;
                                        SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
                                        object = serializerWithStringManifest.fromBinary(bytes, manifest);
                                        break block5;
                                    }
                                    String string = manifest;
                                    String string2 = "";
                                    if (string != null ? !string.equals(string2) : string2 != null) break block6;
                                    object2 = serializer2.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                                    break block7;
                                }
                                cache = this.manifestCache().get();
                                option = cache.get((Object)manifest);
                                if (!(option instanceof Some)) break block8;
                                Some some = (Some)option;
                                Option cachedClassManifest = (Option)some.x();
                                object3 = serializer2.fromBinary(bytes, cachedClassManifest);
                                break block9;
                            }
                            if (!None$.MODULE$.equals(option)) break block10;
                            try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                            if (!(try_ instanceof Success)) break block11;
                            Success success = (Success)try_;
                            Class classManifest = (Class)success.value();
                            Some classManifestOption = new Some((Object)classManifest);
                            this.updateCache$1(cache, manifest, (Option)classManifestOption);
                            object3 = object4 = serializer2.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                        }
                        object2 = object3;
                    }
                    object = object2;
                }
                return object;
            }
            if (try_ instanceof Failure) {
                throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find manifest class [", "] for serializer with id [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifest, BoxesRunTime.boxToInteger((int)serializer.identifier())})));
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)option);
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) {
        Object object;
        Serializer serializer;
        Serializer serializer2;
        try {
            serializer = serializer2 = this.akka$serialization$Serialization$$getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)serializerId)}))).append((Object)"akka.actor.serializers is not in synch between the two systems.").toString());
        }
        if (serializer instanceof ByteBufferSerializer) {
            Serializer serializer3 = serializer;
            object = ((ByteBufferSerializer)((Object)serializer3)).fromBinary(buf, manifest);
        } else {
            byte[] bytes = (byte[])Array$.MODULE$.ofDim(buf.remaining(), ClassTag$.MODULE$.Byte());
            buf.get(bytes);
            object = this.akka$serialization$Serialization$$deserializeByteArray(bytes, serializer2, manifest);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, clazz){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$1;
            private final Class clazz$1;

            public final T apply() {
                return (T)this.$outer.serializerFor(this.clazz$1).fromBinary(this.bytes$1, (Option<Class<?>>)new Some((Object)this.clazz$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.clazz$1 = clazz$1;
            }
        });
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Seq seq = (Seq)this.bindings().filter((Function1)new Serializable(this, clazz){
                public static final long serialVersionUID = 0L;
                private final Class clazz$3;

                public final boolean apply(Tuple2<Class<?>, Serializer> x$3) {
                    return ((Class)x$3._1()).isAssignableFrom(this.clazz$3);
                }
                {
                    this.clazz$3 = clazz$3;
                }
            });
            Some some = scala.collection.Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringOps(Predef$.MODULE$.augmentString("No configured serialization-bindings for class [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()})));
            }
            if (!this.unique$1((scala.collection.immutable.Seq)seq)) {
                this._log.warning(LogMarker$.MODULE$.Security(), new StringBuilder().append((Object)"Multiple serializers found for ").append(clazz).append((Object)", choosing first: ").append((Object)seq).toString());
            }
            Serializer ser = serializer4 = (Serializer)((Tuple2)seq.apply(0))._2();
            Serializer serializer5 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer5 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                this.log().debug("Using serializer[{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer5;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.system().dynamicAccess().createInstanceFor(serializerFQN, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, serializerFQN){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String serializerFQN$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.serializerFQN$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : function1.apply(x1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serializerFQN$1 = serializerFQN$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    public Map<String, Serializer> akka$serialization$Serialization$$serializers() {
        return this.akka$serialization$Serialization$$serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    public boolean akka$serialization$Serialization$$checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (scala.collection.immutable.Seq)((TraversableLike)in.$div$colon((Object)arrayBuffer, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Tuple2<Class<?>, Serializer>> apply(ArrayBuffer<Tuple2<Class<?>, Serializer>> buf, Tuple2<Class<?>, Serializer> ca) {
                int n = buf.indexWhere((Function1)new Serializable(this, ca){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 ca$1;

                    public final boolean apply(Tuple2<Class<?>, Serializer> x$8) {
                        return ((Class)x$8._1()).isAssignableFrom((Class)this.ca$1._1());
                    }
                    {
                        this.ca$1 = ca$1;
                    }
                });
                switch (n) {
                    default: {
                        buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                        break;
                    }
                    case -1: {
                        buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    }
                }
                return buf;
            }
        })).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    public Serializer akka$serialization$Serialization$$getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key not found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    private boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && serializer instanceof JavaSerializer && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    private final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Seq possibilities$1;

            public final boolean apply(Tuple2<Class<?>, Serializer> x$1) {
                return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)this.possibilities$1.apply(0))._1());
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        }) || possibilities.forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Seq possibilities$1;

            public final boolean apply(Tuple2<Class<?>, Serializer> x$2) {
                return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)this.possibilities$1.apply(0))._2());
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        });
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Option option;
        block4: {
            Vector vector;
            block3: {
                block2: {
                    this.system = system;
                    this.settings = new Settings(system.settings().config());
                    this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
                    this.log = this._log;
                    this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
                    option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
                    if (!None$.MODULE$.equals(option)) break block2;
                    vector = package$.MODULE$.Vector().empty();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                SerializationSetup setting = (SerializationSetup)some.x();
                vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
            }
            this.serializerDetails = vector;
            Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$1;
                    if (tuple2 == null) return false;
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    if (k == null) return false;
                    if (v == null) return false;
                    return true;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Serialization $outer;

                public final Tuple2<String, Serializer> apply(Tuple2<String, String> x$4) {
                    Tuple2<String, String> tuple2 = x$4;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        if (k != null) {
                            String string = k;
                            if (v != null) {
                                String string2 = v;
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.$outer.serializerOf(string2).get());
                                return tuple22;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Map$.MODULE$.canBuildFrom());
            this.akka$serialization$Serialization$$serializers = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Serializer> apply(SerializerDetails d) {
                    return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer());
                }
            }, Seq$.MODULE$.canBuildFrom()));
            scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$2;
                    if (tuple2 == null) return false;
                    String className = (String)tuple2._1();
                    String alias = (String)tuple2._2();
                    if (className == null) return false;
                    if (alias == null) return false;
                    return true;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Serialization $outer;

                public final boolean apply(Tuple2<String, String> x$5) {
                    Tuple2<String, String> tuple2 = x$5;
                    if (tuple2 != null) {
                        String className = (String)tuple2._1();
                        String alias = (String)tuple2._2();
                        if (className != null) {
                            String string = className;
                            if (alias != null) {
                                String string2;
                                String string3 = string2 = alias;
                                String string4 = "none";
                                boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && this.$outer.akka$serialization$Serialization$$checkGoogleProtobuf(string);
                                return bl;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Serialization $outer;

                public final Tuple2<Class<Object>, Serializer> apply(Tuple2<String, String> x$6) {
                    Tuple2<String, String> tuple2 = x$6;
                    if (tuple2 != null) {
                        String className = (String)tuple2._1();
                        String alias = (String)tuple2._2();
                        if (className != null) {
                            String string = className;
                            if (alias != null) {
                                String string2 = alias;
                                Tuple2 tuple22 = new Tuple2(this.$outer.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.$outer.akka$serialization$Serialization$$serializers().apply((Object)string2));
                                return tuple22;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Seq<Tuple2<Class<Object>, Serializer>> apply(SerializerDetails detail) {
                    return (scala.collection.immutable.Seq)detail.useFor().map((Function1)new Serializable(this, detail){
                        public static final long serialVersionUID = 0L;
                        private final SerializerDetails detail$1;

                        public final Tuple2<Class<Object>, Serializer> apply(Class<?> clazz) {
                            return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)this.detail$1.serializer());
                        }
                        {
                            this.detail$1 = detail$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.bindings = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConcurrentHashMap<Class<?>, Serializer> apply(ConcurrentHashMap<Class<?>, Serializer> x0$2, Tuple2<Class<?>, Serializer> x1$1) {
                    Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                    if (tuple2 != null) {
                        ConcurrentHashMap map = (ConcurrentHashMap)tuple2._1();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Class c = (Class)tuple22._1();
                            Serializer s = (Serializer)tuple22._2();
                            map.put(c, s);
                            ConcurrentHashMap concurrentHashMap = map;
                            return concurrentHashMap;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
            });
            this.serializerByIdentity = (Map)((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus(this.akka$serialization$Serialization$$serializers(), Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Serializer> apply(Tuple2<Object, Serializer> x0$3) {
                    Tuple2<Object, Serializer> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Serializer v = (Serializer)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            int size = 1024;
            Serializer[] table = (Serializer[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.apply(Serializer.class));
            this.serializerByIdentity().foreach((Function1)new Serializable(this, size, table){
                public static final long serialVersionUID = 0L;
                private final int size$1;
                private final Serializer[] table$1;

                public final void apply(Tuple2<Object, Serializer> x0$4) {
                    Tuple2<Object, Serializer> tuple2 = x0$4;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        int id = tuple2._1$mcI$sp();
                        Serializer ser = (Serializer)tuple2._2();
                        if (0 <= id && id < this.size$1) {
                            this.table$1[id] = ser;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.size$1 = size$1;
                    this.table$1 = table$1;
                }
            });
            this.quickSerializerByIdentity = table;
            this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
            this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
            return;
        }
        throw new MatchError(option);
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            Config bindings = config.getBoolean("akka.actor.enable-additional-serialization-bindings") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled") ? defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings")) : defaultBindings;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.system();
                    break;
                }
                case 0: {
                    object = this.address();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.class.$init$((Product)this);
        }
    }
}

