(function () {
    'use strict';

    // -- register controller with angular -- //
    angular.module('shrine-tools')
        .controller('HubController', HubController);


    /**
     *
     * @type {string[]}
     */
    HubController.$inject = ['$app', '$log'];
    function HubController ($app, $log) {
        var vm = this;
        vm.hubError = false;
        init();

        /**
         *
         */
        function init () {
            $app.model.getHub()
                .then(setDownstreamNodes, handleFailure);
        }

        function handleFailure (failure) {
            vm.hubError = failure;
        }

        /**
         *
         * @param hub
         */
        function setDownstreamNodes (hub) {
            vm.downstreamNodes = hub.downstreamNodes;
        }
    }
})();
