/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.http4sbridge;

import cats.effect.IO;
import net.shrine.messagequeueclient.Http4sHttpClient$;
import net.shrine.utilities.http4sbridge.Http4sBridge;
import net.shrine.utilities.http4sbridge.WrongNumberOfArguments;
import org.http4s.client.Client;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Http4sBridgeMain$ {
    public static final Http4sBridgeMain$ MODULE$;

    static {
        new Http4sBridgeMain$();
    }

    public void main(String[] args) {
        try {
            if (args.length < 3 || args.length > 7) {
                throw new WrongNumberOfArguments(Predef$.MODULE$.refArrayOps((Object[])args).mkString(", "));
            }
            Seq optionArgs = (Seq)Predef$.MODULE$.refArrayOps((Object[])args).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(String x$2) {
                    return Option$.MODULE$.apply((Object)x$2);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            Option proxyDomainName = (Option)optionArgs.applyOrElse((Object)BoxesRunTime.boxToInteger((int)3), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final None$ apply(int x) {
                    return None$.MODULE$;
                }
            });
            Option proxyPort = ((Option)optionArgs.applyOrElse((Object)BoxesRunTime.boxToInteger((int)4), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final None$ apply(int x) {
                    return None$.MODULE$;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
                }
            });
            Option proxyUser = (Option)optionArgs.applyOrElse((Object)BoxesRunTime.boxToInteger((int)5), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final None$ apply(int x) {
                    return None$.MODULE$;
                }
            });
            Option proxyPassword = (Option)optionArgs.applyOrElse((Object)BoxesRunTime.boxToInteger((int)6), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final None$ apply(int x) {
                    return None$.MODULE$;
                }
            });
            Option proxyParameters = Http4sHttpClient$.MODULE$.optionsToProxyParameters(proxyDomainName, proxyPort, proxyUser, proxyPassword);
            Client httpClient = Http4sHttpClient$.MODULE$.createHttpClient(proxyParameters);
            new Http4sBridge((Client<IO>)httpClient).main(args);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(2);
            throw throwable;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Predef$.MODULE$.println((Object)illegalArgumentException.getMessage());
            this.printUsage();
            System.exit(1);
            throw illegalArgumentException;
        }
        catch (WrongNumberOfArguments wrongNumberOfArguments) {
            Predef$.MODULE$.println((Object)wrongNumberOfArguments.message());
            this.printUsage();
            System.exit(1);
            throw wrongNumberOfArguments;
        }
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Usage: ./http4sBridge port targetHostName targetPort [proxyHostName proxyPort [proxyUserName proxyPassword]]\n        |\n        |Forward requests from http://localhost:port to https://targetDomainName:targetPort\n        |\n        |Exit codes: 0 success\n        |            1 known error\n        |            2 unknown error (with an accompanying stack trace).\n        |\n        |Examples:\n        |./http4sBridge 3333 shrine-dev1.catalyst 6443\n        |./http4sBridge 3333 shrine-dev1.catalyst 6443 proxy.example.com 8888\n        |./http4sBridge 3333 shrine-dev1.catalyst 6443 proxy.example.com 8888 yourName cleverPassword\n        |")).stripMargin());
    }

    private Http4sBridgeMain$() {
        MODULE$ = this;
    }
}

