/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class BitVector$
implements Serializable {
    public static final BitVector$ MODULE$;
    private final BitVector empty;
    private final BitVector zero;
    private final BitVector one;
    private final BitVector lowByte;
    private final BitVector highByte;
    private final byte[] bitReversalTable;

    static {
        new BitVector$();
    }

    public BitVector empty() {
        return this.empty;
    }

    public BitVector zero() {
        return this.zero;
    }

    public BitVector one() {
        return this.one;
    }

    public BitVector lowByte() {
        return this.lowByte;
    }

    public BitVector highByte() {
        return this.highByte;
    }

    public BitVector bit(boolean high) {
        return high ? this.one() : this.zero();
    }

    public BitVector bits(Iterable<Object> b) {
        return (BitVector)b.iterator().zipWithIndex().foldLeft((Object)this.low(b.size()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector acc, Tuple2<Object, Object> b) {
                return acc.update(b._2$mcI$sp(), b._1$mcZ$sp());
            }
        });
    }

    public BitVector high(long n) {
        return this.fill(n, true);
    }

    public BitVector low(long n) {
        return this.fill(n, false);
    }

    public BitVector apply(ByteVector bs) {
        return this.toBytes(bs, bs.size() * 8L);
    }

    public BitVector apply(ByteBuffer buffer) {
        return this.apply(ByteVector$.MODULE$.apply(buffer));
    }

    public BitVector apply(byte[] bs) {
        return this.toBytes(ByteVector$.MODULE$.apply(bs), (long)Predef$.MODULE$.byteArrayOps(bs).size() * 8L);
    }

    public BitVector apply(GenTraversableOnce<Object> bs) {
        return this.apply(ByteVector$.MODULE$.apply(bs));
    }

    public <A> BitVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        return this.apply(ByteVector$.MODULE$.apply(bytes, evidence$1));
    }

    public BitVector view(ByteBuffer buffer) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), (long)buffer.limit() * 8L);
    }

    public BitVector view(ByteBuffer buffer, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), sizeInBits);
    }

    public BitVector view(byte[] bs) {
        return this.view(bs, (long)Predef$.MODULE$.byteArrayOps(bs).size() * 8L);
    }

    public BitVector view(byte[] bs, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(bs), sizeInBits);
    }

    public BitVector fill(long n, boolean high) {
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(n);
        ByteVector bs = ByteVector$.MODULE$.fill(needed, high ? BoxesRunTime.boxToInteger((int)-1) : BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$);
        return this.toBytes(bs, n);
    }

    public BitVector fromByte(byte b, int size) {
        Predef$.MODULE$.require(size <= 8);
        return ((BitVector)this.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{b}), (Integral)Numeric.ByteIsIntegral$.MODULE$).$less$less(BoxesRunTime.boxToLong((long)(8L - (long)size)))).take(size);
    }

    public int fromByte$default$2() {
        return 8;
    }

    public BitVector fromShort(short s, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 16);
        ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(16L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromShort$default$2() {
        return 16;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromInt(int i, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 32);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(32L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromInt$default$2() {
        return 32;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromLong(long l, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 64);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(64L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromLong$default$2() {
        return 64;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final BitVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, BitVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        return ByteVector$.MODULE$.fromBinInternal(str, alphabet).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(Tuple2<ByteVector, Object> x0$1) {
                Tuple2<ByteVector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int n;
                    int size;
                    ByteVector bytes = (ByteVector)tuple2._1();
                    int n2 = size = tuple2._2$mcI$sp();
                    switch (n2) {
                        default: {
                            if (n2 % 8 == 0) {
                                n = 0;
                                break;
                            }
                            n = 8 - n2 % 8;
                            break;
                        }
                        case 0: {
                            n = 0;
                        }
                    }
                    int toDrop = n;
                    BitVector bitVector = bytes.toBitVector().drop(toDrop);
                    return bitVector;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Option<BitVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).right().toOption();
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public BitVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (BitVector)this.fromBinDescriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, BitVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        return ByteVector$.MODULE$.fromHexInternal(str, alphabet).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(Tuple2<ByteVector, Object> x0$2) {
                Tuple2<ByteVector, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    ByteVector bytes = (ByteVector)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    int toDrop = count % 2 == 0 ? 0 : 4;
                    BitVector bitVector = bytes.toBitVector().drop(toDrop);
                    return bitVector;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Option<BitVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).right().toOption();
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public BitVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (BitVector)this.fromHexDescriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, BitVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase64Descriptive(str, alphabet).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$30) {
                return x$30.toBitVector();
            }
        });
    }

    public Option<BitVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).right().toOption();
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public BitVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (BitVector)this.fromBase64Descriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, BitVector> encodeString(String str, Charset charset) {
        return ByteVector$.MODULE$.encodeString(str, charset).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$31) {
                return x$31.bits();
            }
        });
    }

    public Either<CharacterCodingException, BitVector> encodeUtf8(String str) {
        return ByteVector$.MODULE$.encodeUtf8(str).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$32) {
                return x$32.bits();
            }
        });
    }

    public Either<CharacterCodingException, BitVector> encodeAscii(String str) {
        return ByteVector$.MODULE$.encodeAscii(str).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$33) {
                return x$33.bits();
            }
        });
    }

    public BitVector concat(GenTraversableOnce<BitVector> bvs) {
        return (BitVector)bvs.foldLeft((Object)this.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x$34, BitVector x$35) {
                return x$34.$plus$plus(x$35);
            }
        });
    }

    public <S> BitVector unfold(S s, Function1<S, Option<Tuple2<BitVector, S>>> f) {
        return new BitVector.Suspend((Function0<BitVector>)new Serializable(s, f){
            public static final long serialVersionUID = 0L;
            private final Object s$1;
            public final Function1 f$3;

            public final BitVector apply() {
                return (BitVector)((Option)this.f$3.apply(this.s$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.unfold.1 $outer;

                    public final BitVector.Append apply(Tuple2<BitVector, S> x0$3) {
                        Tuple2<BitVector, S> tuple2 = x0$3;
                        if (tuple2 != null) {
                            BitVector h = (BitVector)tuple2._1();
                            Object t = tuple2._2();
                            BitVector.Append append = new BitVector.Append(h, BitVector$.MODULE$.unfold(t, this.$outer.f$3));
                            return append;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BitVector apply() {
                        return BitVector$.MODULE$.empty();
                    }
                });
            }
            {
                this.s$1 = s$1;
                this.f$3 = f$3;
            }
        });
    }

    public BitVector fromInputStream(InputStream in, int chunkSizeInBytes) {
        return this.unfold((Object)in, (Function1)new Serializable(chunkSizeInBytes){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$1;

            public final Option<Tuple2<BitVector, InputStream>> apply(InputStream in) {
                byte[] buf = new byte[this.chunkSizeInBytes$1];
                int nRead = in.read(buf);
                return nRead == this.chunkSizeInBytes$1 ? new Some((Object)new Tuple2((Object)BitVector$.MODULE$.apply(buf), (Object)in)) : (nRead == -1 ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BitVector$.MODULE$.apply((byte[])Predef$.MODULE$.byteArrayOps(buf).take(nRead)), (Object)in)));
            }
            {
                this.chunkSizeInBytes$1 = chunkSizeInBytes$1;
            }
        });
    }

    public int fromInputStream$default$2() {
        return 0xFA0000;
    }

    public BitVector fromChannel(ReadableByteChannel in, int chunkSizeInBytes, boolean direct) {
        return this.unfold((Object)in, (Function1)new Serializable(chunkSizeInBytes, direct){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$2;
            private final boolean direct$1;

            public final Option<Tuple2<BitVector, ReadableByteChannel>> apply(ReadableByteChannel in) {
                ByteBuffer buf = this.direct$1 ? ByteBuffer.allocateDirect(this.chunkSizeInBytes$2) : ByteBuffer.allocate(this.chunkSizeInBytes$2);
                int nRead = in.read(buf);
                buf.flip();
                return nRead != -1 ? new Some((Object)new Tuple2((Object)BitVector$.MODULE$.view(buf, (long)nRead * 8L), (Object)in)) : None$.MODULE$;
            }
            {
                this.chunkSizeInBytes$2 = chunkSizeInBytes$2;
                this.direct$1 = direct$1;
            }
        });
    }

    public int fromChannel$default$2() {
        return 0xFA0000;
    }

    public boolean fromChannel$default$3() {
        return false;
    }

    public BitVector fromMmap(FileChannel in, int chunkSizeInBytes) {
        return this.unfold((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)in), (Object)BoxesRunTime.boxToLong((long)0L)), (Function1)new Serializable(chunkSizeInBytes){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$3;

            public final Option<Tuple2<BitVector, Tuple2<FileChannel, Object>>> apply(Tuple2<FileChannel, Object> x0$4) {
                Tuple2<FileChannel, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    None$ none$;
                    FileChannel in = (FileChannel)tuple2._1();
                    long pos = tuple2._2$mcJ$sp();
                    if (pos == in.size()) {
                        none$ = None$.MODULE$;
                    } else {
                        Predef$.MODULE$.require(pos < in.size());
                        long bytesToRead = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(in.size() - pos), (long)this.chunkSizeInBytes$3);
                        MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, pos, bytesToRead);
                        Predef$.MODULE$.require((long)buf.limit() == bytesToRead);
                        none$ = new Some((Object)new Tuple2((Object)BitVector$.MODULE$.view(buf), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)in), (Object)BoxesRunTime.boxToLong((long)(pos + bytesToRead)))));
                    }
                    None$ none$2 = none$;
                    return none$2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.chunkSizeInBytes$3 = chunkSizeInBytes$3;
            }
        });
    }

    public int fromMmap$default$2() {
        return 0xFA0000;
    }

    public BitVector.Bytes toBytes(ByteVector bs, long sizeInBits) {
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(sizeInBits);
        Predef$.MODULE$.require(needed <= bs.size());
        ByteVector b = bs.size() > needed ? bs.take(needed) : bs;
        return new BitVector.Bytes(b, sizeInBits);
    }

    public BitVector concat(Vector<BitVector> vs) {
        return (BitVector)vs.foldLeft((Object)this.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x$42, BitVector x$43) {
                return x$42.$plus$plus(x$43);
            }
        });
    }

    public boolean scodec$bits$BitVector$$getBit(byte by, int n) {
        return (128 >> n & by) != 0;
    }

    public byte scodec$bits$BitVector$$setBit(byte by, int n, boolean high) {
        return (byte)(high ? 128 >> n | by : ~(128 >> n) & by);
    }

    public long scodec$bits$BitVector$$validBitsInLastByte(long size) {
        long mod = size % 8L;
        return mod == 0L ? 8L : mod;
    }

    public byte scodec$bits$BitVector$$topNBits(int n) {
        return (byte)(-1 << 8 - n);
    }

    public long scodec$bits$BitVector$$bytesNeededForBits(long size) {
        return (size + 7L) / 8L;
    }

    public byte reverseBitsInByte(byte b) {
        return this.bitReversalTable()[b & 0xFF];
    }

    private byte[] bitReversalTable() {
        return this.bitReversalTable;
    }

    public ByteVector scodec$bits$BitVector$$clearUnneededBits(long size, ByteVector bytes) {
        ByteVector byteVector;
        int valid = (int)this.scodec$bits$BitVector$$validBitsInLastByte(size);
        if (bytes.nonEmpty() && valid < 8) {
            long idx = bytes.size() - 1L;
            byte last = bytes.apply(idx);
            byteVector = bytes.update(idx, (byte)(last & this.scodec$bits$BitVector$$topNBits(valid)));
        } else {
            byteVector = bytes;
        }
        return byteVector;
    }

    public <A> A reduceBalanced(TraversableOnce<A> v, Function1<A, Object> size, Function2<A, A, A> f) {
        return (A)((LinearSeqOptimized)((List)v.foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(size, f){
            public static final long serialVersionUID = 0L;
            private final Function1 size$1;
            private final Function2 f$2;

            public final List<Tuple2<A, Object>> apply(List<Tuple2<A, Object>> stack, A a) {
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), this.size$1.apply(a));
                return BitVector$.MODULE$.scodec$bits$BitVector$$fixup$1(stack.$colon$colon((Object)tuple2), this.f$2);
            }
            {
                this.size$1 = size$1;
                this.f$2 = f$2;
            }
        })).reverse().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final A apply(Tuple2<A, Object> x$46) {
                return (A)x$46._1();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft(f);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final List scodec$bits$BitVector$$fixup$1(List stack, Function2 f$2) {
        List list;
        while ((list = stack) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.tl$1();
            if (tuple2 == null) break;
            Object h2 = tuple2._1();
            long n = tuple2._2$mcJ$sp();
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon3 = (.colon.colon)list2;
            Tuple2 tuple22 = (Tuple2)colon3.head();
            List t = colon3.tl$1();
            if (tuple22 == null) break;
            Object h = tuple22._1();
            long m = tuple22._2$mcJ$sp();
            if (n <= m / 2L) break;
            Tuple2 tuple23 = new Tuple2(f$2.apply(h, h2), (Object)BoxesRunTime.boxToLong((long)(m + n)));
            stack = t.$colon$colon((Object)tuple23);
        }
        List list3 = stack;
        return list3;
    }

    private BitVector$() {
        MODULE$ = this;
        this.empty = this.toBytes(ByteVector$.MODULE$.empty(), 0L);
        this.zero = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.one = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{255}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.lowByte = this.toBytes(ByteVector$.MODULE$.fill(8L, BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), 8L);
        this.highByte = this.toBytes(ByteVector$.MODULE$.fill(8L, BoxesRunTime.boxToInteger((int)1), Numeric.IntIsIntegral$.MODULE$), 8L);
        this.bitReversalTable = new byte[]{(byte)0, (byte)128, (byte)64, (byte)192, (byte)32, (byte)160, (byte)96, (byte)224, (byte)16, (byte)144, (byte)80, (byte)208, (byte)48, (byte)176, (byte)112, (byte)240, (byte)8, (byte)136, (byte)72, (byte)200, (byte)40, (byte)168, (byte)104, (byte)232, (byte)24, (byte)152, (byte)88, (byte)216, (byte)56, (byte)184, (byte)120, (byte)248, (byte)4, (byte)132, (byte)68, (byte)196, (byte)36, (byte)164, (byte)100, (byte)228, (byte)20, (byte)148, (byte)84, (byte)212, (byte)52, (byte)180, (byte)116, (byte)244, (byte)12, (byte)140, (byte)76, (byte)204, (byte)44, (byte)172, (byte)108, (byte)236, (byte)28, (byte)156, (byte)92, (byte)220, (byte)60, (byte)188, (byte)124, (byte)252, (byte)2, (byte)130, (byte)66, (byte)194, (byte)34, (byte)162, (byte)98, (byte)226, (byte)18, (byte)146, (byte)82, (byte)210, (byte)50, (byte)178, (byte)114, (byte)242, (byte)10, (byte)138, (byte)74, (byte)202, (byte)42, (byte)170, (byte)106, (byte)234, (byte)26, (byte)154, (byte)90, (byte)218, (byte)58, (byte)186, (byte)122, (byte)250, (byte)6, (byte)134, (byte)70, (byte)198, (byte)38, (byte)166, (byte)102, (byte)230, (byte)22, (byte)150, (byte)86, (byte)214, (byte)54, (byte)182, (byte)118, (byte)246, (byte)14, (byte)142, (byte)78, (byte)206, (byte)46, (byte)174, (byte)110, (byte)238, (byte)30, (byte)158, (byte)94, (byte)222, (byte)62, (byte)190, (byte)126, (byte)254, (byte)1, (byte)129, (byte)65, (byte)193, (byte)33, (byte)161, (byte)97, (byte)225, (byte)17, (byte)145, (byte)81, (byte)209, (byte)49, (byte)177, (byte)113, (byte)241, (byte)9, (byte)137, (byte)73, (byte)201, (byte)41, (byte)169, (byte)105, (byte)233, (byte)25, (byte)153, (byte)89, (byte)217, (byte)57, (byte)185, (byte)121, (byte)249, (byte)5, (byte)133, (byte)69, (byte)197, (byte)37, (byte)165, (byte)101, (byte)229, (byte)21, (byte)149, (byte)85, (byte)213, (byte)53, (byte)181, (byte)117, (byte)245, (byte)13, (byte)141, (byte)77, (byte)205, (byte)45, (byte)173, (byte)109, (byte)237, (byte)29, (byte)157, (byte)93, (byte)221, (byte)61, (byte)189, (byte)125, (byte)253, (byte)3, (byte)131, (byte)67, (byte)195, (byte)35, (byte)163, (byte)99, (byte)227, (byte)19, (byte)147, (byte)83, (byte)211, (byte)51, (byte)179, (byte)115, (byte)243, (byte)11, (byte)139, (byte)75, (byte)203, (byte)43, (byte)171, (byte)107, (byte)235, (byte)27, (byte)155, (byte)91, (byte)219, (byte)59, (byte)187, (byte)123, (byte)251, (byte)7, (byte)135, (byte)71, (byte)199, (byte)39, (byte)167, (byte)103, (byte)231, (byte)23, (byte)151, (byte)87, (byte)215, (byte)55, (byte)183, (byte)119, (byte)247, (byte)15, (byte)143, (byte)79, (byte)207, (byte)47, (byte)175, (byte)111, (byte)239, (byte)31, (byte)159, (byte)95, (byte)223, (byte)63, (byte)191, (byte)127, (byte)255};
    }
}

