/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Applicative;
import cats.Contravariant;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.effect.Sync;
import cats.implicits$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Segment;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Path;
import org.http4s.Charset;
import org.http4s.Entity;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.EntityEncoder$class;
import org.http4s.EntityEncoderInstances;
import org.http4s.EntityEncoderInstances$;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.MediaType$;
import org.http4s.ServerSentEvent$;
import org.http4s.TransferCoding;
import org.http4s.TransferCoding$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.multipart.MultipartEncoder;
import org.http4s.package$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public abstract class EntityEncoderInstances$class {
    public static EntityEncoder unitEncoder(EntityEncoderInstances $this, Applicative evidence$2) {
        return $this.emptyEncoder(evidence$2);
    }

    public static EntityEncoder stringEncoder(EntityEncoderInstances $this, Applicative F, Charset charset2) {
        Content$minusType hdr = Content$minusType$.MODULE$.apply(MediaType$.MODULE$.text$divplain()).withCharset(charset2);
        return EntityEncoder$.MODULE$.simple((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{hdr}), new Serializable($this, charset2){
            public static final long serialVersionUID = 0L;
            private final Charset charset$2;

            public final Chunk<Object> apply(String s2) {
                return Chunk$.MODULE$.bytes(s2.getBytes(this.charset$2.nioCharset()));
            }
            {
                this.charset$2 = charset$2;
            }
        }, F);
    }

    public static Charset stringEncoder$default$2(EntityEncoderInstances $this) {
        return package$.MODULE$.DefaultCharset();
    }

    public static EntityEncoder charArrayEncoder(EntityEncoderInstances $this, Applicative F, Charset charset2) {
        return $this.stringEncoder(F, charset2).contramap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(char[] x$3) {
                return new String(x$3);
            }
        });
    }

    public static Charset charArrayEncoder$default$2(EntityEncoderInstances $this) {
        return package$.MODULE$.DefaultCharset();
    }

    public static EntityEncoder segmentEncoder(EntityEncoderInstances $this, Applicative evidence$3) {
        return $this.chunkEncoder(evidence$3).contramap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Chunk<Object> apply(Segment<Object, BoxedUnit> x$4) {
                return Segment.Force$.MODULE$.toChunk$extension(x$4.force());
            }
        });
    }

    public static EntityEncoder chunkEncoder(EntityEncoderInstances $this, Applicative evidence$4) {
        return EntityEncoder$.MODULE$.simple((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application$divoctet$minusstream())}), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Chunk<Object> apply(Chunk<Object> x) {
                return (Chunk)Predef$.MODULE$.identity(x);
            }
        }, evidence$4);
    }

    public static EntityEncoder byteArrayEncoder(EntityEncoderInstances $this, Applicative evidence$5) {
        return $this.chunkEncoder(evidence$5).contramap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Chunk<Object> apply(byte[] values2) {
                return Chunk$.MODULE$.bytes(values2);
            }
        });
    }

    public static EntityEncoder entityBodyEncoder(EntityEncoderInstances $this, Applicative F) {
        return EntityEncoder$.MODULE$.encodeBy((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Transfer$minusEncoding$.MODULE$.apply(TransferCoding$.MODULE$.chunked(), (Seq<Object>)Predef$.MODULE$.wrapRefArray((Object[])new TransferCoding[0]))}), new Serializable($this, F){
            public static final long serialVersionUID = 0L;
            private final Applicative F$5;

            public final F apply(FreeC<?, BoxedUnit> body) {
                return (F)this.F$5.pure(new Entity<F>(body, (Option<Object>)None$.MODULE$));
            }
            {
                this.F$5 = F$5;
            }
        });
    }

    public static EntityEncoder effectEncoder(EntityEncoderInstances $this, FlatMap F, EntityEncoder W) {
        return new EntityEncoder<F, F>($this, F, W){
            private final FlatMap F$6;
            public final EntityEncoder W$3;

            public <B> EntityEncoder<F, B> contramap(Function1<B, F> f) {
                return EntityEncoder$class.contramap(this, f);
            }

            public Option<Content$minusType> contentType() {
                return EntityEncoder$class.contentType(this);
            }

            public Option<Charset> charset() {
                return EntityEncoder$class.charset(this);
            }

            public EntityEncoder<F, F> withContentType(Content$minusType tpe) {
                return EntityEncoder$class.withContentType(this, tpe);
            }

            public F toEntity(F a) {
                return (F)implicits$.MODULE$.toFlatMapOps(a, this.F$6).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EntityEncoderInstances$.anon.8 $outer;

                    public final F apply(A a) {
                        return this.$outer.W$3.toEntity(a);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public Headers headers() {
                return this.W$3.headers();
            }
            {
                this.F$6 = F$6;
                this.W$3 = W$3;
                EntityEncoder$class.$init$(this);
            }
        };
    }

    public static EntityEncoder fileEncoder(EntityEncoderInstances $this, Sync F) {
        return $this.inputStreamEncoder(F).contramap(new Serializable($this, F){
            public static final long serialVersionUID = 0L;
            private final Sync F$7;

            public final F apply(File file) {
                return (F)this.F$7.delay((Function0)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final FileInputStream apply() {
                        return new FileInputStream(this.file$1);
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                this.F$7 = F$7;
            }
        });
    }

    public static EntityEncoder filePathEncoder(EntityEncoderInstances $this, Sync evidence$6) {
        return $this.fileEncoder(evidence$6).contramap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply(Path x$5) {
                return x$5.toFile();
            }
        });
    }

    public static EntityEncoder inputStreamEncoder(EntityEncoderInstances $this, Sync evidence$7) {
        return $this.entityBodyEncoder(evidence$7).contramap(new Serializable($this, evidence$7){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityEncoderInstances $outer;
            private final Sync evidence$7$1;

            public final FreeC<?, BoxedUnit> apply(F in) {
                return fs2.io.package$.MODULE$.readInputStream(implicits$.MODULE$.toFunctorOps(in, (Functor)this.evidence$7$1).widen(), this.$outer.org$http4s$EntityEncoderInstances$$DefaultChunkSize(), fs2.io.package$.MODULE$.readInputStream$default$3(), this.evidence$7$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.evidence$7$1 = evidence$7$1;
            }
        });
    }

    public static EntityEncoder readerEncoder(EntityEncoderInstances $this, Sync F, Charset charset2) {
        return $this.entityBodyEncoder(F).contramap(new Serializable($this, F, charset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityEncoderInstances $outer;
            public final Sync F$8;
            public final Charset charset$3;

            public final FreeC<?, BoxedUnit> apply(F r) {
                CharBuffer charBuffer = CharBuffer.allocate(this.$outer.org$http4s$EntityEncoderInstances$$DefaultChunkSize());
                Object readToBytes = implicits$.MODULE$.toFunctorOps(r, (Functor)this.F$8).map((Function1)new Serializable(this, charBuffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EntityEncoderInstances$.anonfun.readerEncoder.1 $outer;
                    private final CharBuffer charBuffer$1;

                    public final Option<Chunk<Object>> apply(R r) {
                        None$ none$;
                        int readChars = ((Reader)r).read(this.charBuffer$1);
                        this.charBuffer$1.flip();
                        if (readChars < 0) {
                            none$ = None$.MODULE$;
                        } else if (readChars == 0) {
                            none$ = new Some((Object)Chunk$.MODULE$.empty());
                        } else {
                            ByteBuffer bb = this.$outer.charset$3.nioCharset().encode(this.charBuffer$1);
                            byte[] b = new byte[bb.remaining()];
                            bb.get(b);
                            none$ = new Some((Object)Chunk$.MODULE$.bytes(b));
                        }
                        return none$;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.charBuffer$1 = charBuffer$1;
                    }
                });
                return Stream$.MODULE$.bracket(r, (Function1)new Serializable(this, readToBytes){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EntityEncoderInstances$.anonfun.readerEncoder.1 $outer;
                    private final Object readToBytes$1;

                    public final FreeC<?, BoxedUnit> apply(R x$6) {
                        return this.$outer.org$http4s$EntityEncoderInstances$class$$anonfun$$useReader$1(this.readToBytes$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.readToBytes$1 = readToBytes$1;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EntityEncoderInstances$.anonfun.readerEncoder.1 $outer;

                    public final F apply(R t) {
                        return (F)this.$outer.F$8.delay((Function0)new Serializable(this, (Reader)t){
                            public static final long serialVersionUID = 0L;
                            private final Reader t$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.t$1.close();
                            }
                            {
                                this.t$1 = t$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final FreeC org$http4s$EntityEncoderInstances$class$$anonfun$$useReader$1(Object readToBytes$1) {
                return Stream.InvariantOps$.MODULE$.flatMap$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.unNoneTerminate$extension(Stream$.MODULE$.repeat$extension(Stream$.MODULE$.eval(readToBytes$1)), Predef$.MODULE$.$conforms())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FreeC<?, BoxedUnit> apply(Chunk<Object> os) {
                        return Stream$.MODULE$.covaryPure(Stream$.MODULE$.chunk(os));
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.F$8 = F$8;
                this.charset$3 = charset$3;
            }
        });
    }

    public static Charset readerEncoder$default$2(EntityEncoderInstances $this) {
        return package$.MODULE$.DefaultCharset();
    }

    public static EntityEncoder multipartEncoder(EntityEncoderInstances $this, Sync evidence$8) {
        return new MultipartEncoder(evidence$8);
    }

    public static Contravariant entityEncoderContravariant(EntityEncoderInstances $this) {
        return new Contravariant<?>($this){

            public Object imap(Object fa, Function1 f, Function1 fi) {
                return Contravariant.class.imap((Contravariant)this, (Object)fa, (Function1)f, (Function1)fi);
            }

            public <G> Functor<?> compose(Contravariant<G> evidence$1) {
                return Contravariant.class.compose((Contravariant)this, evidence$1);
            }

            public Object narrow(Object fa) {
                return Contravariant.class.narrow((Contravariant)this, (Object)fa);
            }

            public <A, B> Function1<EntityEncoder<F, B>, EntityEncoder<F, A>> liftContravariant(Function1<A, B> f) {
                return Contravariant.class.liftContravariant((Contravariant)this, f);
            }

            public <G> Contravariant<?> composeFunctor(Functor<G> evidence$2) {
                return Contravariant.class.composeFunctor((Contravariant)this, evidence$2);
            }

            public <G> Invariant<?> compose(Invariant<G> evidence$1) {
                return Invariant.class.compose((Invariant)this, evidence$1);
            }

            public <G> Invariant<?> composeContravariant(Contravariant<G> evidence$3) {
                return Invariant.class.composeContravariant((Invariant)this, evidence$3);
            }

            public <A, B> EntityEncoder<F, B> contramap(EntityEncoder<F, A> r, Function1<B, A> f) {
                return r.contramap(f);
            }
            {
                Invariant.class.$init$((Invariant)this);
                Contravariant.class.$init$((Contravariant)this);
            }
        };
    }

    public static EntityEncoder serverSentEventEncoder(EntityEncoderInstances $this, Applicative evidence$9) {
        return $this.entityBodyEncoder(evidence$9).contramap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final FreeC<?, BoxedUnit> apply(FreeC<?, BoxedUnit> x$7) {
                return Stream.InvariantOps$.MODULE$.through$extension(Stream$.MODULE$.InvariantOps(x$7), ServerSentEvent$.MODULE$.encoder());
            }
        }).withContentType(Content$minusType$.MODULE$.apply(MediaType$.MODULE$.text$divevent$minusstream()));
    }

    public static void $init$(EntityEncoderInstances $this) {
        $this.org$http4s$EntityEncoderInstances$_setter_$org$http4s$EntityEncoderInstances$$DefaultChunkSize_$eq(4096);
    }
}

