/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeuemiddleware;

import com.typesafe.config.Config;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.shrine.log.Log$;
import net.shrine.messagequeuemiddleware.DeliveryAttempt;
import net.shrine.messagequeuemiddleware.InternalMessage;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware$;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware$$anonfun$receive$1$;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware$MessageScheduler$;
import net.shrine.messagequeuemiddleware.MessageDoesNotExistAndCannotBeCompletedException;
import net.shrine.messagequeuemiddleware.QueueDoesNotExistException;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.messagequeueservice.Queue;
import net.shrine.source.ConfigSource$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.concurrent.Map;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;

public final class LocalMessageQueueMiddleware$
implements MessageQueueService {
    public static final LocalMessageQueueMiddleware$ MODULE$;
    private final String configPath;
    private final TrieMap<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
    private final Map<String, BlockingDeque<InternalMessage>> blockingQueuePool;
    private volatile byte bitmap$init$0;

    static {
        new LocalMessageQueueMiddleware$();
    }

    public String configPath() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.configPath;
        }
        throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 31");
    }

    public Config config() {
        return ConfigSource$.MODULE$.config().getConfig(this.configPath());
    }

    public long net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageTimeToLiveInMillis() {
        return ((Duration)net.shrine.config.package$.MODULE$.ConfigExtensions(this.config()).get("messageTimeToLive", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$1) {
                return Duration$.MODULE$.apply(x$1);
            }
        })).toMillis();
    }

    public long net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageRedeliveryDelay() {
        return ((Duration)net.shrine.config.package$.MODULE$.ConfigExtensions(this.config()).get("messageRedeliveryDelay", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$2) {
                return Duration$.MODULE$.apply(x$2);
            }
        })).toMillis();
    }

    public int net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageMaxDeliveryAttempts() {
        return this.config().getInt("messageMaxDeliveryAttempts");
    }

    public TrieMap<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
        }
        throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 42");
    }

    public List<Runnable> stop() {
        return LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.shutDown();
    }

    public Map<String, BlockingDeque<InternalMessage>> blockingQueuePool() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.blockingQueuePool;
        }
        throw new UninitializedFieldError("Uninitialized field: LocalMessageQueueMiddleware.scala: 53");
    }

    public Try<Queue> createQueueIfAbsent(String queueName) {
        return Try$.MODULE$.apply((Function0)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            private final String queueName$1;

            public final Queue apply() {
                LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().getOrElseUpdate((Object)this.queueName$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinkedBlockingDeque<InternalMessage> apply() {
                        return new LinkedBlockingDeque<InternalMessage>();
                    }
                });
                return new Queue(this.queueName$1);
            }
            {
                this.queueName$1 = queueName$1;
            }
        });
    }

    public Try<BoxedUnit> deleteQueue(String queueName) {
        return Try$.MODULE$.apply((Function0)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().remove((Object)this.queueName$2).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.deleteQueue.1 $outer;

                    public final Nothing$ apply() {
                        throw new QueueDoesNotExistException(new Queue(this.$outer.queueName$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.queueName$2 = queueName$2;
            }
        });
    }

    public Try<scala.collection.immutable.Seq<Queue>> queues() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Seq<Queue> apply() {
                return (scala.collection.immutable.Seq)LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Queue apply(String x$3) {
                        return new Queue(x$3);
                    }
                }, scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()));
            }
        });
    }

    public Future<BoxedUnit> send(String contents, Queue to) {
        return Future$.MODULE$.apply((Function0)new Serializable(contents, to){
            public static final long serialVersionUID = 0L;
            private final String contents$1;
            public final Queue to$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BlockingDeque queue = (BlockingDeque)LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().getOrElse((Object)this.to$1.name(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.send.1 $outer;

                    public final Nothing$ apply() {
                        throw new QueueDoesNotExistException(this.$outer.to$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                UUID msgID = UUID.randomUUID();
                InternalMessage internalMessage = new InternalMessage(msgID, this.contents$1, System.currentTimeMillis(), this.to$1, 0);
                LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.scheduleExpiredMessageCleanup(this.to$1, internalMessage, LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageTimeToLiveInMillis());
                package$.MODULE$.blocking((Function0)new Serializable(this, queue, internalMessage){
                    public static final long serialVersionUID = 0L;
                    private final BlockingDeque queue$1;
                    private final InternalMessage internalMessage$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.queue$1.putLast(this.internalMessage$1);
                    }
                    {
                        this.queue$1 = queue$1;
                        this.internalMessage$1 = internalMessage$1;
                    }
                });
                Log$.MODULE$.debug((Function0)new Serializable(this, queue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.send.1 $outer;
                    private final BlockingDeque queue$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After send to ", " - blockingQueue contains ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.to$1.name(), BoxesRunTime.boxToInteger((int)this.queue$1.size())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.queue$1 = queue$1;
                    }
                });
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<Message>> receive(Queue from, Duration timeout) {
        return Future$.MODULE$.apply((Function0)new Serializable(from, timeout){
            public static final long serialVersionUID = 0L;
            public final Queue from$1;
            private final Duration timeout$1;

            public final Option<LocalMessageQueueMiddleware.SimpleMessage> apply() {
                long deadline = System.currentTimeMillis() + this.timeout$1.toMillis();
                BlockingDeque blockingQueue = (BlockingDeque)LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().getOrElse((Object)this.from$1.name(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.receive.1 $outer;

                    public final Nothing$ apply() {
                        throw new QueueDoesNotExistException(this.$outer.from$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Log$.MODULE$.debug((Function0)new Serializable(this, blockingQueue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.receive.1 $outer;
                    private final BlockingDeque blockingQueue$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Before receive from ", " - blockingQueue contains ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.from$1.name(), BoxesRunTime.boxToInteger((int)this.blockingQueue$1.size())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.blockingQueue$1 = blockingQueue$1;
                    }
                });
                Option internalMessageOpt = (Option)package$.MODULE$.blocking((Function0)new Serializable(this, deadline, blockingQueue){
                    public static final long serialVersionUID = 0L;
                    private final long deadline$1;
                    private final BlockingDeque blockingQueue$1;

                    public final Option<InternalMessage> apply() {
                        return Option$.MODULE$.apply(this.blockingQueue$1.pollFirst(this.deadline$1 - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
                    }
                    {
                        this.deadline$1 = deadline$1;
                        this.blockingQueue$1 = blockingQueue$1;
                    }
                });
                UUID deliveryAttemptID = UUID.randomUUID();
                internalMessageOpt.fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.receive.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Log$.MODULE$.debug((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$receive$1$$anonfun$apply$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No message available from the queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$anonfun$$anonfun$$$outer().from$1.name()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.receive.1 net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function1)new Serializable(this, deliveryAttemptID){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.receive.1 $outer;
                    private final UUID deliveryAttemptID$1;

                    public final void apply(InternalMessage internalMessage) {
                        DeliveryAttempt deliveryAttempt = new DeliveryAttempt(internalMessage, internalMessage.createdTime(), this.$outer.from$1);
                        LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.scheduleMessageRedelivery(this.deliveryAttemptID$1, deliveryAttempt, LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageRedeliveryDelay(), LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageMaxDeliveryAttempts());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.deliveryAttemptID$1 = deliveryAttemptID$1;
                    }
                });
                return internalMessageOpt.map((Function1)new Serializable(this, deliveryAttemptID){
                    public static final long serialVersionUID = 0L;
                    private final UUID deliveryAttemptID$1;

                    public final LocalMessageQueueMiddleware.SimpleMessage apply(InternalMessage internalMessage) {
                        return new LocalMessageQueueMiddleware.SimpleMessage(this.deliveryAttemptID$1.toString(), internalMessage.contents());
                    }
                    {
                        this.deliveryAttemptID$1 = deliveryAttemptID$1;
                    }
                });
            }
            {
                this.from$1 = from$1;
                this.timeout$1 = timeout$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> completeMessage(UUID deliveryAttemptID) {
        return Future$.MODULE$.apply((Function0)new Serializable(deliveryAttemptID){
            public static final long serialVersionUID = 0L;
            public final UUID deliveryAttemptID$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option deliveryAttemptAndFutureTaskOpt = LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().get((Object)this.deliveryAttemptID$2);
                deliveryAttemptAndFutureTaskOpt.fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.completeMessage.1 $outer;

                    public final Nothing$ apply() {
                        throw new MessageDoesNotExistAndCannotBeCompletedException(this.$outer.deliveryAttemptID$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>> deliveryAttemptAndFutureTask) {
                        DeliveryAttempt deliveryAttempt = (DeliveryAttempt)deliveryAttemptAndFutureTask._1();
                        InternalMessage internalToBeSentMessage = deliveryAttempt.message();
                        Queue queue = internalToBeSentMessage.toQueue();
                        LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean apply(Tuple2<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> check$ifrefutable$1) {
                                Tuple2<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> tuple2 = check$ifrefutable$1;
                                if (tuple2 == null) return false;
                                UUID uuid = (UUID)tuple2._1();
                                Tuple2 eachDAandTask = (Tuple2)tuple2._2();
                                if (uuid == null) return false;
                                if (!(eachDAandTask instanceof Tuple2)) return false;
                                return true;
                            }
                        }).foreach((Function1)new Serializable(this, internalToBeSentMessage){
                            public static final long serialVersionUID = 0L;
                            private final InternalMessage internalToBeSentMessage$1;

                            public final void apply(Tuple2<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> x$4) {
                                Tuple2<UUID, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> tuple2 = x$4;
                                if (tuple2 != null) {
                                    UUID uuid = (UUID)tuple2._1();
                                    Tuple2 eachDAandTask = (Tuple2)tuple2._2();
                                    if (uuid != null) {
                                        UUID uUID = uuid;
                                        if (eachDAandTask instanceof Tuple2) {
                                            BoxedUnit boxedUnit;
                                            Tuple2 tuple22 = eachDAandTask;
                                            UUID uUID2 = ((DeliveryAttempt)tuple22._1()).message().id();
                                            UUID uUID3 = this.internalToBeSentMessage$1.id();
                                            if (!(uUID2 != null ? !((Object)uUID2).equals(uUID3) : uUID3 != null)) {
                                                LocalMessageQueueMiddleware$.MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().remove((Object)uUID);
                                                LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.cancelScheduledMessageRedelivery((Option)tuple22._2());
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.internalToBeSentMessage$1 = internalToBeSentMessage$1;
                            }
                        });
                        BlockingDeque blockingQueue = (BlockingDeque)LocalMessageQueueMiddleware$.MODULE$.blockingQueuePool().getOrElse((Object)queue.name(), (Function0)new Serializable(this, queue){
                            public static final long serialVersionUID = 0L;
                            private final Queue queue$2;

                            public final Nothing$ apply() {
                                throw new QueueDoesNotExistException(this.queue$2);
                            }
                            {
                                this.queue$2 = queue$2;
                            }
                        });
                        blockingQueue.remove(internalToBeSentMessage);
                        Log$.MODULE$.debug((Function0)new Serializable(this, deliveryAttemptAndFutureTask){
                            public static final long serialVersionUID = 0L;
                            private final Tuple2 deliveryAttemptAndFutureTask$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message from ", " completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((DeliveryAttempt)this.deliveryAttemptAndFutureTask$1._1()).fromQueue()}));
                            }
                            {
                                this.deliveryAttemptAndFutureTask$1 = deliveryAttemptAndFutureTask$1;
                            }
                        });
                    }
                });
            }
            {
                this.deliveryAttemptID$2 = deliveryAttemptID$2;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    private LocalMessageQueueMiddleware$() {
        MODULE$ = this;
        this.configPath = "shrine.messagequeue.blockingq";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap = TrieMap$.MODULE$.empty();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.blockingQueuePool = TrieMap$.MODULE$.empty();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

