/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.http4s.blaze.channel.ChannelHead;
import org.http4s.blaze.channel.ChannelHead$class;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Command$Disconnected$;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.Head$class;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Stage$class;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.BufferTools$;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0003\u00051\u0011aBQ=uK\n+hMZ3s\u0011\u0016\fGM\u0003\u0002\u0004\t\u0005!a.[83\u0015\t)a!A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u001dA\u0011!\u00022mCj,'BA\u0005\u000b\u0003\u0019AG\u000f\u001e95g*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\t%\u0011a\u0003\u0002\u0002\f\u0007\"\fgN\\3m\u0011\u0016\fG\r\u0003\u0005\u0006\u0001\t\u0005\t\u0015!\u0003\u001a\u0007\u0001\u0001\"AG\u0011\u000e\u0003mQ!\u0001H\u000f\u0002\u0011\rD\u0017M\u001c8fYNT!AH\u0010\u0002\u00079LwNC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tZ\"!G!ts:\u001c\u0007N]8o_V\u001c8k\\2lKR\u001c\u0005.\u00198oK2D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u000bEV4g-\u001a:TSj,\u0007C\u0001\b'\u0013\t9sBA\u0002J]RDQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDcA\u0016.]A\u0011A\u0006A\u0007\u0002\u0005!)Q\u0001\u000ba\u00013!)A\u0005\u000ba\u0001K!)\u0001\u0007\u0001C\u0001c\u0005!a.Y7f+\u0005\u0011\u0004CA\u001a7\u001d\tqA'\u0003\u00026\u001f\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)t\u0002C\u0004;\u0001\t\u0007I\u0011B\u001e\u0002\r\t,hMZ3s+\u0005a\u0004CA\u001f?\u001b\u0005i\u0012BA \u001e\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u000f\t,hMZ3sA!)1\t\u0001C!\t\u0006aqO]5uKJ+\u0017/^3tiR\u0011QI\u0014\t\u0004\r&[U\"A$\u000b\u0005!{\u0011AC2p]\u000e,(O]3oi&\u0011!j\u0012\u0002\u0007\rV$XO]3\u0011\u00059a\u0015BA'\u0010\u0005\u0011)f.\u001b;\t\u000b=\u0013\u0005\u0019\u0001\u001f\u0002\t\u0011\fG/\u0019\u0005\u0006\u0007\u0002!\t%\u0015\u000b\u0003\u000bJCQa\u0014)A\u0002M\u00032\u0001\u0016/=\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y1\u00051AH]8pizJ\u0011\u0001E\u0005\u00037>\tq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005m{\u0001\"\u00021\u0001\t\u0003\t\u0017a\u0003:fC\u0012\u0014V-];fgR$\"AY2\u0011\u0007\u0019KE\bC\u0003e?\u0002\u0007Q%\u0001\u0003tSj,\u0007\"\u00024\u0001\t#:\u0017AC2iK\u000e\\WI\u001d:peR\u0011\u0001n\u001b\t\u0003)&L!A\u001b0\u0003\u0013QC'o\\<bE2,\u0007\"\u00027f\u0001\u0004A\u0017!A3\t\u000b9\u0004A\u0011K8\u0002\u001bM$\u0018mZ3TQV$Hm\\<o)\u0005Y\u0005\"B9\u0001\t#\u0012\u0018AD2m_N,w+\u001b;i\u000bJ\u0014xN\u001d\u000b\u0003\u0017NDQ\u0001\u001e9A\u0002!\f\u0011\u0001\u001e\u0005\u0006m\u0002!\tf\\\u0001\tM&t\u0017\r\\5{K\u0002")
public final class ByteBufferHead
implements ChannelHead {
    private final AsynchronousSocketChannel channel;
    private final int bufferSize;
    private final ByteBuffer org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer;
    private Tail<Object> _nextStage;
    private final Logger logger;

    @Override
    public void outboundCommand(Command.OutboundCommand cmd) {
        ChannelHead$class.outboundCommand(this, cmd);
    }

    @Override
    public Tail<ByteBuffer> _nextStage() {
        return this._nextStage;
    }

    @Override
    public void _nextStage_$eq(Tail<ByteBuffer> x$1) {
        this._nextStage = x$1;
    }

    @Override
    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage$class.inboundCommand(this, cmd);
    }

    @Override
    public final void sendInboundCommand(Command.InboundCommand cmd) {
        Head$class.sendInboundCommand(this, cmd);
    }

    @Override
    public void inboundCommand(Command.InboundCommand cmd) {
        Head$class.inboundCommand(this, cmd);
    }

    @Override
    public final void spliceAfter(MidStage<ByteBuffer, ByteBuffer> stage) {
        Head$class.spliceAfter(this, stage);
    }

    @Override
    public final Option<Stage> findInboundStage(String name) {
        return Head$class.findInboundStage((Head)this, name);
    }

    @Override
    public final <C extends Stage> Option<C> findInboundStage(Class<C> clazz) {
        return Head$class.findInboundStage((Head)this, clazz);
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public final void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void stageStartup() {
        Stage$class.stageStartup(this);
    }

    @Override
    public String name() {
        return "ByteBufferHeadStage";
    }

    public ByteBuffer org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer() {
        return this.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer;
    }

    @Override
    public Future<BoxedUnit> writeRequest(ByteBuffer data) {
        if (!data.hasRemaining() && data.position() > 0) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn(new StringBuilder().append((Object)"Received write request with non-zero position but ZERO available").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bytes at ", " on org.http4s.blaze.channel ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date(), this.channel, data}))).toString());
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        Promise p = Promise$.MODULE$.apply();
        this.org$http4s$blaze$channel$nio2$ByteBufferHead$$go$1(data.remaining(), data, p);
        return p.future();
    }

    @Override
    public Future<BoxedUnit> writeRequest(Seq<ByteBuffer> data) {
        Future future;
        if (data.isEmpty()) {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            Promise p = Promise$.MODULE$.apply();
            ByteBuffer[] srcs = (ByteBuffer[])data.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class));
            this.org$http4s$blaze$channel$nio2$ByteBufferHead$$go$2(0, p, srcs);
            future = p.future();
        }
        return future;
    }

    @Override
    public Future<ByteBuffer> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer().clear();
        Object object = size >= 0 && size < this.bufferSize ? this.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer().limit(size) : BoxedUnit.UNIT;
        this.channel.read(this.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer(), null, new CompletionHandler<Integer, Null$>(this, p){
            private final /* synthetic */ ByteBufferHead $outer;
            private final Promise p$3;

            public void failed(Throwable exc, Null$ attachment) {
                Throwable e = this.$outer.checkError(exc);
                this.$outer.sendInboundCommand(Command$Disconnected$.MODULE$);
                this.$outer.closeWithError(e);
                this.p$3.tryFailure(e);
            }

            public void completed(Integer i, Null$ attachment) {
                if (i >= 0) {
                    this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer().flip();
                    ByteBuffer b = ByteBuffer.allocate(this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer().remaining());
                    b.put(this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer()).flip();
                    this.p$3.trySuccess((Object)b);
                } else {
                    this.$outer.sendInboundCommand(Command$Disconnected$.MODULE$);
                    this.$outer.closeWithError(Command$EOF$.MODULE$);
                    this.p$3.tryFailure((Throwable)Command$EOF$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$3 = p$3;
            }
        });
        return p.future();
    }

    @Override
    public Throwable checkError(Throwable e) {
        Throwable throwable;
        block4: {
            Throwable throwable2;
            block3: {
                block2: {
                    throwable = e;
                    if (!(throwable instanceof ShutdownChannelGroupException)) break block2;
                    ShutdownChannelGroupException shutdownChannelGroupException = (ShutdownChannelGroupException)throwable;
                    this.logger().debug("Channel Group was shutdown", (Throwable)shutdownChannelGroupException);
                    throwable2 = Command$EOF$.MODULE$;
                    break block3;
                }
                if (throwable == null) break block4;
                Throwable throwable3 = throwable;
                throwable2 = ChannelHead$class.checkError(this, throwable3);
            }
            return throwable2;
        }
        throw new MatchError((Object)throwable);
    }

    @Override
    public void stageShutdown() {
        this.closeWithError(Command$EOF$.MODULE$);
    }

    @Override
    public void closeWithError(Throwable t) {
        Throwable throwable = t;
        if (Command$EOF$.MODULE$.equals(throwable)) {
            BoxedUnit boxedUnit;
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closeWithError(EOF)"})).s((Seq)Nil$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logger().error("NIO2 channel closed with an unexpected error", throwable);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() {
        if (this.channel.isOpen()) {
            this.logger().warn("ByteBufferHead hasn't been shutdown before going out of scope, potentially leaking a file descriptor.");
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public final void org$http4s$blaze$channel$nio2$ByteBufferHead$$go$1(int i, ByteBuffer data$1, Promise p$1) {
        this.channel.write(data$1, null, new CompletionHandler<Integer, Null$>(this, data$1, p$1, i){
            private final /* synthetic */ ByteBufferHead $outer;
            private final ByteBuffer data$1;
            private final Promise p$1;
            private final int i$1;

            public void failed(Throwable exc, Null$ attachment) {
                Throwable e = this.$outer.checkError(exc);
                this.$outer.sendInboundCommand(Command$Disconnected$.MODULE$);
                this.$outer.closeWithError(e);
                this.p$1.tryFailure(e);
            }

            public void completed(Integer result, Null$ attachment) {
                Boolean bl;
                if (result < this.i$1) {
                    this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$go$1(this.i$1 - result, this.data$1, this.p$1);
                    bl = BoxedUnit.UNIT;
                } else {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.p$1.trySuccess((Object)BoxedUnit.UNIT));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.data$1 = data$1;
                this.p$1 = p$1;
                this.i$1 = i$1;
            }
        });
    }

    public final void org$http4s$blaze$channel$nio2$ByteBufferHead$$go$2(int index, Promise p$2, ByteBuffer[] srcs$1) {
        this.channel.write(srcs$1, index, srcs$1.length - index, -1L, TimeUnit.MILLISECONDS, null, new CompletionHandler<Long, Null$>(this, p$2, srcs$1){
            private final /* synthetic */ ByteBufferHead $outer;
            private final Promise p$2;
            private final ByteBuffer[] srcs$1;

            public void failed(Throwable exc, Null$ attachment) {
                Throwable e = this.$outer.checkError(exc);
                this.$outer.sendInboundCommand(Command$Disconnected$.MODULE$);
                this.$outer.closeWithError(e);
                this.p$2.tryFailure(e);
            }

            public void completed(Long result, Null$ attachment) {
                if (BufferTools$.MODULE$.checkEmpty(this.srcs$1)) {
                    this.p$2.trySuccess((Object)BoxedUnit.UNIT);
                } else {
                    this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$go$2(BufferTools$.MODULE$.dropEmpty(this.srcs$1), this.p$2, this.srcs$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$2 = p$2;
                this.srcs$1 = srcs$1;
            }
        });
    }

    public ByteBufferHead(AsynchronousSocketChannel channel, int bufferSize) {
        this.channel = channel;
        this.bufferSize = bufferSize;
        Stage$class.$init$(this);
        Head$class.$init$(this);
        ChannelHead$class.$init$(this);
        this.org$http4s$blaze$channel$nio2$ByteBufferHead$$buffer = ByteBuffer.allocateDirect(bufferSize);
    }
}

