/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline;

import java.util.concurrent.TimeoutException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Command$Connected$;
import org.http4s.blaze.pipeline.Command$Disconnected$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Cancellable;
import org.http4s.blaze.util.Execution$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.util.Try;

public abstract class Tail$class {
    public static Future channelRead(Tail $this, int size, Duration timeout) {
        try {
            Future future;
            if ($this._prevStage() == null) {
                future = Tail$class._stageDisconnected($this);
            } else {
                Future f = $this._prevStage().readRequest(size);
                future = Tail$class.checkTimeout($this, timeout, f);
            }
            return future;
        }
        catch (Throwable throwable) {
            return Future$.MODULE$.failed(throwable);
        }
    }

    public static int channelRead$default$1(Tail $this) {
        return -1;
    }

    public static Duration channelRead$default$2(Tail $this) {
        return Duration$.MODULE$.Inf();
    }

    public static Future channelWrite(Tail $this, Object data) {
        Future future;
        if ($this._prevStage() == null) {
            future = Tail$class._stageDisconnected($this);
        } else {
            try {
                future = $this._prevStage().writeRequest(data);
            }
            catch (Throwable throwable) {
                future = Future$.MODULE$.failed(throwable);
            }
        }
        return future;
    }

    public static final Future channelWrite(Tail $this, Object data, Duration timeout) {
        Future<BoxedUnit> f = $this.channelWrite(data);
        return Tail$class.checkTimeout($this, timeout, f);
    }

    public static Future channelWrite(Tail $this, Seq data) {
        Future future;
        if ($this._prevStage() == null) {
            future = Tail$class._stageDisconnected($this);
        } else {
            try {
                future = $this._prevStage().writeRequest(data);
            }
            catch (Throwable throwable) {
                future = Future$.MODULE$.failed(throwable);
            }
        }
        return future;
    }

    public static final Future channelWrite(Tail $this, Seq data, Duration timeout) {
        Future<BoxedUnit> f = $this.channelWrite(data);
        return Tail$class.checkTimeout($this, timeout, f);
    }

    public static final void spliceBefore(Tail $this, MidStage stage) {
        if ($this._prevStage() == null) {
            Exception e = new Exception("Cannot splice stage before a disconnected stage");
            $this.logger().error("", (Throwable)e);
            throw e;
        }
        stage._prevStage_$eq($this._prevStage());
        stage._nextStage_$eq($this);
        $this._prevStage()._nextStage_$eq(stage);
        $this._prevStage_$eq(stage);
    }

    public static final void sendOutboundCommand(Tail $this, Command.OutboundCommand cmd) {
        if ($this.logger().isDebugEnabled()) {
            $this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stage ", " sending outbound command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getClass().getSimpleName(), cmd})));
        }
        if ($this._prevStage() == null) {
            Exception e = new Exception("Cannot send outbound command on disconnected stage");
            $this.logger().error("", (Throwable)e);
            throw e;
        }
        try {
            $this._prevStage().outboundCommand(cmd);
        }
        catch (Throwable throwable) {
            $this.logger().error("Outbound command caused an error", throwable);
        }
    }

    public static final Option findOutboundStage(Tail $this, String name) {
        None$ none$;
        String string = $this.name();
        String string2 = name;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = new Some((Object)$this);
        } else if ($this._prevStage() == null) {
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            Head head = $this._prevStage();
            if (head instanceof Tail) {
                Head head2 = head;
                none$2 = ((Tail)((Object)head2)).findOutboundStage(name);
            } else {
                String string3 = head.name();
                String string4 = name;
                none$2 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new Some(head) : None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public static final Option findOutboundStage(Tail $this, Class clazz) {
        Some some;
        if (clazz.isAssignableFrom($this.getClass())) {
            some = new Some((Object)$this);
        } else if ($this._prevStage() == null) {
            some = None$.MODULE$;
        } else {
            None$ none$;
            Head head = $this._prevStage();
            if (head instanceof Tail) {
                Head head2 = head;
                none$ = ((Tail)((Object)head2)).findOutboundStage(clazz);
            } else {
                none$ = clazz.isAssignableFrom(head.getClass()) ? new Some(head) : None$.MODULE$;
            }
            some = none$;
        }
        return some;
    }

    public static final Tail replaceInline(Tail $this, LeafBuilder leafBuilder, boolean startup) {
        Head head;
        block9: {
            Head prev;
            block8: {
                Object object;
                block7: {
                    $this.stageShutdown();
                    if ($this._prevStage() == null) {
                        return $this;
                    }
                    Tail tail = $this;
                    if (tail instanceof MidStage) {
                        MidStage midStage = (MidStage)tail;
                        midStage.sendInboundCommand(Command$Disconnected$.MODULE$);
                        midStage._nextStage_$eq(null);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    prev = $this._prevStage();
                    $this._prevStage()._nextStage_$eq(null);
                    $this._prevStage_$eq(null);
                    head = prev;
                    if (!(head instanceof MidStage)) break block7;
                    MidStage midStage = (MidStage)head;
                    object = leafBuilder.prepend(midStage);
                    break block8;
                }
                if (!(head instanceof HeadStage)) break block9;
                HeadStage headStage = (HeadStage)head;
                object = leafBuilder.base(headStage);
            }
            if (startup) {
                prev.sendInboundCommand(Command$Connected$.MODULE$);
            }
            return $this;
        }
        throw new MatchError(head);
    }

    public static final boolean replaceInline$default$2(Tail $this) {
        return true;
    }

    private static Future checkTimeout(Tail $this, Duration timeout, Future f) {
        Future future;
        if (timeout.isFinite()) {
            Promise p = Promise$.MODULE$.apply();
            Tail$class.scheduleTimeout($this, p, f, timeout);
            future = p.future();
        } else {
            future = f;
        }
        return future;
    }

    private static void scheduleTimeout(Tail $this, Promise p, Future f, Duration timeout) {
        Runnable r = new Runnable($this, p){
            private final Promise p$1;

            public void run() {
                TimeoutException a = new TimeoutException("Read request timed out");
                this.p$1.tryFailure((Throwable)a);
            }
            {
                this.p$1 = p$1;
            }
        };
        Cancellable ecf = Execution$.MODULE$.scheduler().schedule(r, timeout);
        f.onComplete((Function1)new Serializable($this, p, ecf){
            public static final long serialVersionUID = 0L;
            private final Promise p$1;
            private final Cancellable ecf$1;

            public final boolean apply(Try<Object> t) {
                this.ecf$1.cancel();
                return this.p$1.tryComplete(t);
            }
            {
                void var3_3;
                this.p$1 = p$1;
                this.ecf$1 = var3_3;
            }
        }, Execution$.MODULE$.directec());
    }

    private static Future _stageDisconnected(Tail $this) {
        return Future$.MODULE$.failed((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This stage '", "' isn't connected!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name()}))));
    }

    public static void $init$(Tail $this) {
        $this._prevStage_$eq(null);
    }
}

