/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http20;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http20.Http20FrameDecoder;
import org.http4s.blaze.http.http20.Http2Exception$;
import org.http4s.blaze.http.http20.Http2Settings;
import org.http4s.blaze.http.http20.Http2Settings$Setting$;
import org.http4s.blaze.http.http20.bits$;
import org.http4s.blaze.http.http20.bits$Flags$;
import org.http4s.blaze.http.http20.bits$FrameTypes$;
import org.http4s.blaze.http.http20.bits$Masks$;
import org.http4s.blaze.http.http20.package;
import org.http4s.blaze.http.http20.package$BufferUnderflow$;
import org.http4s.blaze.http.http20.package$Continue$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class Http20FrameDecoder$class {
    public static package.Http2Result decodeBuffer(Http20FrameDecoder $this, ByteBuffer buffer) {
        package.Http2Result http2Result;
        if (buffer.remaining() < bits$.MODULE$.HeaderSize()) {
            return package$BufferUnderflow$.MODULE$;
        }
        buffer.mark();
        int len = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        byte frameType = buffer.get();
        byte flags = buffer.get();
        int streamId = buffer.getInt() & bits$Masks$.MODULE$.STREAMID();
        if (len > $this.http2Settings().maxFrameSize()) {
            http2Result = new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP2 packet is to large to handle."})).s((Seq)Nil$.MODULE$), streamId, true));
        } else if ($this.handler().inHeaderSequence() && frameType != bits$FrameTypes$.MODULE$.CONTINUATION()) {
            http2Result = Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received frame type ", " while in in headers sequence"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)frameType)})));
        } else if (len > buffer.remaining()) {
            buffer.reset();
            http2Result = package$BufferUnderflow$.MODULE$;
        } else {
            int oldLimit = buffer.limit();
            int endOfFrame = buffer.position() + len;
            buffer.limit(endOfFrame);
            byte by = frameType;
            package.Http2Result http2Result2 = bits$FrameTypes$.MODULE$.DATA() == by ? Http20FrameDecoder$class.decodeDataFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.HEADERS() == by ? Http20FrameDecoder$class.decodeHeaderFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PRIORITY() == by ? Http20FrameDecoder$class.decodePriorityFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.RST_STREAM() == by ? Http20FrameDecoder$class.decodeRstStreamFrame($this, buffer, streamId) : (bits$FrameTypes$.MODULE$.SETTINGS() == by ? Http20FrameDecoder$class.decodeSettingsFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by ? Http20FrameDecoder$class.decodePushPromiseFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PING() == by ? Http20FrameDecoder$class.decodePingFrame($this, buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.GOAWAY() == by ? Http20FrameDecoder$class.decodeGoAwayFrame($this, buffer, streamId) : (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by ? Http20FrameDecoder$class.decodeWindowUpdateFrame($this, buffer, streamId) : (bits$FrameTypes$.MODULE$.CONTINUATION() == by ? Http20FrameDecoder$class.decodeContinuationFrame($this, buffer, streamId, flags) : $this.onExtensionFrame(by, streamId, flags, buffer.slice()))))))))));
            package.Http2Result r = http2Result2;
            buffer.limit(oldLimit);
            buffer.position(endOfFrame);
            http2Result = r;
        }
        return http2Result;
    }

    public static package.Http2Result onExtensionFrame(Http20FrameDecoder $this, int code, int streamId, byte flags, ByteBuffer buffer) {
        return $this.handler().onExtensionFrame(code, streamId, flags, buffer);
    }

    private static package.Http2Result decodeDataFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "Data frame with streamID 0x0");
        }
        int payload = buffer.remaining();
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = Http20FrameDecoder$class.limitPadding($this, buffer)).success()) {
            return r;
        }
        return $this.handler().onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), payload);
    }

    private static package.Http2Result decodeHeaderFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "Headers frame with streamID 0x0");
        }
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = Http20FrameDecoder$class.limitPadding($this, buffer)).success()) {
            return r;
        }
        None$ priority = bits$Flags$.MODULE$.PRIORITY(flags) ? new Some((Object)Http20FrameDecoder$class.getPriority($this, buffer)) : None$.MODULE$;
        return priority.isDefined() && ((package.Priority)priority.get()).dependentStreamId() == streamId ? Http20FrameDecoder$class.protoError($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header stream depends on itself"})).s((Seq)Nil$.MODULE$), streamId) : $this.handler().onHeadersFrame(streamId, (Option<package.Priority>)priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
    }

    private static package.Http2Result decodePriorityFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        if (streamId == 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "Priority frame with streamID 0x0");
        }
        if (buffer.remaining() != 5) {
            String msg = new StringBuilder().append((Object)"Invalid PRIORITY frame size, required 5, received").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, false));
        }
        package.Priority priority = Http20FrameDecoder$class.getPriority($this, buffer);
        return priority.dependentStreamId() == 0 ? Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "Priority frame with stream dependency 0x0") : (priority.dependentStreamId() == streamId ? Http20FrameDecoder$class.protoError($this, "Priority frame depends on itself", streamId) : $this.handler().onPriorityFrame(streamId, priority));
    }

    private static package.Priority getPriority(Http20FrameDecoder $this, ByteBuffer buffer) {
        int rawInt = buffer.getInt();
        int priority = (buffer.get() & 0xFF) + 1;
        boolean ex = bits$Flags$.MODULE$.DepExclusive(rawInt);
        return new package.Priority(bits$Flags$.MODULE$.DepID(rawInt), ex, priority);
    }

    private static package.Http2Result decodeRstStreamFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId) {
        if (buffer.remaining() != 4) {
            String msg = new StringBuilder().append((Object)"Invalid RST_STREAM frame size, required 4, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (streamId == 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "RST_STREAM frame with stream ID 0");
        }
        int code = buffer.getInt();
        return $this.handler().onRstStreamFrame(streamId, code);
    }

    private static package.Http2Result decodeSettingsFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        int len = buffer.remaining();
        boolean isAck = bits$Flags$.MODULE$.ACK(flags);
        int settingsCount = len / 6;
        if (len % 6 != 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame payload must be multiple of 6 bytes, size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)len)}));
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (isAck && settingsCount != 0) {
            String msg = "SETTINGS ACK frame with settings payload";
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (streamId != 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame with invalid stream id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)streamId)})));
        }
        ArrayBuffer settings = new ArrayBuffer(settingsCount);
        Http20FrameDecoder$class.go$1($this, settingsCount, buffer, settings);
        return $this.handler().onSettingsFrame(isAck, (Seq<Http2Settings.Setting>)settings);
    }

    private static package.Http2Result decodePushPromiseFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "Data frame with streamID 0x0");
        }
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = Http20FrameDecoder$class.limitPadding($this, buffer)).success()) {
            return r;
        }
        int promisedId = buffer.getInt() & bits$Masks$.MODULE$.int31();
        return $this.handler().onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
    }

    private static package.Http2Result decodePingFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        int pingSize = 8;
        if (streamId != 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "PING frame with streamID != 0x0");
        }
        if (buffer.remaining() != pingSize) {
            String msg = new StringBuilder().append((Object)"Invalid PING frame size. Expected 4, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, true));
        }
        byte[] pingBytes = new byte[pingSize];
        buffer.get(pingBytes);
        return $this.handler().onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
    }

    private static package.Http2Result decodeGoAwayFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId) {
        if (buffer.remaining() < 8) {
            String msg = new StringBuilder().append((Object)"GOAWAY frame is wrong size. Expected  > 8, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, true));
        }
        if (streamId != 0) {
            return Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, "GOAWAY frame with streamID != 0x0");
        }
        int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
        long code = (long)buffer.getInt() & 0xFFFFFFFFL;
        return $this.handler().onGoAwayFrame(lastStream, code, buffer.slice());
    }

    private static package.Http2Result decodeWindowUpdateFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId) {
        if (buffer.remaining() != 4) {
            String msg = new StringBuilder().append((Object)"WINDOW_UPDATE frame frame is wrong size. Expected 8, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        int size = buffer.getInt() & bits$Masks$.MODULE$.int31();
        return $this.handler().onWindowUpdateFrame(streamId, size);
    }

    private static package.Http2Result decodeContinuationFrame(Http20FrameDecoder $this, ByteBuffer buffer, int streamId, byte flags) {
        package.Http2Result http2Result;
        if (streamId <= 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTINUATION frame with invalid stream dependency: 0x", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toHexString(streamId)}));
            http2Result = Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, msg);
        } else {
            http2Result = $this.handler().onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
        }
        return http2Result;
    }

    public static package.Error org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(Http20FrameDecoder $this, String msg) {
        return new package.Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().apply(msg, true));
    }

    private static package.Error protoError(Http20FrameDecoder $this, String msg, int stream) {
        return new package.Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().apply(msg, stream, true));
    }

    private static package.MaybeError limitPadding(Http20FrameDecoder $this, ByteBuffer buffer) {
        Product product;
        int padding = buffer.get() & 0xFF;
        if (padding > 0) {
            if (padding >= buffer.remaining()) {
                product = Http20FrameDecoder$class.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Padding, ", ", exceeds payload length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)padding), BoxesRunTime.boxToInteger((int)buffer.remaining())})));
            } else {
                buffer.limit(buffer.limit() - padding);
                product = package$Continue$.MODULE$;
            }
        } else {
            product = package$Continue$.MODULE$;
        }
        return product;
    }

    private static final void go$1(Http20FrameDecoder $this, int remaining, ByteBuffer buffer$1, ArrayBuffer settings$1) {
        while (remaining > 0) {
            int id = buffer$1.getShort() & 0xFFFF;
            long value = (long)buffer$1.getInt() & 0xFFFFFFFFL;
            settings$1.$plus$eq((Object)Http2Settings$Setting$.MODULE$.apply(id, value));
            --remaining;
        }
    }

    public static void $init$(Http20FrameDecoder $this) {
    }
}

