/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http20;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http20.Http20FrameEncoder;
import org.http4s.blaze.http.http20.Http2Settings;
import org.http4s.blaze.http.http20.bits$;
import org.http4s.blaze.http.http20.bits$Flags$;
import org.http4s.blaze.http.http20.bits$FrameTypes$;
import org.http4s.blaze.http.http20.bits$Masks$;
import org.http4s.blaze.http.http20.package;
import org.http4s.blaze.util.BufferTools$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public abstract class Http20FrameEncoder$class {
    public static Seq mkDataFrame(Http20FrameEncoder $this, ByteBuffer data, int streamId, boolean isLast, byte padding) {
        Predef$.MODULE$.require(streamId > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bad DATA frame stream ID";
            }
        });
        Predef$.MODULE$.require(padding >= 0 && padding <= 256, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid padding of DATA frame";
            }
        });
        int flags = 0;
        if (padding > 0) {
            flags |= bits$Flags$.MODULE$.PADDED();
        }
        if (isLast) {
            flags |= bits$Flags$.MODULE$.END_STREAM();
        }
        ByteBuffer headerBuffer = ByteBuffer.allocate(bits$.MODULE$.HeaderSize() + (padding > 0 ? 1 : 0));
        Http20FrameEncoder$class.writeFrameHeader($this, data.remaining() + padding, bits$FrameTypes$.MODULE$.DATA(), (byte)flags, streamId, headerBuffer);
        Object object = padding > 0 ? headerBuffer.put((byte)(padding - 1)) : BoxedUnit.UNIT;
        headerBuffer.flip();
        ByteBuffer byteBuffer = headerBuffer;
        ByteBuffer byteBuffer2 = data;
        return Http20FrameEncoder$class.paddedTail($this, padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public static Seq mkHeaderFrame(Http20FrameEncoder $this, ByteBuffer headerData, int streamId, Option priority, boolean end_headers, boolean end_stream, int padding) {
        Option option;
        block9: {
            ByteBuffer header;
            block8: {
                block7: {
                    Predef$.MODULE$.require(streamId > 0, (Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "bad HEADER frame stream ID";
                        }
                    });
                    Predef$.MODULE$.require(padding >= 0 && padding <= 256, (Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Invalid padding of HEADER frame";
                        }
                    });
                    int flags = 0;
                    int size1 = bits$.MODULE$.HeaderSize();
                    if (padding > 0) {
                        ++size1;
                        flags |= bits$Flags$.MODULE$.PADDED();
                    }
                    if (priority.nonEmpty()) {
                        size1 += 5;
                        flags |= bits$Flags$.MODULE$.PRIORITY();
                    }
                    if (end_headers) {
                        flags |= bits$Flags$.MODULE$.END_HEADERS();
                    }
                    if (end_stream) {
                        flags |= bits$Flags$.MODULE$.END_STREAM();
                    }
                    header = BufferTools$.MODULE$.allocate(size1);
                    Http20FrameEncoder$class.writeFrameHeader($this, size1 - bits$.MODULE$.HeaderSize() + headerData.remaining(), bits$FrameTypes$.MODULE$.HEADERS(), (byte)flags, streamId, header);
                    Object object = padding > 0 ? header.put((byte)(padding - 1)) : BoxedUnit.UNIT;
                    option = priority;
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    package.Priority p = (package.Priority)some.x();
                    Http20FrameEncoder$class.writePriority($this, p, header);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                if (!None$.MODULE$.equals(option)) break block9;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            header.flip();
            ByteBuffer byteBuffer = header;
            ByteBuffer byteBuffer2 = headerData;
            return Http20FrameEncoder$class.paddedTail($this, padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
        }
        throw new MatchError((Object)option);
    }

    public static ByteBuffer mkPriorityFrame(Http20FrameEncoder $this, int streamId, package.Priority priority) {
        Predef$.MODULE$.require(streamId > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid streamID for PRIORITY frame";
            }
        });
        int size = 5;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        Http20FrameEncoder$class.writeFrameHeader($this, size, bits$FrameTypes$.MODULE$.PRIORITY(), (byte)0, streamId, buffer);
        Http20FrameEncoder$class.writePriority($this, priority, buffer);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer mkRstStreamFrame(Http20FrameEncoder $this, int streamId, int errorCode) {
        Predef$.MODULE$.require(streamId > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid RST_STREAM stream ID";
            }
        });
        int size = 4;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        Http20FrameEncoder$class.writeFrameHeader($this, size, bits$FrameTypes$.MODULE$.RST_STREAM(), (byte)0, streamId, buffer);
        buffer.putInt(errorCode);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer mkSettingsFrame(Http20FrameEncoder $this, boolean ack, Seq settings) {
        Predef$.MODULE$.require(!ack || settings.isEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting acknowledgement must be empty";
            }
        });
        int size = settings.length() * 6;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        byte flags = ack ? bits$Flags$.MODULE$.ACK() : (byte)0;
        Http20FrameEncoder$class.writeFrameHeader($this, size, bits$FrameTypes$.MODULE$.SETTINGS(), flags, 0, buffer);
        if (!ack) {
            settings.foreach((Function1)new Serializable($this, buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final ByteBuffer apply(Http2Settings.Setting x0$1) {
                    Http2Settings.Setting setting = x0$1;
                    if (setting != null) {
                        Http2Settings.SettingKey k = setting.key();
                        long v = setting.value();
                        ByteBuffer byteBuffer = this.buffer$1.putShort(k.toShort()).putInt((int)v);
                        return byteBuffer;
                    }
                    throw new MatchError((Object)setting);
                }
                {
                    this.buffer$1 = buffer$1;
                }
            });
        }
        buffer.flip();
        return buffer;
    }

    public static Seq mkPushPromiseFrame(Http20FrameEncoder $this, int streamId, int promiseId, boolean end_headers, int padding, ByteBuffer headerBuffer) {
        Predef$.MODULE$.require(streamId != 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid StreamID for PUSH_PROMISE frame";
            }
        });
        Predef$.MODULE$.require(promiseId != 0 && promiseId % 2 == 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid StreamID for PUSH_PROMISE frame";
            }
        });
        Predef$.MODULE$.require(0 <= padding && padding <= 256, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid padding of HEADER frame";
            }
        });
        int size = 4;
        int flags = 0;
        if (end_headers) {
            flags |= bits$Flags$.MODULE$.END_HEADERS();
        }
        if (padding > 0) {
            flags |= bits$Flags$.MODULE$.PADDED();
            size += padding;
        }
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + (padding > 0 ? 5 : 4));
        Http20FrameEncoder$class.writeFrameHeader($this, size + headerBuffer.remaining(), bits$FrameTypes$.MODULE$.PUSH_PROMISE(), (byte)flags, streamId, buffer);
        Object object = padding > 0 ? buffer.put((byte)(padding - 1)) : BoxedUnit.UNIT;
        buffer.putInt(promiseId);
        buffer.flip();
        ByteBuffer byteBuffer = buffer;
        ByteBuffer byteBuffer2 = headerBuffer;
        return Http20FrameEncoder$class.paddedTail($this, padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public static ByteBuffer mkPingFrame(Http20FrameEncoder $this, boolean ack, byte[] data) {
        int size = 8;
        Predef$.MODULE$.require(data.length == size, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ping data must be 8 bytes long";
            }
        });
        byte flags = ack ? bits$Flags$.MODULE$.ACK() : (byte)0;
        ByteBuffer buffer = ByteBuffer.allocate(bits$.MODULE$.HeaderSize() + size);
        Http20FrameEncoder$class.writeFrameHeader($this, size, bits$FrameTypes$.MODULE$.PING(), flags, 0, buffer);
        buffer.put(data).flip();
        return buffer;
    }

    public static Seq mkGoAwayFrame(Http20FrameEncoder $this, int lastStreamId, long error, ByteBuffer debugData) {
        Predef$.MODULE$.require(lastStreamId >= 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid last stream id for GOAWAY frame";
            }
        });
        int size = 8;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        Http20FrameEncoder$class.writeFrameHeader($this, size + debugData.remaining(), bits$FrameTypes$.MODULE$.GOAWAY(), (byte)0, 0, buffer);
        buffer.putInt(lastStreamId & bits$Masks$.MODULE$.int31()).putInt((int)error).flip();
        ByteBuffer byteBuffer = buffer;
        ByteBuffer byteBuffer2 = debugData;
        return Nil$.MODULE$.$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public static ByteBuffer mkWindowUpdateFrame(Http20FrameEncoder $this, int streamId, int increment) {
        Predef$.MODULE$.require(streamId >= 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid stream ID for WINDOW_UPDATE";
            }
        });
        Predef$.MODULE$.require(0 < increment && increment <= Integer.MAX_VALUE, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid stream increment for WINDOW_UPDATE";
            }
        });
        int size = 4;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        Http20FrameEncoder$class.writeFrameHeader($this, size, bits$FrameTypes$.MODULE$.WINDOW_UPDATE(), (byte)0, streamId, buffer);
        buffer.putInt(bits$Masks$.MODULE$.int31() & increment).flip();
        return buffer;
    }

    public static Seq mkContinuationFrame(Http20FrameEncoder $this, int streamId, boolean end_headers, ByteBuffer headerBuffer) {
        Predef$.MODULE$.require(streamId > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid stream ID for CONTINUATION frame";
            }
        });
        byte flag = end_headers ? bits$Flags$.MODULE$.END_HEADERS() : (byte)0;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize());
        Http20FrameEncoder$class.writeFrameHeader($this, headerBuffer.remaining(), bits$FrameTypes$.MODULE$.CONTINUATION(), flag, streamId, buffer);
        buffer.flip();
        ByteBuffer byteBuffer = buffer;
        ByteBuffer byteBuffer2 = headerBuffer;
        return Nil$.MODULE$.$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    private static void writePriority(Http20FrameEncoder $this, package.Priority p, ByteBuffer buffer) {
        buffer.putInt(p.dependentStreamId() | (p.exclusive() ? bits$Masks$.MODULE$.exclusive() : 0));
        buffer.put((byte)(p.priority() - 1 & 0xFF));
    }

    private static List paddedTail(Http20FrameEncoder $this, int padBytes) {
        Nil$ nil$;
        if (padBytes > 0) {
            ByteBuffer byteBuffer = BufferTools$.MODULE$.allocate(padBytes);
            nil$ = Nil$.MODULE$.$colon$colon((Object)byteBuffer);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private static void writeFrameHeader(Http20FrameEncoder $this, int length, byte frameType, byte flags, int streamdId, ByteBuffer buffer) {
        buffer.put((byte)(length >>> 16 & 0xFF)).put((byte)(length >>> 8 & 0xFF)).put((byte)(length & 0xFF)).put(frameType).put(flags).putInt(streamdId & bits$Masks$.MODULE$.STREAMID());
    }

    public static void $init$(Http20FrameEncoder $this) {
    }
}

