/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http_parser;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http_parser.BaseExceptions;
import org.http4s.blaze.http.http_parser.BodyAndHeaderParser;
import org.http4s.blaze.http.http_parser.HttpTokens;

public abstract class Http1ClientParser
extends BodyAndHeaderParser {
    private final int maxRequestLineSize;
    private RequestLineState _requestLineState = RequestLineState.START;
    private String _lineScheme = null;
    private int _majorVersion = 0;
    private int _minorVersion = 0;
    private int _statusCode = 0;

    public Http1ClientParser(int n, int n2, int n3, int n4, boolean bl) {
        super(n3, n2, n4, bl);
        this.maxRequestLineSize = n;
        this._internalReset();
    }

    public Http1ClientParser(int n, boolean bl) {
        this(2048, 40960, n, Integer.MAX_VALUE, bl);
    }

    public Http1ClientParser(boolean bl) {
        this(10240, bl);
    }

    public Http1ClientParser() {
        this(false);
    }

    public final boolean isStartState() {
        return this._requestLineState == RequestLineState.START;
    }

    protected abstract void submitResponseLine(int var1, String var2, String var3, int var4, int var5);

    public final boolean responseLineComplete() {
        return this._requestLineState == RequestLineState.END;
    }

    @Override
    public void shutdownParser() {
        super.shutdownParser();
        this._requestLineState = RequestLineState.END;
    }

    @Override
    public void reset() {
        super.reset();
        this._internalReset();
    }

    private void _internalReset() {
        this._requestLineState = RequestLineState.START;
        this._lineScheme = null;
        this._majorVersion = 0;
        this._minorVersion = 0;
        this._statusCode = 0;
    }

    @Override
    public boolean mustNotHaveBody() {
        return this._statusCode < 200 || this._statusCode == 204 || this._statusCode == 304;
    }

    protected final boolean parseResponseLine(ByteBuffer byteBuffer) throws BaseExceptions.InvalidState, BaseExceptions.BadResponse {
        try {
            switch (this._requestLineState) {
                case START: {
                    this._requestLineState = RequestLineState.VERSION;
                    this.resetLimit(this.maxRequestLineSize);
                }
                case VERSION: {
                    char c = this.next(byteBuffer, false);
                    while (c != ' ' && c != '\t') {
                        if (c == '\uffff') {
                            return false;
                        }
                        this.putChar(c);
                        c = this.next(byteBuffer, false);
                    }
                    this._majorVersion = 1;
                    this._minorVersion = 1;
                    if (this.arrayMatches(HTTP11Bytes) || this.arrayMatches(BodyAndHeaderParser.HTTPS11Bytes)) {
                        this._majorVersion = 1;
                        this._minorVersion = 1;
                    } else if (this.arrayMatches(HTTP10Bytes) || this.arrayMatches(HTTPS10Bytes)) {
                        this._majorVersion = 1;
                        this._minorVersion = 0;
                    } else {
                        String string = "Bad HTTP version: " + this.getString();
                        this.clearBuffer();
                        this.shutdownParser();
                        throw new BaseExceptions.BadResponse(string);
                    }
                    this._lineScheme = this.getString(this.bufferPosition() - 4);
                    this.clearBuffer();
                    this._requestLineState = RequestLineState.SPACE1;
                }
                case SPACE1: {
                    char c = this.next(byteBuffer, false);
                    while (c == ' ' || c == '\t') {
                        c = this.next(byteBuffer, false);
                    }
                    if (c == '\uffff') {
                        return false;
                    }
                    if (!HttpTokens.isDigit(c)) {
                        this.shutdownParser();
                        throw new BaseExceptions.BadResponse("Received invalid token when needed code: '" + c + "'");
                    }
                    this._statusCode = 10 * this._statusCode + (c - 48);
                    this._requestLineState = RequestLineState.STATUS_CODE;
                }
                case STATUS_CODE: {
                    char c = this.next(byteBuffer, false);
                    while (HttpTokens.isDigit(c)) {
                        this._statusCode = 10 * this._statusCode + (c - 48);
                        c = this.next(byteBuffer, false);
                    }
                    if (c == '\uffff') {
                        return false;
                    }
                    if (this._statusCode < 100 || this._statusCode >= 600) {
                        this.shutdownParser();
                        throw new BaseExceptions.BadResponse("Invalid status code '" + this._statusCode + "'. Must be between 100 and 599");
                    }
                    if (c == '\n') {
                        this.endResponseLineParsing("");
                        return true;
                    }
                    if (!HttpTokens.isWhiteSpace(c)) {
                        this.shutdownParser();
                        throw new BaseExceptions.BadResponse("Invalid request: Expected SPACE but found '" + c + "'");
                    }
                    this._requestLineState = RequestLineState.SPACE2;
                }
                case SPACE2: {
                    char c = this.next(byteBuffer, false);
                    while (c == ' ' || c == '\t') {
                        c = this.next(byteBuffer, false);
                    }
                    if (c == '\uffff') {
                        return false;
                    }
                    if (c == '\n') {
                        this.endResponseLineParsing("");
                        return true;
                    }
                    this.putChar(c);
                    this._requestLineState = RequestLineState.REASON;
                }
                case REASON: {
                    char c = this.next(byteBuffer, false);
                    while (c != '\n') {
                        if (c == '\uffff') {
                            return false;
                        }
                        this.putChar(c);
                        c = this.next(byteBuffer, false);
                    }
                    String string = this.getTrimmedString();
                    this.endResponseLineParsing(string);
                    return true;
                }
            }
            throw new BaseExceptions.InvalidState("Attempted to parse Response line when already complete.RequestLineState: '" + (Object)((Object)this._requestLineState) + "'");
        }
        catch (BaseExceptions.BadRequest badRequest2) {
            this.shutdownParser();
            throw new BaseExceptions.BadResponse(badRequest2.getMessage());
        }
    }

    private void endResponseLineParsing(String string) {
        this.clearBuffer();
        this._requestLineState = RequestLineState.END;
        this.submitResponseLine(this._statusCode, string, this._lineScheme, this._majorVersion, this._minorVersion);
    }

    private static enum RequestLineState {
        START,
        VERSION,
        SPACE1,
        STATUS_CODE,
        SPACE2,
        REASON,
        END;

    }
}

