/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.nio.ByteBuffer;
import org.http4s.websocket.FrameTranscoder$;
import org.http4s.websocket.WebsocketBits;
import org.http4s.websocket.WebsocketBits$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ur!B\u0001\u0003\u0011\u0003I\u0011a\u0004$sC6,GK]1og\u000e|G-\u001a:\u000b\u0005\r!\u0011!C<fEN|7m[3u\u0015\t)a!\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002\u000f\u0005\u0019qN]4\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\tyaI]1nKR\u0013\u0018M\\:d_\u0012,'o\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00053\u00059q\nU0D\u001f\u0012+U#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\rIe\u000e\u001e\u0005\u0007=-\u0001\u000b\u0011\u0002\u000e\u0002\u0011=\u0003vlQ(E\u000b\u0002Bq\u0001I\u0006C\u0002\u0013%\u0011$\u0001\u0005G\u0013:K5\u000bS#E\u0011\u0019\u00113\u0002)A\u00055\u0005Ia)\u0013(J'\"+E\t\t\u0005\bI-\u0011\r\u0011\"\u0003\u001a\u0003\u0011i\u0015iU&\t\r\u0019Z\u0001\u0015!\u0003\u001b\u0003\u0015i\u0015iU&!\u0011\u001dA3B1A\u0005\ne\ta\u0001T#O\u000fRC\u0005B\u0002\u0016\fA\u0003%!$A\u0004M\u000b:;E\u000b\u0013\u0011\t\u000f1Z!\u0019!C\u00053\u0005)1\tT(T\u000b\"1af\u0003Q\u0001\ni\taa\u0011'P'\u0016\u0003\u0003b\u0002\u0019\f\u0005\u0004%I!G\u0001\u0005!&su\t\u0003\u00043\u0017\u0001\u0006IAG\u0001\u0006!&su\t\t\u0005\bi-\u0011\r\u0011\"\u0003\u001a\u0003\u0011\u0001vJT$\t\rYZ\u0001\u0015!\u0003\u001b\u0003\u0015\u0001vJT$!\r\u0011A4BA\u001d\u0003\u001dQ\u0013\u0018M\\:d_\u0012,WI\u001d:peN\u0011qG\u000f\t\u0003w\rs!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}B\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t\u0011\u0005#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011+%!C#yG\u0016\u0004H/[8o\u0015\t\u0011\u0005\u0003\u0003\u0005Ho\t\u0015\r\u0011\"\u0001I\u0003\u001diWm]:bO\u0016,\u0012!\u0013\t\u0003\u00156s!aD&\n\u00051\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\t\t\u0011E;$\u0011!Q\u0001\n%\u000b\u0001\"\\3tg\u0006<W\r\t\u0005\u0006+]\"\ta\u0015\u000b\u0003)Z\u0003\"!V\u001c\u000e\u0003-AQa\u0012*A\u0002%CQ\u0001W\u0006\u0005\ne\u000bA\u0002Z3d_\u0012,')\u001b8bef$2A\u00171k!\ry1,X\u0005\u00039B\u0011Q!\u0011:sCf\u0004\"a\u00040\n\u0005}\u0003\"\u0001\u0002\"zi\u0016DQ!Y,A\u0002\t\f!!\u001b8\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017a\u00018j_*\tq-\u0001\u0003kCZ\f\u0017BA5e\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006W^\u0003\rAW\u0001\u0005[\u0006\u001c8\u000eC\u0003n\u0017\u0011%a.\u0001\u0007mK:<G\u000f[(gMN,G\u000f\u0006\u0002\u001b_\")\u0011\r\u001ca\u0001E\")\u0011o\u0003C\u0005e\u00069q-\u001a;NCN\\GC\u0001.t\u0011\u0015\t\u0007\u000f1\u0001c\u0011\u0015)8\u0002\"\u0003w\u0003)\u0011w\u000eZ=MK:<G\u000f\u001b\u000b\u00035]DQ!\u0019;A\u0002\tDQ!_\u0006\u0005\ni\fAbZ3u\u001bN<G*\u001a8hi\"$\"AG>\t\u000b\u0005D\b\u0019\u00012\u0007\t1\u0011\u0001!`\n\u0003y:A\u0011b ?\u0003\u0006\u0004%\t!!\u0001\u0002\u0011%\u001c8\t\\5f]R,\"!a\u0001\u0011\u0007=\t)!C\u0002\u0002\bA\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\fq\u0014\t\u0011)A\u0005\u0003\u0007\t\u0011\"[:DY&,g\u000e\u001e\u0011\t\rUaH\u0011AA\b)\u0011\t\t\"a\u0005\u0011\u0005)a\bbB@\u0002\u000e\u0001\u0007\u00111\u0001\u0005\b\u0003/aH\u0011AA\r\u000351'/Y7f)>\u0014UO\u001a4feR!\u00111DA\u000f!\ry1L\u0019\u0005\bC\u0006U\u0001\u0019AA\u0010!\u0011\t\t#a\n\u000f\u0007)\t\u0019#C\u0002\u0002&\t\tQbV3cg>\u001c7.\u001a;CSR\u001c\u0018\u0002BA\u0015\u0003W\u0011abV3c'>\u001c7.\u001a;Ge\u0006lWMC\u0002\u0002&\tAq!a\f}\t\u0003\t\t$A\u0007ck\u001a4WM\u001d+p\rJ\fW.\u001a\u000b\u0005\u0003?\t\u0019\u0004\u0003\u0004b\u0003[\u0001\rA\u0019")
public class FrameTranscoder {
    private final boolean isClient;

    public boolean isClient() {
        return this.isClient;
    }

    public ByteBuffer[] frameToBuffer(WebsocketBits.WebSocketFrame in) {
        ByteBuffer[] byteBufferArray;
        int size = 2;
        if (this.isClient()) {
            size += 4;
        }
        if (in.length() >= 126) {
            size = in.length() <= 65535 ? (size += 2) : (size += 8);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.isClient() ? size + in.length() : size);
        int opcode = in.opcode();
        if (in.length() > 125 && (opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$PING() || opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$PONG() || opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$CLOSE())) {
            throw new TranscodeError(new StringBuilder().append((Object)"Invalid PING frame: frame too long: ").append((Object)BoxesRunTime.boxToInteger((int)in.length())).toString());
        }
        byte b1 = in.last() ? (byte)((byte)opcode | FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$FINISHED()) : (byte)opcode;
        buff.put(Predef$.MODULE$.int2Integer((int)b1).byteValue());
        byte b2 = 0;
        if (this.isClient()) {
            b2 = (byte)FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$MASK();
        }
        b2 = in.length() < 126 ? (byte)(b2 | in.length()) : (in.length() <= 65535 ? (byte)(b2 | 0x7E) : (byte)(b2 | 0x7F));
        buff.put(Predef$.MODULE$.int2Integer((int)b2).byteValue());
        Object object = in.length() > 125 && in.length() <= 65535 ? buff.put((byte)(in.length() >>> 8 & 0xFF)).put((byte)(in.length() & 0xFF)) : (in.length() > 65535 ? buff.putLong(in.length()) : BoxedUnit.UNIT);
        if (this.isClient() && in.length() > 0) {
            int mask = (int)(Math.random() * (double)Integer.MAX_VALUE);
            byte[] maskBits = new byte[]{(byte)(mask >>> 24 & 0xFF), (byte)(mask >>> 16 & 0xFF), (byte)(mask >>> 8 & 0xFF), (byte)(mask >>> 0 & 0xFF)};
            buff.put(maskBits);
            byte[] data = in.data();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), in.length()).foreach((Function1)new Serializable(this, buff, maskBits, data){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buff$1;
                private final byte[] maskBits$1;
                private final byte[] data$2;

                public final ByteBuffer apply(int i) {
                    return this.buff$1.put((byte)(this.data$2[i] ^ this.maskBits$1[i & 3]));
                }
                {
                    this.buff$1 = buff$1;
                    this.maskBits$1 = maskBits$1;
                    this.data$2 = data$2;
                }
            });
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff});
        } else {
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff, ByteBuffer.wrap(in.data())});
        }
        return byteBufferArray;
    }

    public WebsocketBits.WebSocketFrame bufferToFrame(ByteBuffer in) {
        WebsocketBits.WebSocketFrame webSocketFrame;
        if (in.remaining() < 2 || FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMsgLength(in) < 0) {
            webSocketFrame = null;
        } else {
            byte[] byArray;
            boolean masked;
            int opcode = in.get(0) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$OP_CODE();
            boolean finished = (in.get(0) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$FINISHED()) != 0;
            boolean bl = masked = (in.get(1) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$MASK()) != 0;
            if (masked && this.isClient()) {
                throw new TranscodeError("Client received a masked message");
            }
            int bodyOffset = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$lengthOffset(in);
            if (masked) {
                bodyOffset += 4;
                byArray = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMask(in);
            } else {
                byArray = null;
            }
            byte[] m = byArray;
            int oldLim = in.limit();
            int bodylen = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$bodyLength(in);
            in.position(bodyOffset);
            in.limit(in.position() + bodylen);
            ByteBuffer slice = in.slice();
            in.position(in.limit());
            in.limit(oldLim);
            webSocketFrame = WebsocketBits$.MODULE$.makeFrame(opcode, FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$decodeBinary(slice, m), finished);
        }
        return webSocketFrame;
    }

    public FrameTranscoder(boolean isClient) {
        this.isClient = isClient;
    }

    public static final class TranscodeError
    extends Exception {
        private final String message;

        public String message() {
            return this.message;
        }

        public TranscodeError(String message) {
            this.message = message;
            super(message);
        }
    }
}

