/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import org.http4s.websocket.WebsocketBits;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class WebsocketBits$ {
    public static final WebsocketBits$ MODULE$;
    private final int OP_CODE;
    private final int FINISHED;
    private final int MASK;
    private final int LENGTH;
    private final int RESERVED;
    private final int CONTINUATION;
    private final int TEXT;
    private final int BINARY;
    private final int CLOSE;
    private final int PING;
    private final int PONG;

    static {
        new WebsocketBits$();
    }

    public int OP_CODE() {
        return this.OP_CODE;
    }

    public int FINISHED() {
        return this.FINISHED;
    }

    public int MASK() {
        return this.MASK;
    }

    public int LENGTH() {
        return this.LENGTH;
    }

    public int RESERVED() {
        return this.RESERVED;
    }

    public int CONTINUATION() {
        return this.CONTINUATION;
    }

    public int TEXT() {
        return this.TEXT;
    }

    public int BINARY() {
        return this.BINARY;
    }

    public int CLOSE() {
        return this.CLOSE;
    }

    public int PING() {
        return this.PING;
    }

    public int PONG() {
        return this.PONG;
    }

    public WebsocketBits.WebSocketFrame makeFrame(int opcode, byte[] data, boolean last) throws ProtocolException {
        int n;
        block12: {
            block13: {
                WebsocketBits.WebSocketFrame webSocketFrame;
                block5: {
                    block10: {
                        block11: {
                            block8: {
                                block9: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                n = opcode;
                                                if (this.TEXT() != n) break block4;
                                                webSocketFrame = new WebsocketBits.BinaryText(data, last);
                                                break block5;
                                            }
                                            if (this.BINARY() != n) break block6;
                                            webSocketFrame = new WebsocketBits.Binary(data, last);
                                            break block5;
                                        }
                                        if (this.CONTINUATION() != n) break block7;
                                        webSocketFrame = new WebsocketBits.Continuation(data, last);
                                        break block5;
                                    }
                                    if (this.PING() != n) break block8;
                                    if (!last) break block9;
                                    webSocketFrame = new WebsocketBits.Ping(data);
                                    break block5;
                                }
                                throw new ProtocolException("Control frame cannot be fragmented: Ping");
                            }
                            if (this.PONG() != n) break block10;
                            if (!last) break block11;
                            webSocketFrame = new WebsocketBits.Pong(data);
                            break block5;
                        }
                        throw new ProtocolException("Control frame cannot be fragmented: Pong");
                    }
                    if (this.CLOSE() != n) break block12;
                    if (data.length == 1) {
                        throw new ProtocolException("Close frame must have 0 data bits or at least 2");
                    }
                    if (!last) break block13;
                    webSocketFrame = new WebsocketBits.Close(data);
                }
                return webSocketFrame;
            }
            throw new ProtocolException("Control frame cannot be fragmented: Close");
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private byte[] toUnsignedShort(int x) {
        return (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)(x >> 8 & 0xFF), (byte)(x & 0xFF)}), ClassTag$.MODULE$.Byte());
    }

    public Product org$http4s$websocket$WebsocketBits$$reasonToBytes(String reason) {
        byte[] asBytes = reason.getBytes(StandardCharsets.UTF_8);
        return asBytes.length > 123 ? package$.MODULE$.Left().apply((Object)new WebsocketBits.ReasonTooLongException(reason)) : package$.MODULE$.Right().apply((Object)asBytes);
    }

    public Either<WebsocketBits.InvalidCloseCodeException, byte[]> org$http4s$websocket$WebsocketBits$$closeCodeToBytes(int code) {
        return code < 1000 || code > 4999 ? package$.MODULE$.Left().apply((Object)new WebsocketBits.InvalidCloseCodeException(code)) : package$.MODULE$.Right().apply((Object)this.toUnsignedShort(code));
    }

    private WebsocketBits$() {
        MODULE$ = this;
        this.OP_CODE = 15;
        this.FINISHED = 128;
        this.MASK = 128;
        this.LENGTH = 127;
        this.RESERVED = 14;
        this.CONTINUATION = 0;
        this.TEXT = 1;
        this.BINARY = 2;
        this.CLOSE = 8;
        this.PING = 9;
        this.PONG = 10;
    }
}

