/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeueclient;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.config.Config;
import io.netty.handler.codec.EncoderException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import net.shrine.config.package$;
import net.shrine.log.Log$;
import net.shrine.messagequeueclient.CouldNotInterpretHTTPResponseProblem;
import net.shrine.messagequeueclient.Http4sHttpClient$;
import net.shrine.messagequeueclient.MessageQueueWebClient;
import net.shrine.messagequeueclient.MessageQueueWebClient$;
import net.shrine.messagequeueclient.MessageQueueWebClient$MessageQueueClientMessage$;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskButOKToRetryException$;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskDoNotRetryException;
import net.shrine.messagequeueservice.CouldNotCompleteMomTaskDoNotRetryException$;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.messagequeueservice.Queue;
import net.shrine.source.ConfigSource$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.native.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import spray.can.Http;
import spray.http.HttpEntity;
import spray.http.HttpEntity$;
import spray.http.HttpMethod;
import spray.http.HttpMethods$;
import spray.http.HttpProtocol;
import spray.http.HttpRequest;
import spray.http.HttpRequest$;
import spray.http.HttpResponse;
import spray.http.StatusCode;
import spray.http.StatusCodes;
import spray.http.StatusCodes$;
import spray.http.Uri;
import spray.http.Uri$;

public final class MessageQueueWebClient$
implements MessageQueueService {
    public static final MessageQueueWebClient$ MODULE$;
    private final ActorSystem system;
    private final String configPath;
    private final Duration webClientTimeOut;
    private final String momUrl;
    private final long timeOutWaitGap;
    private final BoxedUnit unit;
    private volatile byte bitmap$init$0;

    static {
        new MessageQueueWebClient$();
    }

    public ActorSystem system() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.system;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 39");
    }

    public String configPath() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.configPath;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 41");
    }

    public Config webClientConfig() {
        return ConfigSource$.MODULE$.config().getConfig("shrine.messagequeue.blockingq");
    }

    public Duration webClientTimeOut() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.webClientTimeOut;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 45");
    }

    public String momUrl() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.momUrl;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 82");
    }

    public long timeOutWaitGap() {
        if ((byte)(this.bitmap$init$0 & 0x10) != 0) {
            return this.timeOutWaitGap;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 83");
    }

    public Try<HttpResponse> webApiTry(HttpRequest request, String operation, Duration timeLimit) {
        return Try$.MODULE$.apply((Function0)new Serializable(request, operation, timeLimit){
            public static final long serialVersionUID = 0L;
            private final HttpRequest request$1;
            private final String operation$1;
            private final Duration timeLimit$1;

            public final HttpResponse apply() {
                long deadline = System.currentTimeMillis() + this.timeLimit$1.toMillis();
                try {
                    return (HttpResponse)Await$.MODULE$.result(MessageQueueWebClient$.MODULE$.webApiFutureWithMOMErrorHandling(this.request$1, this.operation$1, this.timeLimit$1), (Duration)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(deadline + MessageQueueWebClient$.MODULE$.timeOutWaitGap() - System.currentTimeMillis())).milliseconds());
                }
                catch (Throwable throwable) {
                    Log$.MODULE$.debug((Function0)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable x$14;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"webApiTry() caught and rethrew ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$14.toString()}));
                        }
                        {
                            this.x$14 = x$14;
                        }
                    }, throwable);
                    throw throwable;
                }
                catch (Http.ConnectionException connectionException) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$1, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)((Object)connectionException)));
                }
                catch (TimeoutException timeoutException) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$1, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)timeoutException));
                }
            }
            {
                this.request$1 = request$1;
                this.operation$1 = operation$1;
                this.timeLimit$1 = timeLimit$1;
            }
        });
    }

    public Duration webApiTry$default$3() {
        return this.webClientTimeOut();
    }

    public Future<HttpResponse> webApiFutureWithMOMErrorHandling(HttpRequest request, String operation, Duration timeLimit) {
        return Http4sHttpClient$.MODULE$.webApiFuture(request, timeLimit).transform((Function1)new Serializable(operation){
            public static final long serialVersionUID = 0L;
            private final String operation$2;

            public final HttpResponse apply(HttpResponse response) {
                StatusCode statusCode;
                if (response.status().isSuccess()) {
                    return response;
                }
                StatusCode statusCode2 = statusCode = response.status();
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.RequestTimeout();
                if (!(statusCode2 != null ? !statusCode2.equals(clientError) : clientError != null)) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                StatusCode statusCode3 = statusCode;
                StatusCodes.ServerError serverError = StatusCodes$.MODULE$.NetworkConnectTimeout();
                if (!(statusCode3 != null ? !statusCode3.equals(serverError) : serverError != null)) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                StatusCode statusCode4 = statusCode;
                StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.NetworkReadTimeout();
                if (!(statusCode4 != null ? !statusCode4.equals(serverError2) : serverError2 != null)) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                StatusCode statusCode5 = statusCode;
                StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.NotFound();
                if (!(statusCode5 != null ? !statusCode5.equals(clientError2) : clientError2 != null)) {
                    throw new CouldNotCompleteMomTaskDoNotRetryException(this.operation$2, (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
                }
                throw new CouldNotCompleteMomTaskDoNotRetryException(this.operation$2, (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.operation$2 = operation$2;
            }
        }, (Function1)new Serializable(operation){
            public static final long serialVersionUID = 0L;
            private final String operation$2;

            public final Throwable apply(Throwable x0$1) {
                IllegalArgumentException illegalArgumentException;
                Throwable throwable = x0$1;
                if (throwable instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)timeoutException));
                }
                if (throwable instanceof Http.ConnectionException) {
                    Http.ConnectionException connectionException = (Http.ConnectionException)throwable;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)((Object)connectionException)));
                }
                if (throwable instanceof ConnectException) {
                    ConnectException connectException = (ConnectException)throwable;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)connectException));
                }
                if (throwable instanceof EncoderException) {
                    EncoderException encoderException = (EncoderException)throwable;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)encoderException));
                }
                if (throwable instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable).getMessage().contains("request-body-streamer")) {
                    throw new CouldNotCompleteMomTaskButOKToRetryException(this.operation$2, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)illegalArgumentException));
                }
                Log$.MODULE$.debug((Function0)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable x1$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"webApiFutureWithMOMErrorHandling() caught ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1.toString()}));
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                }, throwable);
                throw throwable;
            }
            {
                this.operation$2 = operation$2;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Duration webApiFutureWithMOMErrorHandling$default$3() {
        return this.webClientTimeOut();
    }

    public Try<Queue> createQueueIfAbsent(String queueName) {
        Queue proposedQueue = new Queue(queueName);
        String createQueueUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/createQueue/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), proposedQueue.name()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(createQueueUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queueName})), this.webApiTry$default$3()).transform((Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            private final String queueName$1;

            public final Try<Queue> apply(HttpResponse response) {
                return MessageQueueWebClient$.MODULE$.queueFromResponse(response, this.queueName$1);
            }
            {
                this.queueName$1 = queueName$1;
            }
        }, (Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$1;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    Log$.MODULE$.error((Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createQueueIfAbsent.2 $outer;
                        private final Throwable x$15;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create queue ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$1, this.x$15}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$15 = x$15;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return new Failure(throwable);
            }
            {
                this.queueName$1 = queueName$1;
            }
        });
    }

    public Try<Queue> queueFromResponse(HttpResponse response, String queueName) {
        return Try$.MODULE$.apply((Function0)new Serializable(response, queueName){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$1;
            private final String queueName$2;

            public final Queue apply() {
                StatusCode statusCode = this.response$1.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.Created();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    String queueString = this.response$1.entity().asString();
                    Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
                    return (Queue)Serialization$.MODULE$.read(queueString, formats, Predef$.MODULE$.manifest(ManifestFactory$.MODULE$.classType(Queue.class)));
                }
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response status is ", ", not Created. Cannot make queue ", " from this response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1.status(), this.queueName$2, this.response$1.entity().asString()})), (Option)new Some((Object)this.response$1.status()), (Option)new Some((Object)this.response$1.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.response$1 = response$1;
                this.queueName$2 = queueName$2;
            }
        }).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Queue> apply(Queue s) {
                return new Success((Object)s);
            }
        }, (Function1)new Serializable(response, queueName){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$1;
            private final String queueName$2;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Object object;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    object = new CouldNotInterpretHTTPResponseProblem(x, "create a Queue", this.queueName$2, this.response$1.entity().asString());
                }
                return new Failure(throwable);
            }
            {
                this.response$1 = response$1;
                this.queueName$2 = queueName$2;
            }
        });
    }

    public void unit() {
        if ((byte)(this.bitmap$init$0 & 0x20) != 0) {
            return;
        }
        throw new UninitializedFieldError("Uninitialized field: MessageQueueWebClient.scala: 155");
    }

    public Try<BoxedUnit> deleteQueue(String queueName) {
        Queue proposedQueue = new Queue(queueName);
        String deleteQueueUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/deleteQueue/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), proposedQueue.name()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.PUT(), Uri$.MODULE$.apply(deleteQueueUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queueName})), this.webApiTry$default$3()).transform((Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$3;

            public final Try<BoxedUnit> apply(HttpResponse r) {
                Success success;
                StatusCode statusCode = r.status();
                StatusCodes.Success success2 = StatusCodes$.MODULE$.OK();
                if (!(statusCode != null ? !statusCode.equals(success2) : success2 != null)) {
                    Log$.MODULE$.info((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.deleteQueue.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully deleted queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                } else {
                    Log$.MODULE$.debug((Function0)new Serializable(this, r){
                        public static final long serialVersionUID = 0L;
                        private final HttpResponse r$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to delete queue, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: StatusCodes.OK, Actual StatusCodes: ", "\n             |Response: ", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.r$1.status(), this.r$1})))).stripMargin();
                        }
                        {
                            this.r$1 = r$1;
                        }
                    });
                    success = new Success((Object)BoxedUnit.UNIT);
                }
                return success;
            }
            {
                this.queueName$3 = queueName$3;
            }
        }, (Function1)new Serializable(queueName){
            public static final long serialVersionUID = 0L;
            public final String queueName$3;

            public final Failure<Nothing$> apply(Throwable t) {
                Log$.MODULE$.error((Function0)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.deleteQueue.2 $outer;
                    private final Throwable t$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to deleteQueue ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queueName$3, this.t$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.t$1 = t$1;
                    }
                });
                return new Failure(t);
            }
            {
                this.queueName$3 = queueName$3;
            }
        });
    }

    public Try<scala.collection.immutable.Seq<Queue>> queues() {
        String getQueuesUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/getQueues"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl()}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(getQueuesUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        return this.webApiTry(request, "getQueues", this.webApiTry$default$3()).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<scala.collection.immutable.Seq<Queue>> apply(HttpResponse response) {
                Failure failure;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    String allQueues = response.entity().asString();
                    Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
                    failure = new Success(Serialization$.MODULE$.read(allQueues, formats, Predef$.MODULE$.manifest(ManifestFactory$.MODULE$.classType(scala.collection.immutable.Seq.class, ManifestFactory$.MODULE$.classType(Queue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))));
                } else {
                    Log$.MODULE$.debug((Function0)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final HttpResponse response$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to get all queues, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: StatusCodes.OK, Actual StatusCodes: ", "\n             |HTTP Response: ", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$3.status(), this.response$3})))).stripMargin();
                        }
                        {
                            this.response$3 = response$3;
                        }
                    });
                    failure = new Failure((Throwable)new CouldNotCompleteMomTaskDoNotRetryException("get all queues", (Option)new Some((Object)response.status()), (Option)new Some((Object)response.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4()));
                }
                return failure;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply(Throwable t) {
                Log$.MODULE$.error((Function0)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get all queues due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$2}));
                    }
                    {
                        this.t$2 = t$2;
                    }
                });
                return new Failure(t);
            }
        });
    }

    public Future<BoxedUnit> send(String contents, Queue to) {
        Duration waitTimeBeforeResent = (Duration)package$.MODULE$.ConfigExtensions(this.webClientConfig()).get("waitTimeBeforeResent", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$3) {
                return Duration$.MODULE$.apply(x$3);
            }
        });
        ObjectRef retrySendResult = ObjectRef.create((Object)this.sendMessageOnce$1(contents, to));
        while (BoxesRunTime.unboxToBoolean((Object)this.keepGoing$1((Future)retrySendResult.elem, waitTimeBeforeResent).get())) {
            Log$.MODULE$.debug((Function0)new Serializable(contents, to, waitTimeBeforeResent, retrySendResult){
                public static final long serialVersionUID = 0L;
                private final String contents$1;
                private final Queue to$1;
                private final Duration waitTimeBeforeResent$1;
                private final ObjectRef retrySendResult$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Last attempt to send ", " to queue ", " resulted in keepGoing = ", ". Sleeping ", " before next attempt "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.contents$1, this.to$1, (Future)this.retrySendResult$1.elem, this.waitTimeBeforeResent$1}));
                }
                {
                    this.contents$1 = contents$1;
                    this.to$1 = to$1;
                    this.waitTimeBeforeResent$1 = waitTimeBeforeResent$1;
                    this.retrySendResult$1 = retrySendResult$1;
                }
            });
            Thread.sleep(waitTimeBeforeResent.toMillis());
            retrySendResult.elem = this.sendMessageOnce$1(contents, to);
        }
        Log$.MODULE$.info((Function0)new Serializable(retrySendResult){
            public static final long serialVersionUID = 0L;
            private final ObjectRef retrySendResult$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finishing send with result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Future)this.retrySendResult$1.elem}));
            }
            {
                this.retrySendResult$1 = retrySendResult$1;
            }
        });
        return (Future)retrySendResult.elem;
    }

    public Future<Option<Message>> receive(Queue from, Duration timeout) {
        long seconds = timeout.toSeconds();
        String receiveMessageUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/receiveMessage/", "?timeOutSeconds=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), from.name(), BoxesRunTime.boxToLong((long)seconds)}));
        HttpRequest request = new HttpRequest(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply(receiveMessageUrl), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
        Future result = this.webApiFutureWithMOMErrorHandling(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"receive from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from.name()})), this.webClientTimeOut().$plus(timeout)).transform((Function1)new Serializable(from){
            public static final long serialVersionUID = 0L;
            private final Queue from$1;

            public final Option<Message> apply(HttpResponse response) {
                return (Option)MessageQueueWebClient$.MODULE$.messageOptionFromResponse(response, this.from$1).get();
            }
            {
                this.from$1 = from$1;
            }
        }, (Function1)new Serializable(from){
            public static final long serialVersionUID = 0L;
            private final Queue from$1;

            public final Throwable apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CouldNotCompleteMomTaskDoNotRetryException) {
                    CouldNotCompleteMomTaskDoNotRetryException couldNotCompleteMomTaskDoNotRetryException = (CouldNotCompleteMomTaskDoNotRetryException)throwable2;
                    Option status = couldNotCompleteMomTaskDoNotRetryException.status();
                    Option contents = couldNotCompleteMomTaskDoNotRetryException.contents();
                    Option cause = couldNotCompleteMomTaskDoNotRetryException.cause();
                    Object object = status.get();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                    if (!(object != null ? !object.equals(clientError) : clientError != null)) {
                        throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cause, this.from$1.name()})), status, contents, cause);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return throwable;
            }
            {
                this.from$1 = from$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return result;
    }

    public Try<Option<Message>> messageOptionFromResponse(HttpResponse response, Queue from) {
        return Try$.MODULE$.apply((Function0)new Serializable(response, from){
            public static final long serialVersionUID = 0L;
            public final HttpResponse response$2;
            public final Queue from$2;

            public final Option<LocalMessageQueueMiddleware.SimpleMessage> apply() {
                block6: {
                    None$ none$;
                    block5: {
                        block4: {
                            StatusCode statusCode = this.response$2.status();
                            StatusCodes.Success success = StatusCodes$.MODULE$.NoContent();
                            if (statusCode != null ? !statusCode.equals(success) : success != null) break block4;
                            Log$.MODULE$.info((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.messageOptionFromResponse.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No message received from Queue ", ", HTTP Response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.from$2, this.$outer.response$2}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            none$ = None$.MODULE$;
                            break block5;
                        }
                        StatusCode statusCode = this.response$2.status();
                        StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                        if (statusCode != null ? !statusCode.equals(success) : success != null) break block6;
                        Log$.MODULE$.info((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.messageOptionFromResponse.1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-empty Message received from Queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.from$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        String responseString = this.response$2.entity().asString();
                        Some some = new Some((Object)LocalMessageQueueMiddleware.SimpleMessage$.MODULE$.fromJson(responseString));
                        none$ = some;
                    }
                    return none$;
                }
                StatusCode statusCode = this.response$2.status();
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                if (!(statusCode != null ? !statusCode.equals(clientError) : clientError != null)) {
                    Some some;
                    Some some2 = some;
                    Some some3 = some;
                    throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2.entity().asString(), this.from$2.name()})), (Option)new Some((Object)this.response$2.status()), (Option)new Some((Object)this.response$2.entity().asString()), CouldNotCompleteMomTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make a Message from response ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2.entity().asString(), this.from$2.name()})), (Option)new Some((Object)this.response$2.status()), (Option)new Some((Object)this.response$2.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.response$2 = response$2;
                this.from$2 = from$2;
            }
        }).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Option<MessageQueueWebClient.MessageQueueClientMessage>> apply(Option<LocalMessageQueueMiddleware.SimpleMessage> s) {
                Option messageQueueClientMessageOpt = s.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MessageQueueWebClient.MessageQueueClientMessage apply(LocalMessageQueueMiddleware.SimpleMessage msg) {
                        return MessageQueueWebClient$MessageQueueClientMessage$.MODULE$.apply(msg.deliveryAttemptID(), msg.contents());
                    }
                });
                return new Success((Object)messageQueueClientMessageOpt);
            }
        }, (Function1)new Serializable(response, from){
            public static final long serialVersionUID = 0L;
            private final HttpResponse response$2;
            private final Queue from$2;

            public final Failure<Nothing$> apply(Throwable throwable) {
                Object object;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    Throwable x = (Throwable)option.get();
                    object = new CouldNotInterpretHTTPResponseProblem(x, "create a Message", this.from$2.name(), this.response$2.entity().asString());
                }
                return new Failure(throwable);
            }
            {
                this.response$2 = response$2;
                this.from$2 = from$2;
            }
        });
    }

    private final Future sendMessageOnce$1(String contents$1, Queue to$1) {
        Log$.MODULE$.debug((Function0)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            private final String contents$1;
            private final Queue to$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send to ", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1, this.contents$1}));
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        });
        String sendMessageUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sendMessage/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.momUrl(), to$1.name()}));
        HttpMethod x$4 = HttpMethods$.MODULE$.PUT();
        Uri x$5 = Uri$.MODULE$.apply(sendMessageUrl);
        HttpEntity x$6 = HttpEntity$.MODULE$.apply(contents$1);
        List x$7 = HttpRequest$.MODULE$.apply$default$3();
        HttpProtocol x$8 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest request = new HttpRequest(x$4, x$5, x$7, x$6, x$8);
        return this.webApiFutureWithMOMErrorHandling(request, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{to$1.name()})), this.webApiFutureWithMOMErrorHandling$default$3()).transform((Function1)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            public final String contents$1;
            public final Queue to$1;

            public final void apply(HttpResponse s) {
                StatusCode statusCode = s.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.Accepted();
                if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                    Log$.MODULE$.info((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.sendMessageOnce.1.2 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully sent Message ", " to Queue ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.$outer.to$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                Log$.MODULE$.debug((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessageOnce.1.2 $outer;
                    private final HttpResponse s$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to sendMessage ", ", HTTPResponse is a success but it does not contain an expected StatusCode\n               |Expected StatusCodes: StatusCodes.Accepted, Actual StatusCodes: ", "\n               |Response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.s$1.status(), this.s$1})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.s$1 = s$1;
                    }
                });
                throw new CouldNotCompleteMomTaskDoNotRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send a Message to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1.name()})), (Option)new Some((Object)s.status()), (Option)new Some((Object)s.entity().asString()), CouldNotCompleteMomTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        }, (Function1)new Serializable(contents$1, to$1){
            public static final long serialVersionUID = 0L;
            public final String contents$1;
            public final Queue to$1;

            public final Throwable apply(Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CouldNotCompleteMomTaskDoNotRetryException) {
                    CouldNotCompleteMomTaskDoNotRetryException couldNotCompleteMomTaskDoNotRetryException = (CouldNotCompleteMomTaskDoNotRetryException)throwable2;
                    Option status = couldNotCompleteMomTaskDoNotRetryException.status();
                    Option content = couldNotCompleteMomTaskDoNotRetryException.contents();
                    Option cause = couldNotCompleteMomTaskDoNotRetryException.cause();
                    Object object = status.get();
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.UnprocessableEntity();
                    if (!(object != null ? !object.equals(clientError) : clientError != null)) {
                        throw new CouldNotCompleteMomTaskButOKToRetryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send a Message to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.to$1.name()})), status, content, cause);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Log$.MODULE$.error((Function0)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessageOnce.1.3 $outer;
                    private final Throwable throwable$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to send Message ", " to Queue ", " due to Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.contents$1, this.$outer.to$1, this.throwable$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.throwable$1 = throwable$1;
                    }
                }, throwable);
                return throwable;
            }
            {
                this.contents$1 = contents$1;
                this.to$1 = to$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    private final Try keepGoing$1(Future lastAttempt, Duration waitTimeBeforeResent$1) {
        return Try$.MODULE$.apply((Function0)new Serializable(waitTimeBeforeResent$1, lastAttempt){
            public static final long serialVersionUID = 0L;
            private final Duration waitTimeBeforeResent$1;
            private final Future lastAttempt$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Await$.MODULE$.result((Awaitable)this.lastAttempt$1, this.waitTimeBeforeResent$1);
            }
            {
                this.waitTimeBeforeResent$1 = waitTimeBeforeResent$1;
                this.lastAttempt$1 = lastAttempt$1;
            }
        }).transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Success<Object> apply(BoxedUnit s) {
                return new Success((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<Object> apply(Throwable throwable) {
                Throwable throwable2;
                block5: {
                    Success success;
                    block3: {
                        block4: {
                            block2: {
                                throwable2 = throwable;
                                if (!(throwable2 instanceof CouldNotCompleteMomTaskButOKToRetryException)) break block2;
                                success = new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                                break block3;
                            }
                            if (!(throwable2 instanceof TimeoutException)) break block4;
                            Log$.MODULE$.debug((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MessageQueueWebClient timed out attempting to send(). Will retry."})).s((Seq)Nil$.MODULE$);
                                }
                            });
                            success = new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break block3;
                        }
                        if (throwable2 == null) break block5;
                        Throwable throwable3 = throwable2;
                        success = new Failure(throwable3);
                    }
                    return success;
                }
                throw new MatchError((Object)throwable2);
            }
        });
    }

    private MessageQueueWebClient$() {
        MODULE$ = this;
        this.system = ActorSystem$.MODULE$.apply("momServer", ConfigSource$.MODULE$.config());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.configPath = "shrine.messagequeue.blockingq";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.webClientTimeOut = (Duration)package$.MODULE$.ConfigExtensions(this.webClientConfig()).get("webClientTimeOut", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$1) {
                return Duration$.MODULE$.apply(x$1);
            }
        });
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.momUrl = this.webClientConfig().getString("serverUrl");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.timeOutWaitGap = ((Duration)package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).get("shrine.messagequeue.httpClient.timeOutWaitGap", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$2) {
                return Duration$.MODULE$.apply(x$2);
            }
        })).toMillis();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.unit = BoxedUnit.UNIT;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }
}

