/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.effect.Sync;
import cats.syntax.package;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.Cookie;
import org.http4s.Request;
import org.http4s.headers.Cookie$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$;
import org.http4s.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;

public final class CSRF$ {
    public static final CSRF$ MODULE$;
    private final String SigningAlgo;
    private final int SHA1ByteLen;
    private final int CSRFTokenLength;
    private final int InitialSeedArraySize;
    private final SecureRandom CachedRandom;

    static {
        new CSRF$();
    }

    public <F> CSRF<F> apply(String headerName, String cookieName, SecretKey key, Clock clock, Sync<F> evidence$1) {
        return new CSRF<F>(headerName, cookieName, key, clock, evidence$1);
    }

    public <F> String apply$default$1() {
        return "X-Csrf-Token";
    }

    public <F> String apply$default$2() {
        return "csrf-token";
    }

    public <F> Clock apply$default$4() {
        return Clock.systemUTC();
    }

    public <F> F withGeneratedKey(String headerName, String cookieName, Clock clock, Sync<F> evidence$2) {
        return (F)package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$2), evidence$2).map((Function1)new Serializable(headerName, cookieName, clock, evidence$2){
            public static final long serialVersionUID = 0L;
            private final String headerName$1;
            private final String cookieName$2;
            private final Clock clock$1;
            private final Sync evidence$2$1;

            public final CSRF<F> apply(SecretKey x$3) {
                return CSRF$.MODULE$.apply(this.headerName$1, this.cookieName$2, x$3, this.clock$1, this.evidence$2$1);
            }
            {
                this.headerName$1 = headerName$1;
                this.cookieName$2 = cookieName$2;
                this.clock$1 = clock$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public <F> String withGeneratedKey$default$1() {
        return "X-Csrf-Token";
    }

    public <F> String withGeneratedKey$default$2() {
        return "csrf-token";
    }

    public <F> Clock withGeneratedKey$default$3() {
        return Clock.systemUTC();
    }

    public <F> F withKeyBytes(byte[] keyBytes, String headerName, String cookieName, Clock clock, Sync<F> evidence$3) {
        return (F)package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$3), evidence$3).map((Function1)new Serializable(headerName, cookieName, clock, evidence$3){
            public static final long serialVersionUID = 0L;
            private final String headerName$2;
            private final String cookieName$3;
            private final Clock clock$2;
            private final Sync evidence$3$1;

            public final CSRF<F> apply(SecretKey x$4) {
                return CSRF$.MODULE$.apply(this.headerName$2, this.cookieName$3, x$4, this.clock$2, this.evidence$3$1);
            }
            {
                this.headerName$2 = headerName$2;
                this.cookieName$3 = cookieName$3;
                this.clock$2 = clock$2;
                this.evidence$3$1 = evidence$3$1;
            }
        });
    }

    public <F> String withKeyBytes$default$2() {
        return "X-Csrf-Token";
    }

    public <F> String withKeyBytes$default$3() {
        return "csrf-token";
    }

    public <F> Clock withKeyBytes$default$4() {
        return Clock.systemUTC();
    }

    public String SigningAlgo() {
        return this.SigningAlgo;
    }

    public int SHA1ByteLen() {
        return this.SHA1ByteLen;
    }

    public int CSRFTokenLength() {
        return this.CSRFTokenLength;
    }

    private int InitialSeedArraySize() {
        return this.InitialSeedArraySize;
    }

    private SecureRandom CachedRandom() {
        return this.CachedRandom;
    }

    public <F> Option<Cookie> cookieFromHeaders(Request<F> request, String cookieName, Applicative<F> evidence$4) {
        return Cookie$.MODULE$.from(request.headers()).flatMap((Function1)new Serializable(cookieName){
            public static final long serialVersionUID = 0L;
            public final String cookieName$1;

            public final Option<Cookie> apply(org.http4s.headers.Cookie x$5) {
                return x$5.values().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.cookieFromHeaders.1 $outer;

                    public final boolean apply(Cookie x$6) {
                        String string = x$6.name();
                        String string2 = this.$outer.cookieName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.cookieName$1 = cookieName$1;
            }
        });
    }

    public boolean isEqual(String s1, String s2) {
        return MessageDigest.isEqual(s1.getBytes(StandardCharsets.UTF_8), s2.getBytes(StandardCharsets.UTF_8));
    }

    public String genTokenString() {
        byte[] bytes = new byte[this.CSRFTokenLength()];
        this.CachedRandom().nextBytes(bytes);
        return new String(package$.MODULE$.encodeHex(bytes));
    }

    public <F> F generateSigningKey(Sync<F> F) {
        return (F)F.delay((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SecretKey apply() {
                return KeyGenerator.getInstance(CSRF$.MODULE$.SigningAlgo()).generateKey();
            }
        });
    }

    public <F> F buildSigningKey(byte[] array, Sync<F> F) {
        return (F)F.delay((Function0)new Serializable(array){
            public static final long serialVersionUID = 0L;
            private final byte[] array$1;

            public final SecretKeySpec apply() {
                return new SecretKeySpec((byte[])Predef$.MODULE$.byteArrayOps(this.array$1).slice(0, CSRF$.MODULE$.SHA1ByteLen()), CSRF$.MODULE$.SigningAlgo());
            }
            {
                this.array$1 = array$1;
            }
        });
    }

    public <F> String $lessinit$greater$default$1() {
        return "X-Csrf-Token";
    }

    public <F> String $lessinit$greater$default$2() {
        return "csrf-token";
    }

    public <F> Clock $lessinit$greater$default$4() {
        return Clock.systemUTC();
    }

    /*
     * WARNING - void declaration
     */
    private CSRF$() {
        void var1_1;
        MODULE$ = this;
        this.SigningAlgo = "HmacSHA1";
        this.SHA1ByteLen = 20;
        this.CSRFTokenLength = 32;
        this.InitialSeedArraySize = 20;
        SecureRandom r = new SecureRandom();
        r.nextBytes(new byte[this.InitialSeedArraySize()]);
        this.CachedRandom = var1_1;
    }
}

