/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import org.parboiled.common.Preconditions;
import org.parboiled.trees.MutableBinaryTreeNode;
import org.parboiled.trees.MutableTreeNode;
import org.parboiled.trees.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeNode<T>> T getRoot(T t) {
        if (t == null) {
            return null;
        }
        if (t.getParent() != null) {
            return TreeUtils.getRoot(t.getParent());
        }
        return t;
    }

    public static <T extends MutableTreeNode<T>> void addChild(T t, T t2) {
        Preconditions.checkArgNotNull(t, "parent");
        t.addChild(t.getChildren().size(), t2);
    }

    public static <T extends MutableTreeNode<T>> void removeChild(T t, T t2) {
        Preconditions.checkArgNotNull(t, "parent");
        int n = t.getChildren().indexOf(t2);
        Preconditions.checkElementIndex(n, t.getChildren().size());
        t.removeChild(n);
    }

    public static <N extends MutableBinaryTreeNode<N>> N toLeftAssociativity(N n) {
        Preconditions.checkArgNotNull(n, "node");
        MutableBinaryTreeNode mutableBinaryTreeNode = (MutableBinaryTreeNode)n.right();
        if (mutableBinaryTreeNode == null) {
            return n;
        }
        n.setRight((MutableBinaryTreeNode)((MutableBinaryTreeNode)mutableBinaryTreeNode.left()));
        mutableBinaryTreeNode.setLeft(n);
        return (N)mutableBinaryTreeNode;
    }
}

