/*
 * Decompiled with CFR 0.152.
 */
package spray.routing.directives;

import akka.actor.ActorRefFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.parboiled.common.FileUtils;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import shapeless.HNil;
import spray.http.ContentType;
import spray.http.DateTime;
import spray.http.DateTime$;
import spray.http.EntityTag;
import spray.http.EntityTag$;
import spray.http.HttpData$;
import spray.http.HttpEntity$;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.MultipartByteRanges;
import spray.http.Uri;
import spray.httpx.marshalling.BasicMarshallers$;
import spray.httpx.marshalling.Marshaller;
import spray.httpx.marshalling.Marshaller$;
import spray.httpx.marshalling.ToResponseMarshallable;
import spray.httpx.marshalling.ToResponseMarshallable$;
import spray.httpx.marshalling.ToResponseMarshaller$;
import spray.routing.ApplyConverter$;
import spray.routing.ConjunctionMagnet$;
import spray.routing.Directive;
import spray.routing.Directive$;
import spray.routing.Prepender;
import spray.routing.Prepender$;
import spray.routing.RequestContext;
import spray.routing.RouteConcatenation$;
import spray.routing.RoutingSettings;
import spray.routing.RoutingSettings$;
import spray.routing.StandardRoute;
import spray.routing.directives.BasicDirectives$;
import spray.routing.directives.CacheConditionDirectives$;
import spray.routing.directives.ChunkSizeMagnet$;
import spray.routing.directives.ChunkingDirectives$;
import spray.routing.directives.ContentTypeResolver;
import spray.routing.directives.DetachMagnet$;
import spray.routing.directives.DetachMagnet2$;
import spray.routing.directives.DirectoryListing;
import spray.routing.directives.ExecutionDirectives$;
import spray.routing.directives.FileAndResourceDirectives;
import spray.routing.directives.FileAndResourceDirectives$;
import spray.routing.directives.FileAndResourceDirectives$$anonfun$listDirectoryContents$1$;
import spray.routing.directives.MethodDirectives$;
import spray.routing.directives.MiscDirectives$;
import spray.routing.directives.RangeDirectives$;
import spray.routing.directives.RangeDirectives$WithRangeSupportMagnet$;
import spray.routing.directives.RespondWithDirectives$;
import spray.routing.directives.RouteDirectives$;
import spray.util.LoggingContext;
import spray.util.package$;

public abstract class FileAndResourceDirectives$class {
    public static Function1 getFromFile(FileAndResourceDirectives $this, String fileName, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromFile(new File(fileName), settings, resolver, refFactory);
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromFile(file, resolver.apply(file.getName()), settings, refFactory);
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, ContentType contentType, RoutingSettings settings, ActorRefFactory refFactory) {
        return (Function1)Directive$.MODULE$.pimpApply(MethodDirectives$.MODULE$.get(), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), ApplyConverter$.MODULE$.hac0()).apply(file.isFile() && file.canRead() ? Directive$.MODULE$.pimpApply(FileAndResourceDirectives$class.autoChunked($this, settings, refFactory), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(FileAndResourceDirectives$class.conditionalFor($this, file.length(), file.lastModified(), settings), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(RangeDirectives$.MODULE$.withRangeSupport(RangeDirectives$WithRangeSupportMagnet$.MODULE$.fromSettings(BoxedUnit.UNIT, settings, (Marshaller<MultipartByteRanges>)Marshaller$.MODULE$.multipartByterangesMarshaller())), ApplyConverter$.MODULE$.hac0()).apply(RouteDirectives$.MODULE$.complete().apply((Object)new Serializable($this, file, contentType){
            public static final long serialVersionUID = 0L;
            private final File file$1;
            private final ContentType contentType$1;

            public final ToResponseMarshallable apply() {
                return ToResponseMarshallable$.MODULE$.isMarshallable((Object)HttpEntity$.MODULE$.apply(this.contentType$1, HttpData$.MODULE$.apply(this.file$1, HttpData$.MODULE$.apply$default$2(), HttpData$.MODULE$.apply$default$3())), ToResponseMarshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.HttpEntityMarshaller()));
            }
            {
                this.file$1 = file$1;
                this.contentType$1 = contentType$1;
            }
        })))) : RouteDirectives$.MODULE$.reject()));
    }

    private static Directive autoChunked(FileAndResourceDirectives $this, RoutingSettings settings, ActorRefFactory refFactory) {
        return ChunkingDirectives$.MODULE$.autoChunk(ChunkSizeMagnet$.MODULE$.fromThresholdAndChunkSize(new Tuple2.mcJI.sp(settings.fileChunkingThresholdSize(), settings.fileChunkingChunkSize()), refFactory, Predef$.MODULE$.$conforms(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x) {
                return this.apply$mcJI$sp(x);
            }

            public long apply$mcJI$sp(int x) {
                return Int$.MODULE$.int2long(x);
            }
        }));
    }

    private static Directive conditionalFor(FileAndResourceDirectives $this, long length, long lastModified, RoutingSettings settings) {
        Directive<HNil> directive;
        if (settings.fileGetConditional()) {
            String tag = Long.toHexString(lastModified ^ Long.reverse(length));
            DateTime lastModifiedDateTime = DateTime$.MODULE$.apply(scala.math.package$.MODULE$.min(lastModified, System.currentTimeMillis()));
            directive = CacheConditionDirectives$.MODULE$.conditional(new EntityTag(tag, EntityTag$.MODULE$.apply$default$2()), lastModifiedDateTime);
        } else {
            directive = BasicDirectives$.MODULE$.noop();
        }
        return directive;
    }

    public static Directive respondWithLastModifiedHeader(FileAndResourceDirectives $this, long timestamp) {
        return RespondWithDirectives$.MODULE$.respondWithHeader((HttpHeader)new HttpHeaders.Last$minusModified(DateTime$.MODULE$.apply(scala.math.package$.MODULE$.min(timestamp, System.currentTimeMillis()))));
    }

    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromResource(resourceName, resolver.apply(resourceName), refFactory);
    }

    /*
     * WARNING - void declaration
     */
    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentType contentType, ActorRefFactory refFactory) {
        Tuple2 tuple2;
        block8: {
            StandardRoute standardRoute;
            block5: {
                StandardRoute standardRoute2;
                Function1<Object, Function1<RequestContext, BoxedUnit>> function1;
                Function1<Object, Function1<RequestContext, BoxedUnit>> function12;
                block7: {
                    Tuple2.mcIJ.sp sp2;
                    Tuple2 tuple22;
                    URL uRL;
                    block6: {
                        block4: {
                            if (!resourceName.endsWith("/")) break block4;
                            standardRoute = RouteDirectives$.MODULE$.reject();
                            break block5;
                        }
                        function12 = Directive$.MODULE$.pimpApply(MethodDirectives$.MODULE$.get(), ApplyConverter$.MODULE$.hac0());
                        function1 = Directive$.MODULE$.pimpApply(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), ApplyConverter$.MODULE$.hac0());
                        ClassLoader theClassLoader = package$.MODULE$.actorSystem(refFactory).dynamicAccess().classLoader();
                        uRL = theClassLoader.getResource(resourceName);
                        if (uRL != null) break block6;
                        standardRoute2 = RouteDirectives$.MODULE$.reject();
                        break block7;
                    }
                    URLConnection conn = uRL.openConnection();
                    try {
                        conn.setUseCaches(false);
                        int len = conn.getContentLength();
                        long lm = conn.getLastModified();
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)len)), (Object)BoxesRunTime.boxToLong((long)lm));
                    }
                    catch (Throwable throwable) {
                        void var9_7;
                        var9_7.getInputStream().close();
                        throw throwable;
                    }
                    conn.getInputStream().close();
                    tuple2 = tuple22;
                    if (tuple2 == null) break block8;
                    int length = tuple2._1$mcI$sp();
                    long lastModified = tuple2._2$mcJ$sp();
                    Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(length, lastModified);
                    int length2 = sp3._1$mcI$sp();
                    long lastModified2 = sp3._2$mcJ$sp();
                    Marshaller bufferMarshaller = BasicMarshallers$.MODULE$.byteArrayMarshaller(contentType);
                    standardRoute2 = (Function1)Directive$.MODULE$.pimpApply(FileAndResourceDirectives$class.autoChunked($this, RoutingSettings$.MODULE$.default(refFactory), refFactory), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(FileAndResourceDirectives$class.conditionalFor($this, length2, lastModified2, RoutingSettings$.MODULE$.default(refFactory)), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(RangeDirectives$.MODULE$.withRangeSupport(RangeDirectives$WithRangeSupportMagnet$.MODULE$.fromSettings(BoxedUnit.UNIT, RoutingSettings$.MODULE$.default(refFactory), (Marshaller<MultipartByteRanges>)Marshaller$.MODULE$.multipartByterangesMarshaller())), ApplyConverter$.MODULE$.hac0()).apply(RouteDirectives$.MODULE$.complete().apply((Object)new Serializable($this, bufferMarshaller, uRL){
                        public static final long serialVersionUID = 0L;
                        private final Marshaller bufferMarshaller$1;
                        private final URL x1$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final ToResponseMarshallable apply() {
                            ToResponseMarshallable toResponseMarshallable;
                            InputStream is = this.x1$1.openStream();
                            try {
                                toResponseMarshallable = ToResponseMarshallable$.MODULE$.isMarshallable((Object)FileUtils.readAllBytes((InputStream)is), ToResponseMarshaller$.MODULE$.liftMarshaller(this.bufferMarshaller$1));
                            }
                            catch (Throwable throwable) {
                                void var1_1;
                                var1_1.close();
                                throw throwable;
                            }
                            is.close();
                            return toResponseMarshallable;
                        }
                        {
                            this.bufferMarshaller$1 = bufferMarshaller$1;
                            this.x1$1 = x1$1;
                        }
                    }))));
                }
                standardRoute = (Function1)function12.apply(function1.apply((Object)standardRoute2));
            }
            return standardRoute;
        }
        throw new MatchError((Object)tuple2);
    }

    public static Function1 getFromDirectory(FileAndResourceDirectives $this, String directoryName, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        String base = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, base, settings, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final String base$1;
            private final RoutingSettings settings$2;
            private final ContentTypeResolver resolver$1;
            private final ActorRefFactory refFactory$1;
            private final LoggingContext log$2;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                String string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeDirectoryChildPath(this.base$1, path, FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$3(), this.log$2);
                Function1<RequestContext, BoxedUnit> function1 = "".equals(string) ? RouteDirectives$.MODULE$.reject() : this.$outer.getFromFile(string, this.settings$2, this.resolver$1, this.refFactory$1);
                return function1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.base$1 = base$1;
                this.settings$2 = settings$2;
                this.resolver$1 = resolver$1;
                this.refFactory$1 = refFactory$1;
                this.log$2 = log$2;
            }
        });
    }

    public static Function1 listDirectoryContents(FileAndResourceDirectives $this, Seq directories, Marshaller renderer, ActorRefFactory refFactory, LoggingContext log) {
        return (Function1)Directive$.MODULE$.pimpApply((Directive)MethodDirectives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), (Prepender)Prepender$.MODULE$.hnilPrepend())), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, directories, renderer, log){
            public static final long serialVersionUID = 0L;
            public final Seq directories$1;
            public final Marshaller renderer$1;
            public final LoggingContext log$3;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.requestUri(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 $outer;
                    public final Uri.Path path$3;

                    public final Function1<RequestContext, BoxedUnit> apply(Uri fullUri) {
                        String fullPath = fullUri.path().toString();
                        int matchedLength = fullPath.lastIndexOf(this.path$3.toString());
                        Predef$.MODULE$.require(matchedLength >= 0);
                        String pathPrefix = fullPath.substring(0, matchedLength);
                        String pathString = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeJoinPaths("/", this.path$3, '/', this.$outer.log$3));
                        Seq dirs = (Seq)this.$outer.directories$1.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$.anonfun.apply.1 $outer;

                            public final Iterable<File> apply(String dir) {
                                File file;
                                String string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeDirectoryChildPath(FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(dir), this.$outer.path$3, FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$3(), this.$outer.spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().log$3);
                                Iterable iterable = "".equals(string) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : ((file = new File(string)).isDirectory() && file.canRead() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)file)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
                                return iterable;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return dirs.isEmpty() ? RouteDirectives$.MODULE$.reject() : (Function1)RouteDirectives$.MODULE$.complete().apply((Object)new Serializable(this, pathPrefix, pathString, dirs){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$.anonfun.apply.1 $outer;
                            private final String pathPrefix$1;
                            private final String pathString$1;
                            private final Seq dirs$1;

                            public final ToResponseMarshallable apply() {
                                String string = this.pathString$1;
                                String string2 = "/";
                                return ToResponseMarshallable$.MODULE$.isMarshallable((Object)new DirectoryListing(new StringBuilder().append((Object)this.pathPrefix$1).append((Object)this.pathString$1).toString(), !(string != null ? !string.equals(string2) : string2 != null), (Seq<File>)((Seq)this.dirs$1.flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayOps<File> apply(File x$2) {
                                        return Predef$.MODULE$.refArrayOps((Object[])x$2.listFiles());
                                    }
                                }, Seq$.MODULE$.canBuildFrom()))), ToResponseMarshaller$.MODULE$.liftMarshaller(this.$outer.spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().renderer$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.pathPrefix$1 = pathPrefix$1;
                                this.pathString$1 = pathString$1;
                                this.dirs$1 = dirs$1;
                            }
                        });
                    }

                    public /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.path$3 = path$3;
                    }
                });
            }
            {
                this.directories$1 = directories$1;
                this.renderer$1 = renderer$1;
                this.log$3 = log$3;
            }
        }));
    }

    public static Function1 getFromBrowseableDirectory(FileAndResourceDirectives $this, String directory, Marshaller renderer, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        return $this.getFromBrowseableDirectories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{directory}), (Marshaller<DirectoryListing>)renderer, settings, resolver, refFactory, log);
    }

    public static Function1 getFromBrowseableDirectories(FileAndResourceDirectives $this, Seq directories, Marshaller renderer, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        return RouteConcatenation$.MODULE$.pimpRouteWithConcatenation((Function1<RequestContext, BoxedUnit>)((Function1)((TraversableOnce)directories.map((Function1)new Serializable($this, settings, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final RoutingSettings settings$3;
            private final ContentTypeResolver resolver$2;
            private final ActorRefFactory refFactory$2;
            private final LoggingContext log$4;

            public final Function1<RequestContext, BoxedUnit> apply(String directoryName) {
                return this.$outer.getFromDirectory(directoryName, this.settings$3, this.resolver$2, this.refFactory$2, this.log$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.settings$3 = settings$3;
                this.resolver$2 = resolver$2;
                this.refFactory$2 = refFactory$2;
                this.log$4 = log$4;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Function1<RequestContext, BoxedUnit> apply(Function1<RequestContext, BoxedUnit> x$3, Function1<RequestContext, BoxedUnit> x$4) {
                return RouteConcatenation$.MODULE$.pimpRouteWithConcatenation(x$3).$tilde(x$4);
            }
        }))).$tilde($this.listDirectoryContents((Seq<String>)directories, (Marshaller<DirectoryListing>)renderer, refFactory, log));
    }

    public static Function1 getFromResourceDirectory(FileAndResourceDirectives $this, String directoryName, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        String base = directoryName.isEmpty() ? "" : FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, base, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final String base$3;
            private final ContentTypeResolver resolver$3;
            private final ActorRefFactory refFactory$3;
            private final LoggingContext log$5;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                String string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$safeJoinPaths(this.base$3, path, '/', this.log$5);
                Function1<RequestContext, BoxedUnit> function1 = "".equals(string) ? RouteDirectives$.MODULE$.reject() : this.$outer.getFromResource(string, this.resolver$3, this.refFactory$3);
                return function1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.base$3 = base$3;
                this.resolver$3 = resolver$3;
                this.refFactory$3 = refFactory$3;
                this.log$5 = log$5;
            }
        });
    }

    public static void $init$(FileAndResourceDirectives $this) {
    }
}

