/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.manyqepqueries;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import net.shrine.protocol.QueryResult;
import net.shrine.protocol.QueryResult$;
import net.shrine.qep.querydb.QepQuery;
import net.shrine.qep.querydb.QepQueryDb$;
import net.shrine.source.ConfigSource$;
import net.shrine.utilities.manyqepqueries.Utilities;
import net.shrine.utilities.manyqepqueries.Utilities$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Utilities$ {
    public static final Utilities$ MODULE$;

    static {
        new Utilities$();
    }

    public Seq<String> setNetworkSize(int adapterCount) {
        Random random = new Random();
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), adapterCount).map((Function1)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$1;

            public final String apply(int adapterNumber) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1)), BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1)), BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1)), BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1)), BoxesRunTime.boxToCharacter((char)Utilities$.MODULE$.net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(this.random$1))}))).toString();
            }
            {
                this.random$1 = random$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, QueryResult>> setNumQueries(int queryCount, Seq<String> adapterNames) {
        Random random = new Random();
        long currentTime = System.currentTimeMillis();
        IndexedSeq queriesToInsert = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), queryCount).map((Function1)new Serializable(random, currentTime){
            public static final long serialVersionUID = 0L;
            private final Random random$2;
            private final long currentTime$1;

            public final QepQuery apply(int queryNumber) {
                return new QepQuery(this.random$2.nextLong(), "shrine", "i2b2demo", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lungs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)queryNumber)})), (Option)new Some((Object)"Fake Query Expression"), this.currentTime$1 - 2000000L + (long)(queryNumber * 10000), false, "Fake Query XML", this.currentTime$1 - 2000000L + (long)(queryNumber * 10000));
            }
            {
                this.random$2 = random$2;
                this.currentTime$1 = currentTime$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Seq resultsToInsert = (Seq)adapterNames.flatMap((Function1)new Serializable(random, queriesToInsert){
            public static final long serialVersionUID = 0L;
            public final Random random$2;
            private final IndexedSeq queriesToInsert$1;

            public final IndexedSeq<Tuple2<Object, QueryResult>> apply(String adapterName) {
                return (IndexedSeq)this.queriesToInsert$1.map((Function1)new Serializable(this, adapterName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;
                    private final String adapterName$1;

                    public final Tuple2<Object, QueryResult> apply(QepQuery query) {
                        QueryResult queryResult = new QueryResult(this.$outer.random$2.nextLong(), this.$outer.random$2.nextLong(), (Option)None$.MODULE$, (long)(Math.abs(this.$outer.random$2.nextInt()) % 20000 / 5 * 5 + 10), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)this.adapterName$1), QueryResult.StatusType$.MODULE$.Finished(), (Option)None$.MODULE$, QueryResult$.MODULE$.apply$default$10(), QueryResult$.MODULE$.apply$default$11());
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)query.networkId()), (Object)queryResult);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.adapterName$1 = adapterName$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.random$2 = random$2;
                this.queriesToInsert$1 = queriesToInsert$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        resultsToInsert.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, QueryResult> nToR) {
                QepQueryDb$.MODULE$.db().insertQueryResult(nToR._1$mcJ$sp(), (QueryResult)nToR._2());
            }
        });
        queriesToInsert.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(QepQuery qepQuery) {
                QepQueryDb$.MODULE$.db().insertQepQuery(qepQuery);
            }
        });
        Predef$.MODULE$.println((Object)"previousQueries and queryResults injected into the QEP cache.");
        return resultsToInsert;
    }

    public <T> int setupNetwork(String[] args, Function0<T> block) {
        Try try_;
        block4: {
            int n;
            block3: {
                block2: {
                    Try t = Try$.MODULE$.apply((Function0)new Serializable(args, block){
                        public static final long serialVersionUID = 0L;
                        private final String[] args$1;
                        private final Function0 block$1;

                        public final T apply() {
                            if (this.args$1.length != 4) {
                                throw new Utilities.WrongNumberOfArguments(new StringOps(Predef$.MODULE$.augmentString("Requires four arguments: The number of adapters, the number of queries per adapter ,\n          | the full path to the many-qep-queries.sh.conf file, and the full path to the shrine.conf file.")).stripMargin());
                            }
                            String localConfig = this.args$1[2];
                            String shrineConfig = this.args$1[3];
                            Config config = ConfigFactory.parseFile((File)new File(localConfig)).withFallback((ConfigMergeable)ConfigFactory.parseFile((File)new File(shrineConfig))).withFallback((ConfigMergeable)ConfigFactory.load());
                            return (T)ConfigSource$.MODULE$.configForBlock(config, Utilities$.MODULE$.getClass().getSimpleName(), this.block$1);
                        }
                        {
                            this.args$1 = args$1;
                            this.block$1 = block$1;
                        }
                    });
                    try_ = t;
                    if (!(try_ instanceof Success)) break block2;
                    n = 0;
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable x = failure.exception();
                n = this.handleFailure(x);
            }
            return n;
        }
        throw new MatchError((Object)try_);
    }

    public int handleFailure(Throwable error) {
        Throwable throwable;
        block4: {
            int n;
            block3: {
                block2: {
                    throwable = error;
                    if (!(throwable instanceof Utilities.WrongNumberOfArguments)) break block2;
                    Utilities.WrongNumberOfArguments wrongNumberOfArguments = (Utilities.WrongNumberOfArguments)throwable;
                    this.printUsage();
                    Predef$.MODULE$.println((Object)wrongNumberOfArguments.message());
                    n = 1;
                    break block3;
                }
                if (throwable == null) break block4;
                Throwable throwable2 = throwable;
                this.printUsage();
                throwable2.printStackTrace();
                n = 2;
            }
            return n;
        }
        throw new MatchError((Object)throwable);
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |Usage: ./many-qep-queries.sh NUMBER_OF_ADAPTERS NUMBER_OF_QUERIES ADAPTER_CONF SHRINE_CONF\n        |Inject previous queries and results into the local qepAuditDB database.\n        |\n        |ADAPTER_CONF is a configuration file for this tool. This conf file takes precedence over the SHRINE_CONF file.\n        |  See conf/adapter-queries-to-qep.conf for an example.\n        |SHRINE_CONF is the local configuration file, usually /opt/shrine/tomcat/lib/shrine.conf .\n        |\n        |Exit codes: 0 success\n        |            1 known error\n        |            2 unknown error (with an accompanying stack trace).\n        |\n        |Example: ./many-qep-queries.sh 63 40 conf/adapter-queries-to-qep.conf /opt/shrine/tomcat/lib/shrine.conf\n      ")).stripMargin());
    }

    public final char net$shrine$utilities$manyqepqueries$Utilities$$randomCapital$1(Random random$1) {
        return (char)(Math.abs(random$1.nextInt() % 26) + 65);
    }

    private Utilities$() {
        MODULE$ = this;
    }
}

