/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.shrine.crypto.BouncyKeyStoreCollection$;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.SelectAll$;
import net.shrine.util.NonEmptySeq;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConversions$;

public final class KeyStoreEntry$
implements Serializable {
    public static final KeyStoreEntry$ MODULE$;

    static {
        new KeyStoreEntry$();
    }

    public Option<X509CertificateHolder> extractCertHolder(byte[] signedBytes) {
        CMSSignedData signedData = new CMSSignedData(signedBytes);
        Store store = signedData.getCertificates();
        Collection certCollection = store.getMatches((Selector)SelectAll$.MODULE$);
        return JavaConversions$.MODULE$.collectionAsScalaIterable(certCollection).headOption();
    }

    public Option<String> getCommonNameFromCert(X509CertificateHolder certHolder) {
        return Predef$.MODULE$.refArrayOps((Object[])certHolder.getSubject().getRDNs(BCStyle.CN)).headOption().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(RDN rdn) {
                return Option$.MODULE$.apply((Object)rdn.getFirst()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeTypeAndValue cn) {
                        return IETFUtils.valueToString((ASN1Encodable)cn.getValue());
                    }
                });
            }
        });
    }

    public Option<String> extractCommonName(byte[] signedBytes) {
        return this.extractCertHolder(signedBytes).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(X509CertificateHolder certHolder) {
                return KeyStoreEntry$.MODULE$.getCommonNameFromCert(certHolder).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String commonName) {
                        return commonName;
                    }
                });
            }
        });
    }

    public X509Certificate extractX509Cert(X509CertificateHolder certificateHolder) {
        return new JcaX509CertificateConverter().setProvider((Provider)BouncyKeyStoreCollection$.MODULE$.provider()).getCertificate(certificateHolder);
    }

    public boolean certSignedOtherCert(X509CertificateHolder signer, X509CertificateHolder signee) {
        return signee.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider((Provider)BouncyKeyStoreCollection$.MODULE$.provider()).build(signer));
    }

    public KeyStoreEntry apply(X509Certificate cert, NonEmptySeq<String> aliases, Option<PrivateKey> privateKey) {
        return new KeyStoreEntry(cert, aliases, privateKey);
    }

    public Option<Tuple3<X509Certificate, NonEmptySeq<String>, Option<PrivateKey>>> unapply(KeyStoreEntry x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.cert(), x$0.aliases(), x$0.privateKey()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KeyStoreEntry$() {
        MODULE$ = this;
    }
}

