/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEAssembly;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.Version;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Assembly
extends CustomAttributeProvider {
    public static final HashMap assemblies = new HashMap();
    public MethodInfo EntryPoint;
    public final String FullName;
    protected final AssemblyName assemblyName;
    protected Type[] types = null;
    private final HashMap modulesMap = new HashMap();
    private boolean initModules = true;

    public static Assembly LoadFrom(String assemblyFileName) {
        File afile = new File(assemblyFileName);
        return Assembly.LoadFrom(afile.getParentFile(), afile.getName());
    }

    public static Assembly LoadFrom(File dir, String name) {
        File adir;
        File file = null;
        PEFile pefile = null;
        if (name.toUpperCase().endsWith(".EXE") || name.toUpperCase().endsWith(".DLL")) {
            file = new File(dir, name);
            pefile = Assembly.getPEFile(file);
            name = name.substring(0, name.length() - 4);
        }
        File file2 = adir = pefile == null ? new File(dir, name) : null;
        if (pefile == null) {
            file = new File(dir, name + ".dll");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null) {
            file = new File(dir, name + ".DLL");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null && adir.exists()) {
            file = new File(adir, name + ".dll");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null && adir.exists()) {
            file = new File(adir, name + ".DLL");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null) {
            file = new File(dir, name + ".exe");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null) {
            file = new File(dir, name + ".EXE");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null && adir.exists()) {
            file = new File(adir, name + ".exe");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null && adir.exists()) {
            file = new File(adir, name + ".EXE");
            pefile = Assembly.getPEFile(file);
        }
        if (pefile == null) {
            throw new RuntimeException("Cannot find assembly " + new File(dir, name));
        }
        return Assembly.getPEAssembly(pefile);
    }

    private static Assembly getPEAssembly(PEFile pefile) {
        Table.AssemblyDef assem = pefile.AssemblyDef;
        if (assem == null) {
            throw new RuntimeException("File " + pefile + " does not contain a manifest");
        }
        assem.readRow(1);
        String name = pefile.getString(assem.Name);
        Assembly a2 = (Assembly)assemblies.get(name);
        if (a2 != null) {
            return a2;
        }
        AssemblyName an = new AssemblyName();
        an.Name = pefile.getString(assem.Name);
        an.Version = new Version(assem.MajorVersion, assem.MinorVersion, assem.BuildNumber, assem.RevisionNumber);
        an.SetPublicKey(pefile.getBlob(assem.PublicKey));
        return new PEAssembly(pefile, an);
    }

    protected static PEFile getPEFile(File f2) {
        PEFile pefile = null;
        try {
            pefile = new PEFile(f2.getAbsolutePath());
        }
        catch (FileNotFoundException e2) {
        }
        catch (RuntimeException e3) {
            System.out.println("swallowed RuntimeException at getPEFile");
        }
        return pefile;
    }

    protected Assembly(AssemblyName an, boolean external) {
        this.assemblyName = an;
        this.FullName = an.toString();
        if (external) {
            assemblies.put(an.Name, this);
        }
    }

    protected Assembly(AssemblyName an) {
        this(an, false);
    }

    protected static Assembly getAssembly(String name) {
        return (Assembly)assemblies.get(name);
    }

    public File getFile() {
        throw new RuntimeException("Not supported");
    }

    public Module GetModule(String name) {
        this.initModules();
        return (Module)this.modulesMap.get(name);
    }

    public Module[] GetModules() {
        this.initModules();
        return this.modulesMap.values().toArray(new Module[this.modulesMap.size()]);
    }

    public Type GetType(String name) {
        this.initModules();
        Iterator modules = this.modulesMap.values().iterator();
        Type t2 = null;
        while (t2 == null && modules.hasNext()) {
            t2 = ((Module)modules.next()).GetType(name);
        }
        return t2;
    }

    public synchronized Type[] GetTypes() {
        if (this.types != null) {
            return (Type[])this.types.clone();
        }
        this.initModules();
        Iterator modules = this.modulesMap.values().iterator();
        Type[] newTypes = ((Module)modules.next()).GetTypes();
        while (modules.hasNext()) {
            Module module2 = (Module)modules.next();
            Type[] mtypes = module2.GetTypes();
            Type[] oldTypes = newTypes;
            newTypes = new Type[oldTypes.length + mtypes.length];
            System.arraycopy(oldTypes, 0, newTypes, 0, oldTypes.length);
            System.arraycopy(mtypes, 0, newTypes, oldTypes.length, mtypes.length);
        }
        this.types = newTypes;
        return (Type[])this.types.clone();
    }

    public AssemblyName GetName() {
        return this.assemblyName;
    }

    public String toString() {
        return this.FullName;
    }

    protected void addType(Type type) {
        Type.addType(type);
    }

    protected void addModule(String name, Module module2) {
        this.modulesMap.put(name, module2);
    }

    protected final void initModules() {
        if (this.initModules) {
            this.loadModules();
            this.initModules = false;
        }
    }

    protected abstract void loadModules();

    void dumpTypes() {
        Type[] types2 = this.GetTypes();
        for (int i = 0; i < types2.length; ++i) {
            System.out.println(types2[i]);
        }
    }
}

