/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Attribute;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.ICustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class CustomAttributeProvider
implements ICustomAttributeProvider {
    protected List custAttrs;
    private static final Object[] EMPTY = new Object[0];
    private Type constrType;

    @Override
    public Object[] GetCustomAttributes(boolean inherit) {
        this.initAttributes(null);
        return this.custAttrs.size() == 0 ? EMPTY : this.custAttrs.toArray(new Attribute[this.custAttrs.size()]);
    }

    @Override
    public Object[] GetCustomAttributes(Type attributeType, boolean inherit) {
        this.initAttributes(attributeType);
        LinkedList<Attribute> tAttrs = null;
        if (this.constrType == attributeType) {
            tAttrs = this.custAttrs;
        } else {
            tAttrs = new LinkedList<Attribute>();
            for (Attribute a2 : this.custAttrs) {
                if (a2.GetType() != attributeType) continue;
                tAttrs.add(a2);
            }
        }
        return tAttrs.size() == 0 ? EMPTY : tAttrs.toArray(new Attribute[tAttrs.size()]);
    }

    @Override
    public boolean IsDefined(Type attributeType, boolean inherit) {
        this.initAttributes(attributeType);
        if (this.constrType == attributeType) {
            return this.custAttrs.size() > 0;
        }
        Iterator attrs = this.custAttrs.iterator();
        while (attrs.hasNext()) {
            if (((Attribute)attrs.next()).GetType() != attributeType) continue;
            return true;
        }
        return false;
    }

    protected void addCustomAttribute(ConstructorInfo constr, byte[] value2) {
        Attribute attr = new Attribute(constr, value2);
        assert (this.constrType == null || this.constrType == attr.GetType());
        if (this.custAttrs == null) {
            this.custAttrs = new LinkedList();
        }
        this.custAttrs.add(attr);
    }

    private void initAttributes(Type atype) {
        if (this.custAttrs != null && (this.constrType == null || this.constrType == atype)) {
            return;
        }
        this.custAttrs = new LinkedList();
        this.constrType = atype;
        this.loadCustomAttributes(atype);
    }

    protected void loadCustomAttributes(Type atype) {
    }
}

