/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.util.Signature;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class PEStream
implements Signature {
    public final String name;
    public final int offset;
    public final int size;
    private final PEFile file;
    private final ByteBuffer buffer;

    public PEStream(PEFile file) {
        this.file = file;
        this.offset = file.fromRVA(file.rvaMetadata + file.readInt());
        this.size = file.readInt();
        this.buffer = file.getBuffer(this.offset, this.size);
        int i = 0;
        byte[] _buf = new byte[16];
        do {
            _buf[i] = (byte)file.readByte();
        } while (0 != _buf[++i - 1]);
        this.name = new String(_buf, 0, i - 1);
        file.align(4, file.posMetadata);
    }

    private void seek(int pos) {
        try {
            this.buffer.position(pos);
        }
        catch (IllegalArgumentException e2) {
            System.err.println("\nSeek failed in file " + this.file + " for position " + pos + " of stream " + this.name + " (" + this.buffer + ")");
            throw e2;
        }
    }

    public String getString(int pos) {
        this.seek(pos);
        this.buffer.mark();
        int i = 0;
        while (this.getByte() != 0) {
            ++i;
        }
        byte[] buf = new byte[i];
        this.buffer.reset();
        this.buffer.get(buf);
        try {
            return new String(buf, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public int getByte() {
        return this.buffer.get() + 256 & 0xFF;
    }

    public byte[] getGUID(int pos) {
        this.seek(pos);
        byte[] buf = new byte[32];
        try {
            this.buffer.get(buf);
        }
        catch (Exception e2) {
            System.err.println();
            System.err.println("PEStream.getBlob(): Exception for pos = " + pos + " and buf.length = " + buf.length);
            System.err.println("\tbuffer = " + this.buffer);
            e2.printStackTrace();
            throw new RuntimeException();
        }
        return buf;
    }

    public int readLength() {
        int length2 = this.getByte();
        if ((length2 & 0x80) != 0 && ((length2 = (length2 & 0x7F) << 8 | this.getByte()) & 0x4000) != 0) {
            length2 = (length2 & 0x3FFF) << 16 | this.getByte() << 8 | this.getByte();
        }
        return length2;
    }

    public byte[] getBlob(int pos) {
        this.seek(pos);
        int length2 = this.readLength();
        byte[] buf = new byte[length2];
        this.buffer.get(buf);
        return buf;
    }

    public PEFile.Sig getSignature(int pos) {
        this.seek(pos);
        return this.file.newSignature(this.buffer);
    }

    public Object getConstant(int type, int pos) {
        Object val = null;
        this.seek(pos);
        int length2 = this.readLength();
        switch (type) {
            case 2: {
                assert (length2 == 1);
                return this.buffer.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: {
                assert (length2 == 2) : "length == " + length2;
                return new Character(this.buffer.getChar());
            }
            case 4: 
            case 5: {
                assert (length2 == 1);
                return new Byte(this.buffer.get());
            }
            case 6: 
            case 7: {
                assert (length2 == 2);
                return new Short(this.buffer.getShort());
            }
            case 8: 
            case 9: {
                assert (length2 == 4);
                return new Integer(this.buffer.getInt());
            }
            case 10: 
            case 11: {
                assert (length2 == 8);
                return new Long(this.buffer.getLong());
            }
            case 12: {
                assert (length2 == 4);
                return new Float(this.buffer.getFloat());
            }
            case 13: {
                assert (length2 == 8);
                return new Double(this.buffer.getDouble());
            }
            case 14: {
                try {
                    return new String(this.getBlob(pos), "UTF-16LE");
                }
                catch (UnsupportedEncodingException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        throw new RuntimeException("Illegal constant type: " + type);
    }

    public void dump(PrintStream out) {
        out.println("Stream name:   " + this.name + " (length " + this.name.length() + " characters)");
        out.println("Stream offset: 0x" + PEFile.int2hex(this.offset));
        out.println("Stream size:   0x" + PEFile.int2hex(this.size));
    }
}

