/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCodeAttribute;
import ch.epfl.lamp.fjbg.JConstantValueAttribute;
import ch.epfl.lamp.fjbg.JEnclosingMethodAttribute;
import ch.epfl.lamp.fjbg.JExceptionsAttribute;
import ch.epfl.lamp.fjbg.JInnerClassesAttribute;
import ch.epfl.lamp.fjbg.JLineNumberTableAttribute;
import ch.epfl.lamp.fjbg.JLocalVariableTableAttribute;
import ch.epfl.lamp.fjbg.JOtherAttribute;
import ch.epfl.lamp.fjbg.JSourceFileAttribute;
import ch.epfl.lamp.fjbg.JStackMapTableAttribute;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class JAttributeFactory {
    protected FJBGContext context;
    protected HashMap constructors = new HashMap();
    protected static final Class[] CONSTRUCTOR_ARGS = new Class[]{FJBGContext.class, JClass.class, Object.class, String.class, Integer.TYPE, DataInputStream.class};
    protected static final Constructor defaultDefaultConstructor;
    protected final Constructor defaultConstructor;

    public JAttributeFactory(FJBGContext context, Constructor defaultConstructor) {
        this.context = context;
        this.defaultConstructor = defaultConstructor;
        this.registerClass("Code", JCodeAttribute.class);
        this.registerClass("ConstantValue", JConstantValueAttribute.class);
        this.registerClass("EnclosingMethod", JEnclosingMethodAttribute.class);
        this.registerClass("Exceptions", JExceptionsAttribute.class);
        this.registerClass("InnerClasses", JInnerClassesAttribute.class);
        this.registerClass("LineNumberTable", JLineNumberTableAttribute.class);
        this.registerClass("LocalVariableTable", JLocalVariableTableAttribute.class);
        this.registerClass("SourceFile", JSourceFileAttribute.class);
        this.registerClass("StackMapTable", JStackMapTableAttribute.class);
    }

    public JAttributeFactory(FJBGContext context) {
        this(context, defaultDefaultConstructor);
    }

    public void registerClass(String attributeName, Class clazz2) {
        if (!JAttribute.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Not a subclass of JAttribute: " + clazz2);
        }
        try {
            Constructor constr = clazz2.getConstructor(CONSTRUCTOR_ARGS);
            this.constructors.put(attributeName, constr);
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalArgumentException("No appropriate constructor for " + clazz2);
        }
    }

    public JAttribute newInstance(JClass clazz2, Object owner, DataInputStream stream2) throws IOException {
        String name = clazz2.getConstantPool().lookupUtf8(stream2.readShort());
        Integer size2 = new Integer(stream2.readInt());
        Constructor constr = (Constructor)this.constructors.get(name);
        if (constr == null) {
            constr = this.defaultConstructor;
        }
        Object[] args2 = new Object[]{this.context, clazz2, owner, name, size2, stream2};
        try {
            return (JAttribute)constr.newInstance(args2);
        }
        catch (InstantiationException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException(e4);
        }
    }

    static {
        try {
            defaultDefaultConstructor = JOtherAttribute.class.getConstructor(CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
    }
}

