/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JCodeAttribute
extends JAttribute {
    protected final JCode code;
    protected final JMethod owner;
    protected static int UNKNOWN_STACK_SIZE = Integer.MIN_VALUE;
    protected final int maxStackSize;
    protected final int maxLocals;

    public JCodeAttribute(FJBGContext context, JClass clazz2, JMethod owner) {
        super(context, clazz2);
        this.owner = owner;
        this.maxStackSize = UNKNOWN_STACK_SIZE;
        this.maxLocals = 0;
        this.code = owner.getCode();
        assert (clazz2 == owner.getOwner());
    }

    public JCodeAttribute(FJBGContext context, JClass clazz2, Object owner, String name, int size2, DataInputStream stream2) throws IOException {
        super(context, clazz2, name);
        this.owner = (JMethod)owner;
        this.maxStackSize = stream2.readShort();
        this.maxLocals = stream2.readShort();
        this.code = context.JCode(clazz2, (JMethod)owner, stream2);
        int handlersCount = stream2.readShort();
        for (int i = 0; i < handlersCount; ++i) {
            JCode jCode = this.code;
            jCode.getClass();
            this.code.addExceptionHandler(jCode.new JCode.ExceptionHandler(stream2));
        }
        List attributes2 = JAttribute.readFrom(context, clazz2, this.code, stream2);
        Iterator attrIt = attributes2.iterator();
        while (attrIt.hasNext()) {
            this.code.addAttribute((JAttribute)attrIt.next());
        }
        assert (name.equals(this.getName()));
    }

    @Override
    public String getName() {
        return "Code";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  Code:");
        buf.append("\n   Stack=");
        buf.append(this.maxStackSize);
        buf.append(", Locals=");
        buf.append(this.maxLocals);
        buf.append(", Args_size=");
        buf.append(this.owner.getArgsSize());
        buf.append(this.code);
        buf.append("\n");
        for (JAttribute attr : this.code.getAttributes()) {
            buf.append(attr);
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    protected int getSize() {
        int handlersNum = this.code.getExceptionHandlers().size();
        int attrsSize = 0;
        for (JAttribute attr : this.code.getAttributes()) {
            attrsSize += attr.getSize() + 6;
        }
        return 8 + this.code.getSize() + 2 + 8 * handlersNum + 2 + attrsSize;
    }

    @Override
    protected void writeContentsTo(DataOutputStream stream2) throws IOException {
        List handlers = this.code.getExceptionHandlers();
        stream2.writeShort(this.code.getMaxStackSize());
        stream2.writeShort(this.owner.getMaxLocals());
        this.code.writeTo(stream2);
        stream2.writeShort(handlers.size());
        Iterator handlerIt = handlers.iterator();
        while (handlerIt.hasNext()) {
            ((JCode.ExceptionHandler)handlerIt.next()).writeTo(stream2);
        }
        JAttribute.writeTo(this.code.getAttributes(), stream2);
    }
}

