/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JOpcode;
import ch.epfl.lamp.fjbg.JType;
import ch.epfl.lamp.util.ByteArray;

public class JCodeIterator {
    protected final JCode code;
    protected final JConstantPool pool;
    protected final ByteArray codeArray;
    protected int pc;
    protected JOpcode opcode;
    protected int[] padding = new int[]{0, 3, 2, 1};

    public JCodeIterator(JCode code2, int pc) {
        this.code = code2;
        this.pool = code2.getOwner().getOwner().getConstantPool();
        this.codeArray = code2.codeArray;
        this.pc = pc;
        this.setOpcode();
    }

    public JCodeIterator(JCode code2) {
        this(code2, 0);
    }

    public int getPC() {
        return this.pc;
    }

    protected void setOpcode() {
        this.opcode = this.isValid() ? JOpcode.OPCODES[this.codeArray.getU1(this.pc)] : null;
    }

    public JOpcode getOpcode() {
        return this.opcode;
    }

    public void moveTo(int pc) {
        this.pc = pc;
        this.setOpcode();
    }

    public boolean isValid() {
        return this.pc < this.codeArray.getSize();
    }

    public void moveToNext() {
        this.moveTo(this.pc + this.getInstructionSize());
    }

    public void moveToSuccessor(int succ) {
        this.moveTo(this.getSuccessorPC(succ));
    }

    public void moveRelatively(int offset2) {
        this.moveTo(this.pc + offset2);
    }

    public int getInstructionSize() {
        if (this.opcode.size != Integer.MIN_VALUE) {
            return this.opcode.size;
        }
        if (this.opcode == JOpcode.TABLESWITCH) {
            int lowOffset = 1 + this.pad4(this.pc + 1) + 4;
            int low = this.codeArray.getS4(this.pc + lowOffset);
            int high = this.codeArray.getS4(this.pc + lowOffset + 4);
            return lowOffset + 8 + 4 * (high - low + 1);
        }
        if (this.opcode == JOpcode.LOOKUPSWITCH) {
            int npairsOffset = 1 + this.pad4(this.pc + 1) + 4;
            int npairs = this.codeArray.getS4(this.pc + npairsOffset);
            return npairsOffset + 4 + 8 * npairs;
        }
        if (this.opcode == JOpcode.WIDE) {
            if (this.codeArray.getU1(this.pc + 1) == 132) {
                return 6;
            }
            return 4;
        }
        throw new Error("Unknown size for instruction " + this.opcode);
    }

    public int getSuccessorCount() {
        if (this.opcode.successorCount != Integer.MIN_VALUE) {
            return this.opcode.successorCount;
        }
        if (this.opcode == JOpcode.TABLESWITCH) {
            int lowPos = this.pc + 1 + this.pad4(this.pc + 1) + 4;
            return 1 + this.codeArray.getS4(lowPos + 4) - this.codeArray.getS4(lowPos) + 1;
        }
        if (this.opcode == JOpcode.LOOKUPSWITCH) {
            int npairsPos = this.pc + 1 + this.pad4(this.pc + 1) + 4;
            return 1 + this.codeArray.getS4(npairsPos);
        }
        throw new Error("Unknown successors for instruction " + this.opcode);
    }

    public int getSuccessorPC(int index2) {
        assert (index2 >= 0 && index2 < this.getSuccessorCount()) : index2;
        switch (this.opcode.jumpKind) {
            case 1: {
                return this.pc + this.getInstructionSize();
            }
            case 2: {
                return this.pc + this.codeArray.getS2(this.pc + 1);
            }
            case 3: {
                return this.pc + this.codeArray.getS4(this.pc + 1);
            }
            case 4: {
                if (index2 == 0) {
                    return this.pc + this.getInstructionSize();
                }
                return this.pc + this.codeArray.getS2(this.pc + 1);
            }
            case 5: {
                int defaultPos = this.pc + 1 + this.pad4(this.pc + 1);
                if (index2 == 0) {
                    return this.pc + this.codeArray.getS4(defaultPos);
                }
                return this.pc + this.codeArray.getS4(defaultPos + 12 + 4 * (index2 - 1));
            }
            case 6: {
                int defaultPos = this.pc + 1 + this.pad4(this.pc + 1);
                if (index2 == 0) {
                    return this.pc + this.codeArray.getS4(defaultPos);
                }
                return this.pc + this.codeArray.getS4(defaultPos + 8 + 4 + 8 * (index2 - 1));
            }
        }
        throw new Error();
    }

    public int getProducedDataSize() {
        if (this.opcode.getProducedDataTypes() == JOpcode.UNKNOWN_TYPE) {
            switch (this.opcode.code) {
                case 18: 
                case 19: 
                case 51: {
                    return 1;
                }
                case 20: 
                case 89: 
                case 95: {
                    return 2;
                }
                case 90: {
                    return 3;
                }
                case 91: 
                case 92: {
                    return 4;
                }
                case 93: {
                    return 5;
                }
                case 94: {
                    return 6;
                }
                case 178: 
                case 180: {
                    JConstantPool.FieldOrMethodRefEntry entry2 = (JConstantPool.FieldOrMethodRefEntry)this.pool.lookupEntry(this.codeArray.getU2(this.pc + 1));
                    return JType.parseSignature(entry2.getSignature()).getSize();
                }
                case 196: {
                    int op = this.codeArray.getU1(this.pc + 1);
                    if (op >= 21 && op <= 25) {
                        JOpcode opcode2 = JOpcode.OPCODES[op];
                        return JType.getTotalSize(opcode2.getProducedDataTypes());
                    }
                    if (op >= 54 && op <= 58) {
                        return 0;
                    }
                    return 0;
                }
            }
            throw new Error(this.opcode.toString());
        }
        return JType.getTotalSize(this.opcode.getProducedDataTypes());
    }

    public int getConsumedDataSize() {
        if (this.opcode.getConsumedDataTypes() != JOpcode.UNKNOWN_TYPE) {
            return JType.getTotalSize(this.opcode.getConsumedDataTypes());
        }
        switch (this.opcode.code) {
            case 87: 
            case 89: {
                return 1;
            }
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                return 2;
            }
            case 91: 
            case 93: {
                return 3;
            }
            case 94: {
                return 4;
            }
            case 179: 
            case 181: {
                JConstantPool.FieldOrMethodRefEntry entry2 = (JConstantPool.FieldOrMethodRefEntry)this.pool.lookupEntry(this.codeArray.getU2(this.pc + 1));
                return JType.parseSignature(entry2.getSignature()).getSize();
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                JConstantPool.FieldOrMethodRefEntry entry3 = (JConstantPool.FieldOrMethodRefEntry)this.pool.lookupEntry(this.codeArray.getU2(this.pc + 1));
                JMethodType tp = (JMethodType)JType.parseSignature(entry3.getSignature());
                return tp.getArgsSize() + (this.opcode == JOpcode.INVOKESTATIC ? 0 : 1);
            }
            case 196: {
                int op = this.codeArray.getU1(this.pc + 1);
                if (op >= 21 && op <= 25) {
                    return 0;
                }
                if (op >= 54 && op <= 58) {
                    JOpcode opcode2 = JOpcode.OPCODES[op];
                    return JType.getTotalSize(opcode2.getConsumedDataTypes());
                }
                return 0;
            }
            case 197: {
                return this.codeArray.getU1(this.pc + 3);
            }
        }
        throw new Error(this.opcode.toString());
    }

    public int getProducedDataTypesNumber() {
        if (this.opcode.getProducedDataTypes() != JOpcode.UNKNOWN_TYPE) {
            return this.opcode.getProducedDataTypes().length;
        }
        switch (this.opcode.code) {
            case 18: 
            case 19: 
            case 20: 
            case 51: 
            case 178: 
            case 180: {
                return 1;
            }
            case 89: 
            case 95: {
                return 2;
            }
            case 90: {
                return 3;
            }
            case 196: {
                int op = this.codeArray.getU1(this.pc + 1);
                if (op >= 21 && op <= 25) {
                    return 1;
                }
                if (op >= 54 && op <= 58) {
                    return 0;
                }
                return 0;
            }
        }
        throw new Error("JOpcode implementation error");
    }

    protected int pad4(int value2) {
        return this.padding[value2 % 4];
    }
}

