/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JReferenceType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class JConstantPool {
    protected boolean frozen = false;
    protected HashMap entryToIndex = new HashMap();
    protected Entry[] indexToEntry;
    protected int currIndex;
    public static final short CONSTANT_Utf8 = 1;
    public static final short CONSTANT_Integer = 3;
    public static final short CONSTANT_Float = 4;
    public static final short CONSTANT_Long = 5;
    public static final short CONSTANT_Double = 6;
    public static final short CONSTANT_Class = 7;
    public static final short CONSTANT_String = 8;
    public static final short CONSTANT_Fieldref = 9;
    public static final short CONSTANT_Methodref = 10;
    public static final short CONSTANT_InterfaceMethodref = 11;
    public static final short CONSTANT_NameAndType = 12;

    protected JConstantPool(FJBGContext context) {
        this.indexToEntry = new Entry[8];
        this.currIndex = 1;
    }

    protected JConstantPool(FJBGContext context, DataInputStream stream2) throws IOException {
        short count2 = stream2.readShort();
        this.indexToEntry = new EntryIndex[count2];
        this.currIndex = 1;
        while (this.currIndex < count2) {
            EntryIndex e2;
            byte tag2 = stream2.readByte();
            switch (tag2) {
                case 1: {
                    e2 = new Utf8Entry(stream2);
                    this.entryToIndex.put(e2, new Integer(this.currIndex));
                    break;
                }
                case 3: {
                    e2 = new IntegerEntry(stream2);
                    break;
                }
                case 4: {
                    e2 = new FloatEntry(stream2);
                    break;
                }
                case 5: {
                    e2 = new LongEntry(stream2);
                    break;
                }
                case 6: {
                    e2 = new DoubleEntry(stream2);
                    break;
                }
                case 7: {
                    e2 = new DescriptorEntryIndex(stream2);
                    break;
                }
                case 8: {
                    e2 = new StringEntryIndex(stream2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    e2 = new FieldOrMethodRefEntryIndex(tag2, stream2);
                    break;
                }
                case 12: {
                    e2 = new NameAndTypeEntryIndex(stream2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown entry in pool: " + tag2);
                }
            }
            this.indexToEntry[this.currIndex] = e2;
            this.currIndex += e2.getSize();
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public String getEntryType(int tag2) {
        switch (tag2) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Field";
            }
            case 10: {
                return "Method";
            }
            case 11: {
                return "InterfaceMethod";
            }
            case 12: {
                return "NameAndType";
            }
        }
        throw new Error("invalid constant pool tag : " + tag2);
    }

    public int addClass(String className) {
        return this.addDescriptor(className.replace('.', '/'));
    }

    public int addDescriptor(JReferenceType type) {
        return this.addDescriptor(type.getDescriptor());
    }

    protected int addDescriptor(String name) {
        return this.addEntry(new DescriptorEntryValue(name));
    }

    public int addClassMethodRef(String className, String methodName, String signature2) {
        return this.addMethodRef(true, className, methodName, signature2);
    }

    public int addInterfaceMethodRef(String className, String methodName, String signature2) {
        return this.addMethodRef(false, className, methodName, signature2);
    }

    public int addMethodRef(boolean isClass, String className, String methodName, String signature2) {
        return this.addEntry(new FieldOrMethodRefEntryValue(isClass ? 10 : 11, className, methodName, signature2));
    }

    public int addFieldRef(String className, String fieldName, String signature2) {
        return this.addEntry(new FieldOrMethodRefEntryValue(9, className, fieldName, signature2));
    }

    public int addInteger(int value2) {
        return this.addEntry(new IntegerEntry(value2));
    }

    public int addFloat(float value2) {
        return this.addEntry(new FloatEntry(value2));
    }

    public int addLong(long value2) {
        return this.addEntry(new LongEntry(value2));
    }

    public int addDouble(double value2) {
        return this.addEntry(new DoubleEntry(value2));
    }

    public int addString(String value2) {
        return this.addEntry(new StringEntryValue(value2));
    }

    public int addNameAndType(String name, String descriptor) {
        return this.addEntry(new NameAndTypeEntryValue(name, descriptor));
    }

    public int addUtf8(String value2) {
        return this.addEntry(new Utf8Entry(value2));
    }

    public int addUtf8(byte[] value2) {
        return this.addEntry(new Utf8Entry(value2));
    }

    protected int addEntry(EntryValue e2) {
        assert (!this.frozen);
        Integer idx = (Integer)this.entryToIndex.get(e2);
        if (idx != null) {
            return idx;
        }
        e2.addChildren();
        int index2 = this.currIndex;
        this.currIndex += e2.getSize();
        this.entryToIndex.put(e2, new Integer(index2));
        if (index2 >= this.indexToEntry.length) {
            Entry[] newI2E = new Entry[this.indexToEntry.length * 2];
            System.arraycopy(this.indexToEntry, 0, newI2E, 0, this.indexToEntry.length);
            this.indexToEntry = newI2E;
        }
        this.indexToEntry[index2] = e2;
        return index2;
    }

    public Entry lookupEntry(int index2) {
        assert (index2 > 0 && index2 < this.currIndex) : "invalid index: " + index2;
        assert (this.indexToEntry[index2] != null) : "invalid index (null contents): " + index2;
        return this.indexToEntry[index2];
    }

    public String lookupClass(int index2) {
        DescriptorEntry entry2 = (DescriptorEntry)this.lookupEntry(index2);
        return entry2.getValue();
    }

    public String lookupNameAndType(int index2) {
        NameAndTypeEntry entry2 = (NameAndTypeEntry)this.lookupEntry(index2);
        return entry2.getName() + ":" + entry2.getDescriptor();
    }

    public String lookupUtf8(int index2) {
        Utf8Entry entry2 = (Utf8Entry)this.lookupEntry(index2);
        return entry2.getValue();
    }

    public void writeTo(DataOutputStream stream2) throws IOException {
        if (!this.frozen) {
            this.freeze();
        }
        stream2.writeShort(this.currIndex);
        for (int i = 0; i < this.currIndex; ++i) {
            Entry entry2 = this.indexToEntry[i];
            if (entry2 == null) continue;
            stream2.writeByte(entry2.getTag());
            entry2.writeContentsTo(stream2);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  Constant pool:");
        for (int i = 0; i < this.currIndex; ++i) {
            Entry entry2 = this.indexToEntry[i];
            if (entry2 == null) continue;
            if (i > 0) {
                buf.append("\n");
            }
            buf.append("const #");
            buf.append(i);
            buf.append(" = ");
            buf.append(entry2);
        }
        buf.append("\n");
        return buf.toString();
    }

    protected class NameAndTypeEntryIndex
    extends NameAndTypeEntry
    implements EntryIndex {
        public NameAndTypeEntryIndex(int nameIndex, int descriptorIndex) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        public NameAndTypeEntryIndex(DataInputStream stream2) throws IOException {
            this(stream2.readShort(), stream2.readShort());
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.fetchChildren();
            }
            return super.getName();
        }

        @Override
        public String getDescriptor() {
            if (this.descriptor == null) {
                this.fetchChildren();
            }
            return super.getDescriptor();
        }

        @Override
        public void fetchChildren() {
            this.name = JConstantPool.this.lookupUtf8(this.nameIndex);
            this.descriptor = JConstantPool.this.lookupUtf8(this.descriptorIndex);
        }
    }

    protected class NameAndTypeEntryValue
    extends NameAndTypeEntry
    implements EntryValue {
        public NameAndTypeEntryValue(String name, String descriptor) {
            this.name = name.intern();
            this.descriptor = descriptor.intern();
        }

        @Override
        public void addChildren() {
            this.nameIndex = JConstantPool.this.addUtf8(this.name);
            this.descriptorIndex = JConstantPool.this.addUtf8(this.descriptor);
        }
    }

    public abstract class NameAndTypeEntry
    implements Entry {
        protected String name;
        protected String descriptor;
        protected int nameIndex;
        protected int descriptorIndex;

        public int hashCode() {
            return this.name.hashCode() + this.descriptor.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof NameAndTypeEntry && ((NameAndTypeEntry)o).name == this.name && ((NameAndTypeEntry)o).descriptor == this.descriptor;
        }

        @Override
        public int getTag() {
            return 12;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeShort(this.nameIndex);
            stream2.writeShort(this.descriptorIndex);
        }

        public String toString() {
            String natName = this.getName();
            if ("<init>".equals(natName)) {
                natName = "\"" + natName + "\"";
            }
            return "NameAndType\t#" + this.nameIndex + ":#" + this.descriptorIndex + ";//  " + natName + ":" + this.getDescriptor();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "";
        }
    }

    protected class FieldOrMethodRefEntryIndex
    extends FieldOrMethodRefEntry
    implements EntryIndex {
        public FieldOrMethodRefEntryIndex(int tag2, int classIndex2, int nameAndTypeIndex) {
            super(tag2);
            this.classIndex = classIndex2;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public FieldOrMethodRefEntryIndex(int tag2, DataInputStream stream2) throws IOException {
            this(tag2, stream2.readShort(), stream2.readShort());
        }

        @Override
        public String getClassName() {
            if (this.className == null) {
                this.fetchChildren();
            }
            return super.getClassName();
        }

        @Override
        public String getFieldOrMethodName() {
            if (this.thingName == null) {
                this.fetchChildren();
            }
            return super.getFieldOrMethodName();
        }

        @Override
        public String getSignature() {
            if (this.signature == null) {
                this.fetchChildren();
            }
            return super.getSignature();
        }

        @Override
        public void fetchChildren() {
            this.className = JConstantPool.this.lookupClass(this.classIndex);
            NameAndTypeEntry nat = (NameAndTypeEntry)JConstantPool.this.lookupEntry(this.nameAndTypeIndex);
            this.thingName = nat.getName();
            this.signature = nat.getDescriptor();
        }
    }

    protected class FieldOrMethodRefEntryValue
    extends FieldOrMethodRefEntry
    implements EntryValue {
        public FieldOrMethodRefEntryValue(int tag2, String className, String thingName, String signature2) {
            super(tag2);
            this.className = className.intern();
            this.thingName = thingName.intern();
            this.signature = signature2.intern();
        }

        @Override
        public void addChildren() {
            this.classIndex = JConstantPool.this.addClass(this.className);
            this.nameAndTypeIndex = JConstantPool.this.addNameAndType(this.thingName, this.signature);
        }
    }

    public abstract class FieldOrMethodRefEntry
    implements Entry {
        private final int tag;
        protected String className;
        protected String thingName;
        protected String signature;
        protected int classIndex;
        protected int nameAndTypeIndex;

        public FieldOrMethodRefEntry(int tag2) {
            assert (tag2 == 9 || tag2 == 10 || tag2 == 11);
            this.tag = tag2;
        }

        public int hashCode() {
            return this.tag + this.className.hashCode() + this.thingName.hashCode() + this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof FieldOrMethodRefEntry && ((FieldOrMethodRefEntry)o).tag == this.tag && ((FieldOrMethodRefEntry)o).className == this.className && ((FieldOrMethodRefEntry)o).thingName == this.thingName && ((FieldOrMethodRefEntry)o).signature == this.signature;
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldOrMethodName() {
            return this.thingName;
        }

        public String getSignature() {
            return this.signature;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeShort(this.classIndex);
            stream2.writeShort(this.nameAndTypeIndex);
        }

        public String toString() {
            return JConstantPool.this.getEntryType(this.tag) + "\t#" + this.classIndex + ".#" + this.nameAndTypeIndex + ";\t//  " + this.getName("") + ":" + this.signature;
        }

        @Override
        public String toComment(String ownerClassName) {
            return "//" + JConstantPool.this.getEntryType(this.tag) + " " + this.getName(ownerClassName) + ":" + this.signature;
        }

        private String getName(String ownerClassName) {
            String name = this.getFieldOrMethodName();
            if ("<init>".equals(name)) {
                name = "\"" + name + "\"";
            }
            if (!this.getClassName().equals(ownerClassName)) {
                name = this.getClassName() + "." + name;
            }
            return name;
        }
    }

    protected class DescriptorEntryIndex
    extends DescriptorEntry
    implements EntryIndex {
        public DescriptorEntryIndex(int nameIndex) {
            this.nameIndex = nameIndex;
        }

        public DescriptorEntryIndex(DataInputStream stream2) throws IOException {
            this(stream2.readShort());
        }

        @Override
        public String getValue() {
            if (this.name == null) {
                this.fetchChildren();
            }
            return super.getValue();
        }

        @Override
        public void fetchChildren() {
            this.name = JConstantPool.this.lookupUtf8(this.nameIndex);
        }
    }

    protected class DescriptorEntryValue
    extends DescriptorEntry
    implements EntryValue {
        public DescriptorEntryValue(String name) {
            this.name = name.intern();
        }

        @Override
        public void addChildren() {
            this.nameIndex = JConstantPool.this.addUtf8(this.name);
        }
    }

    public abstract class DescriptorEntry
    implements Entry {
        protected String name;
        protected int nameIndex;

        public int hashCode() {
            assert (this.name != null);
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DescriptorEntry && ((DescriptorEntry)o).name == this.name;
        }

        @Override
        public int getTag() {
            return 7;
        }

        public String getValue() {
            return this.name;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeShort(this.nameIndex);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("class\t#");
            buf.append(this.nameIndex);
            buf.append(";\t//  ");
            buf.append(this.getClassName());
            return buf.toString();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//class " + this.getClassName();
        }

        private String getClassName() {
            StringBuffer buf = new StringBuffer();
            String value2 = this.getValue();
            if (value2.startsWith("[")) {
                buf.append("\"");
            }
            buf.append(value2);
            if (value2.startsWith("[")) {
                buf.append("\"");
            }
            return buf.toString();
        }
    }

    public class StringEntryIndex
    extends StringEntry
    implements EntryIndex {
        public StringEntryIndex(int valueIndex) {
            this.valueIndex = valueIndex;
        }

        public StringEntryIndex(DataInputStream stream2) throws IOException {
            this(stream2.readShort());
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                this.fetchChildren();
            }
            return super.getValue();
        }

        @Override
        public void fetchChildren() {
            this.value = JConstantPool.this.lookupUtf8(this.valueIndex);
        }
    }

    public class StringEntryValue
    extends StringEntry
    implements EntryValue {
        public StringEntryValue(String value2) {
            this.value = value2.intern();
        }

        @Override
        public void addChildren() {
            this.valueIndex = JConstantPool.this.addUtf8(this.value);
        }
    }

    public abstract class StringEntry
    implements Entry {
        protected String value;
        protected int valueIndex;

        public int hashCode() {
            assert (this.value != null);
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof StringEntry && ((StringEntry)o).value == this.value;
        }

        @Override
        public int getTag() {
            return 8;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeShort(this.valueIndex);
        }

        public String toString() {
            return "String\t#" + this.valueIndex + ";\t//  " + this.escaped(this.getValue());
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//String " + this.escaped(this.getValue());
        }

        private String escaped(String s2) {
            return s2.replace("\n", "\\n");
        }
    }

    public class Utf8Entry
    extends ChildlessEntry
    implements Entry {
        private final String value;
        private final byte[] bytes;

        public Utf8Entry(String value2) {
            this.value = value2.intern();
            this.bytes = null;
        }

        public Utf8Entry(DataInputStream stream2) throws IOException {
            this(stream2.readUTF());
        }

        public Utf8Entry(byte[] bytes2) {
            this.bytes = bytes2;
            this.value = null;
        }

        public int hashCode() {
            if (this.bytes != null) {
                return this.bytes.hashCode();
            }
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            boolean isEqual = o instanceof Utf8Entry;
            isEqual = this.bytes != null ? isEqual && ((Utf8Entry)o).bytes == this.bytes : isEqual && ((Utf8Entry)o).value == this.value;
            return isEqual;
        }

        @Override
        public int getTag() {
            return 1;
        }

        public String getValue() {
            return this.value;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            if (this.bytes != null) {
                if (this.bytes.length > 65535) {
                    throw new IOException("String literal of length " + this.bytes.length + " does not fit in Classfile");
                }
                stream2.writeShort(this.bytes.length);
                stream2.write(this.bytes);
            } else {
                stream2.writeUTF(this.value);
            }
        }

        public String toString() {
            return "Asciz\t" + this.escaped(this.getValue()) + ";";
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//Asciz " + this.escaped(this.getValue());
        }

        private String escaped(String s2) {
            return s2.replace("\n", "\\n");
        }
    }

    public class DoubleEntry
    extends ChildlessEntry
    implements Entry {
        private final double value;

        public DoubleEntry(double value2) {
            this.value = value2;
        }

        public DoubleEntry(DataInputStream stream2) throws IOException {
            this(stream2.readDouble());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof DoubleEntry && ((DoubleEntry)o).value == this.value;
        }

        @Override
        public int getTag() {
            return 6;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeDouble(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("double\t");
            buf.append(this.getValue());
            return buf.toString();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//double " + this.getValue();
        }
    }

    public class LongEntry
    extends ChildlessEntry
    implements Entry {
        private final long value;

        public LongEntry(long value2) {
            this.value = value2;
        }

        public LongEntry(DataInputStream stream2) throws IOException {
            this(stream2.readLong());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof LongEntry && ((LongEntry)o).value == this.value;
        }

        @Override
        public int getTag() {
            return 5;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeLong(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("long\t");
            buf.append(this.getValue());
            buf.append("l;");
            return buf.toString();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//long " + this.getValue() + "l";
        }
    }

    public class FloatEntry
    extends ChildlessEntry
    implements Entry {
        private final float value;

        public FloatEntry(float value2) {
            this.value = value2;
        }

        public FloatEntry(DataInputStream stream2) throws IOException {
            this(stream2.readFloat());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof FloatEntry && ((FloatEntry)o).value == this.value;
        }

        @Override
        public int getTag() {
            return 4;
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeFloat(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("float\t");
            buf.append(this.getValue());
            buf.append("f");
            return buf.toString();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//float " + this.getValue() + "f";
        }
    }

    public class IntegerEntry
    extends ChildlessEntry
    implements Entry {
        private final int value;

        public IntegerEntry(int value2) {
            this.value = value2;
        }

        public IntegerEntry(DataInputStream stream2) throws IOException {
            this(stream2.readInt());
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof IntegerEntry && ((IntegerEntry)o).value == this.value;
        }

        @Override
        public int getTag() {
            return 3;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void writeContentsTo(DataOutputStream stream2) throws IOException {
            stream2.writeInt(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("int\t");
            buf.append(this.getValue());
            buf.append(";");
            return buf.toString();
        }

        @Override
        public String toComment(String ownerClassname) {
            return "//int " + this.getValue();
        }
    }

    protected abstract class ChildlessEntry
    implements EntryValue,
    EntryIndex {
        protected ChildlessEntry() {
        }

        @Override
        public void addChildren() {
        }

        @Override
        public void fetchChildren() {
        }
    }

    protected static interface EntryIndex
    extends Entry {
        public void fetchChildren();
    }

    protected static interface EntryValue
    extends Entry {
        public void addChildren();
    }

    public static interface Entry {
        public int getTag();

        public int getSize();

        public void writeContentsTo(DataOutputStream var1) throws IOException;

        public String toComment(String var1);
    }
}

