/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JEnclosingMethodAttribute
extends JAttribute {
    private JConstantPool pool;
    protected final int classIdx;
    protected final int nameAndTypeIdx;

    public JEnclosingMethodAttribute(FJBGContext context, JClass clazz2, String className, String methodName, JType methodType2) {
        super(context, clazz2);
        this.pool = clazz2.pool;
        this.classIdx = this.pool.addClass(className);
        this.nameAndTypeIdx = this.pool.addNameAndType(methodName, methodType2.getSignature());
    }

    public JEnclosingMethodAttribute(FJBGContext context, JClass clazz2, Object owner, String name, int size2, DataInputStream stream2) throws IOException {
        super(context, clazz2, name);
        this.pool = clazz2.pool;
        this.classIdx = stream2.readShort();
        this.nameAndTypeIdx = stream2.readShort();
        assert (name.equals(this.getName()));
    }

    @Override
    public String getName() {
        return "EnclosingMethod";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  EnclosingMethod:");
        buf.append("\n   #");
        buf.append(this.classIdx);
        if (this.nameAndTypeIdx != 0) {
            buf.append(" of #");
            buf.append(this.nameAndTypeIdx);
        }
        buf.append(";\t//  ");
        buf.append(this.pool.lookupEntry(this.classIdx));
        buf.append("\n");
        return buf.toString();
    }

    @Override
    protected int getSize() {
        return 4;
    }

    @Override
    protected void writeContentsTo(DataOutputStream stream2) throws IOException {
        stream2.writeShort(this.classIdx);
        stream2.writeShort(this.nameAndTypeIdx);
    }
}

