/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class JLocalVariableTableAttribute
extends JAttribute {
    private JConstantPool pool;
    protected final LinkedList entries = new LinkedList();
    protected int localVariableIndex = 0;

    public JLocalVariableTableAttribute(FJBGContext context, JClass clazz2, JCode code2) {
        super(context, clazz2);
        this.pool = clazz2.pool;
        assert (code2.getOwner().getOwner() == clazz2);
    }

    public JLocalVariableTableAttribute(FJBGContext context, JClass clazz2, Object owner, String name, int size2, DataInputStream stream2) throws IOException {
        super(context, clazz2, name);
        this.pool = clazz2.pool;
        int count2 = stream2.readShort();
        for (int i = 0; i < count2; ++i) {
            short startPc = stream2.readShort();
            short length2 = stream2.readShort();
            short nameIndex = stream2.readShort();
            short descIndex = stream2.readShort();
            short index2 = stream2.readShort();
            this.addEntry((int)startPc, (int)length2, nameIndex, descIndex, (int)index2);
        }
        assert (name.equals(this.getName()));
    }

    public void addEntry(int startPc, int length2, int nameIndex, int descIndex, int index2) {
        this.entries.add(new Entry(startPc, length2, nameIndex, descIndex, index2));
    }

    public void addEntry(int startPc, int length2, String name, String desc, int index2) {
        Entry e2 = new Entry(startPc, length2, name, desc, index2);
        Entry other = this.getEntry(index2);
        if (other != null) {
            assert (other.nameIndex == e2.nameIndex && other.descIndex == e2.descIndex) : e2 + " already declared as " + other;
        } else {
            this.entries.add(e2);
        }
    }

    public void addEntry(int startPc, int length2, String name, String desc) {
        this.entries.add(new Entry(startPc, length2, name, desc));
    }

    @Override
    public String getName() {
        return "LocalVariableTable";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  LocalVariableTable: ");
        buf.append("\n   Start  Length  Slot  Name   Signature");
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            buf.append("\n   ");
            Entry e2 = (Entry)it.next();
            JConstantPool.Utf8Entry name = (JConstantPool.Utf8Entry)this.pool.lookupEntry(e2.nameIndex);
            JConstantPool.Utf8Entry sig = (JConstantPool.Utf8Entry)this.pool.lookupEntry(e2.descIndex);
            buf.append(e2.startPc);
            buf.append("      ");
            buf.append(e2.length);
            buf.append("      ");
            buf.append(e2.index);
            buf.append("    ");
            buf.append(name.getValue());
            buf.append("       ");
            buf.append(sig.getValue());
        }
        buf.append("\n");
        return buf.toString();
    }

    public int getMaxLocals() {
        return this.localVariableIndex;
    }

    @Override
    public int getSize() {
        return 2 + this.entries.size() * 10;
    }

    @Override
    protected void writeContentsTo(DataOutputStream stream2) throws IOException {
        stream2.writeShort(this.entries.size());
        for (Entry e2 : this.entries) {
            stream2.writeShort(e2.startPc);
            stream2.writeShort(e2.length);
            stream2.writeShort(e2.nameIndex);
            stream2.writeShort(e2.descIndex);
            stream2.writeShort(e2.index);
        }
    }

    private Entry getEntry(int index2) {
        Entry e2 = null;
        try {
            e2 = (Entry)this.entries.get(index2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e2;
    }

    private class Entry {
        int startPc;
        int length;
        int nameIndex;
        int descIndex;
        int index;

        public Entry(int startPc, int length2, int nameIndex, int descIndex, int index2) {
            this.startPc = startPc;
            this.length = length2;
            this.nameIndex = nameIndex;
            this.descIndex = descIndex;
            this.index = index2;
            JLocalVariableTableAttribute.this.localVariableIndex += length2;
        }

        public Entry(int startPc, int length2, String name, String desc, int index2) {
            this(startPc, length2, jLocalVariableTableAttribute.pool.addUtf8(name), jLocalVariableTableAttribute.pool.addUtf8(desc), index2);
        }

        public Entry(int startPc, int length2, String name, String desc) {
            this(startPc, length2, jLocalVariableTableAttribute.pool.addUtf8(name), jLocalVariableTableAttribute.pool.addUtf8(desc), jLocalVariableTableAttribute.localVariableIndex);
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry otherEntry = (Entry)other;
                return otherEntry.index == this.index;
            }
            return false;
        }
    }
}

