/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JCodeIterator;
import ch.epfl.lamp.fjbg.JFieldOrMethod;
import ch.epfl.lamp.fjbg.JLocalVariable;
import ch.epfl.lamp.fjbg.JLocalVariableTableAttribute;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

public class JMethod
extends JFieldOrMethod {
    public static final String CLASS_CONSTRUCTOR_NAME = "<clinit>";
    public static final String INSTANCE_CONSTRUCTOR_NAME = "<init>";
    protected JCode code;
    protected final String[] argNames;
    protected final LinkedList localVariables = new LinkedList();
    protected int localVariableIndex = 0;

    protected JMethod(FJBGContext context, JClass owner, int accessFlags, String name, JType returnType, JType[] argTypes, String[] argNames) {
        super(context, owner, accessFlags, name, new JMethodType(returnType, argTypes));
        this.argNames = argNames;
        assert (argTypes.length == argNames.length);
        if (this.isAbstract() || this.isNative()) {
            this.code = null;
        } else {
            this.code = context.JCode(owner, this);
            this.addAttribute(context.JCodeAttribute(owner, this));
            if (!this.isStatic()) {
                this.addNewLocalVariable(owner.getType(), "this");
            }
            for (int i = 0; i < argTypes.length; ++i) {
                this.addNewLocalVariable(argTypes[i], argNames[i]);
            }
        }
    }

    protected JMethod(FJBGContext context, JClass owner, DataInputStream stream2) throws IOException {
        super(context, owner, stream2);
        assert (this.isAbstract() || this.isNative() || this.code != null);
        int n = 0;
        if (this.code != null) {
            for (JAttribute attr : this.code.getAttributes()) {
                if (!(attr instanceof JLocalVariableTableAttribute)) continue;
                n = ((JLocalVariableTableAttribute)attr).getMaxLocals();
            }
        }
        this.localVariableIndex = n;
        JType[] argTypes = ((JMethodType)this.getType()).getArgumentTypes();
        this.argNames = new String[argTypes.length];
        for (int i = 0; i < this.argNames.length; ++i) {
            this.argNames[i] = "v" + i;
        }
    }

    @Override
    public void freeze() throws JCode.OffsetTooBigException {
        if (this.code != null) {
            this.code.freeze();
        }
        super.freeze();
    }

    public JType getReturnType() {
        return ((JMethodType)this.type).getReturnType();
    }

    public JType[] getArgumentTypes() {
        return ((JMethodType)this.type).getArgumentTypes();
    }

    public int getArgsSize() {
        int size2 = ((JMethodType)this.type).getArgsSize();
        if (!this.isStatic()) {
            ++size2;
        }
        return size2;
    }

    public String[] getArgumentNames() {
        return this.argNames;
    }

    public JCode getCode() {
        assert (!this.isAbstract());
        return this.code;
    }

    protected void setCode(JCode code2) {
        assert (null == this.code);
        this.code = code2;
    }

    public JCodeIterator codeIterator() {
        return new JCodeIterator(this.code);
    }

    public JLocalVariable addNewLocalVariable(JType type, String name) {
        assert (!this.frozen);
        JLocalVariable var = this.context.JLocalVariable(this, type, name, this.localVariableIndex);
        this.localVariableIndex += type.getSize();
        this.localVariables.add(var);
        return var;
    }

    public JLocalVariable getLocalVariable(int index2) {
        for (int i = 0; i < this.localVariables.size(); ++i) {
            if (((JLocalVariable)this.localVariables.get((int)i)).index != index2) continue;
            return (JLocalVariable)this.localVariables.get(i);
        }
        return null;
    }

    public JLocalVariable[] getLocalVariables() {
        return this.localVariables.toArray(new JLocalVariable[this.localVariables.size()]);
    }

    public int getMaxLocals() {
        return this.localVariableIndex;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.flagsToString());
        String name = this.getName();
        if (CLASS_CONSTRUCTOR_NAME.equals(name)) {
            buf.append("{}");
        } else {
            if (INSTANCE_CONSTRUCTOR_NAME.equals(name)) {
                name = this.getOwner().getName();
            } else {
                buf.append(JMethod.toExternalName(this.getReturnType()));
                buf.append(" ");
            }
            buf.append(JMethod.toExternalName(name));
            buf.append("(");
            JType[] ts = this.getArgumentTypes();
            for (int i = 0; i < ts.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(JMethod.toExternalName(ts[i]));
            }
            buf.append(")");
        }
        buf.append(";\n");
        for (JAttribute attr : this.attributes) {
            buf.append(attr);
        }
        return buf.toString();
    }

    private String flagsToString() {
        StringBuffer buf = new StringBuffer();
        if (this.isPublic()) {
            buf.append("public ");
        } else if (this.isProtected()) {
            buf.append("protected ");
        } else if (this.isPrivate()) {
            buf.append("private ");
        }
        if (this.isBridge()) {
            buf.append("<bridge> ");
        }
        if (this.hasVarargs()) {
            buf.append("<varargs> ");
        }
        if (this.isStatic()) {
            buf.append("static ");
        } else if (this.isNative()) {
            buf.append("native ");
        }
        if (this.isAbstract()) {
            buf.append("abstract ");
        } else if (this.isFinal()) {
            buf.append("final ");
        }
        return buf.toString();
    }
}

