/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JOtherAttribute
extends JAttribute {
    protected final String name;
    protected final byte[] contents;
    protected final int length;

    public JOtherAttribute(FJBGContext context, JClass clazz2, Object owner, String name, byte[] contents, int length2) {
        super(context, clazz2, name);
        this.name = name;
        this.contents = contents;
        this.length = length2;
    }

    public JOtherAttribute(FJBGContext context, JClass clazz2, Object owner, String name, int size2, DataInputStream stream2) throws IOException {
        super(context, clazz2, name);
        this.name = name;
        this.contents = new byte[size2];
        this.length = size2;
        stream2.read(this.contents, 0, this.length);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  ");
        buf.append(this.name);
        buf.append(": length = 0x");
        buf.append(Integer.toHexString(this.length).toUpperCase());
        for (int i = 0; i < this.length; ++i) {
            if (i % 16 == 0) {
                buf.append("\n   ");
            }
            buf.append(JOtherAttribute.hexString(this.contents[i]));
            buf.append(" ");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    protected int getSize() {
        return this.length;
    }

    @Override
    protected void writeContentsTo(DataOutputStream stream2) throws IOException {
        stream2.write(this.contents, 0, this.length);
    }

    private static final String hexString(int i) {
        return (0 <= i && i < 16 ? "0" : "") + Integer.toHexString(i).toUpperCase();
    }
}

