/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JClass;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Main {
    private static final String PRODUCT_STRING = "Fast Java Bytecode Generator";
    private static final String VERSION_STRING = "version 1.1";
    private static final int ACTION_USAGE = 0;
    private static final int ACTION_DONE = 1;
    private static final int ACTION_PROCEED = 2;
    private static String classPath = ".";
    private static String[] classNames = null;

    public static void main(String[] args2) {
        switch (Main.parseArgs(args2)) {
            case 0: {
                Main.printUsage();
                break;
            }
            case 2: {
                Main.processClasses();
                break;
            }
        }
    }

    private static void processClasses() {
        FJBGContext fjbgContext = new FJBGContext(49, 0);
        if (classNames.length > 0) {
            try {
                for (int i = 0; i < classNames.length; ++i) {
                    Main.processClass(fjbgContext, classNames[i]);
                }
            }
            catch (IOException e2) {
                System.err.println(e2.getMessage());
            }
        } else {
            System.err.println("No classes were specified on the command line.  Try -help.");
        }
    }

    private static void processClass(FJBGContext fjbgContext, String className) throws IOException {
        InputStream in2 = Main.getInputStream(className);
        JClass jclass = fjbgContext.JClass(new DataInputStream(in2));
        System.out.println(jclass);
        in2.close();
    }

    private static InputStream getInputStream(String className) throws IOException {
        String name = null;
        String[] paths = classPath.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            ZipEntry e2;
            Object f2;
            File parent2 = new File(paths[i]);
            if (parent2.isDirectory()) {
                name = className.replace('.', File.separatorChar) + ".class";
                f2 = new File(parent2, name);
                if (!((File)f2).isFile()) continue;
                return new FileInputStream((File)f2);
            }
            if (!paths[i].endsWith(".jar") || (e2 = ((JarFile)(f2 = new JarFile(parent2))).getEntry(name = className.replace('.', '/') + ".class")) == null) continue;
            return ((JarFile)f2).getInputStream(e2);
        }
        throw new IOException("ERROR:Could not find " + className);
    }

    private static int parseArgs(String[] args2) {
        ArrayList<String> classes2 = new ArrayList<String>();
        String arg = null;
        int action2 = 0;
        int i = 0;
        int n = args2.length;
        while (i < n) {
            arg = args2[i];
            if (arg.equals("-classpath") && i + 1 < n) {
                classPath = args2[i + 1];
                i += 2;
                continue;
            }
            if (arg.equals("-cp") && i + 1 < n) {
                classPath = args2[i + 1];
                i += 2;
                continue;
            }
            if (arg.equals("-help")) {
                i = n + 1;
                continue;
            }
            if (arg.equals("-version")) {
                System.err.println("Fast Java Bytecode Generator version 1.1");
                action2 = 1;
                i = n + 1;
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("invalid flag: " + arg);
                i = n + 1;
                continue;
            }
            classes2.add(arg);
            ++i;
        }
        if (i == n && i > 0) {
            classNames = classes2.toArray(new String[classes2.size()]);
            action2 = 2;
        }
        return action2;
    }

    private static void printUsage() {
        System.out.println("Usage: fjbg <options> <classes>");
        System.out.println();
        System.out.println("where possible options include:");
        System.out.println("  -cp <path>           Specify where to find user class files");
        System.out.println("  -classpath <path>    Specify where to find user class files");
        System.out.println("  -help                Print a synopsis of standard options");
        System.out.println("  -version             Version information");
        System.out.println();
        System.exit(1);
    }
}

