/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.sw.OutputElementBase;
import com.ctc.wstx.util.BijectiveNsMap;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMOutputElement
extends OutputElementBase {
    private DOMOutputElement mParent;
    private final Node mRootNode;
    private Element mElement;
    private boolean mDefaultNsSet;

    private DOMOutputElement(Node rootNode) {
        this.mRootNode = rootNode;
        this.mParent = null;
        this.mElement = null;
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
        this.mDefaultNsSet = false;
    }

    private DOMOutputElement(DOMOutputElement parent2, Element element2, BijectiveNsMap ns) {
        super(parent2, ns);
        this.mRootNode = null;
        this.mParent = parent2;
        this.mElement = element2;
        this.mNsMapping = ns;
        this.mNsMapShared = ns != null;
        this.mDefaultNsURI = parent2.mDefaultNsURI;
        this.mRootNsContext = parent2.mRootNsContext;
        this.mDefaultNsSet = false;
    }

    private void relink(DOMOutputElement parent2, Element element2) {
        super.relink(parent2);
        this.mParent = parent2;
        this.mElement = element2;
        parent2.appendNode(element2);
        this.mDefaultNsSet = false;
    }

    public static DOMOutputElement createRoot(Node rootNode) {
        return new DOMOutputElement(rootNode);
    }

    protected DOMOutputElement createAndAttachChild(Element element2) {
        if (this.mRootNode != null) {
            this.mRootNode.appendChild(element2);
        } else {
            this.mElement.appendChild(element2);
        }
        return this.createChild(element2);
    }

    protected DOMOutputElement createChild(Element element2) {
        return new DOMOutputElement(this, element2, this.mNsMapping);
    }

    protected DOMOutputElement reuseAsChild(DOMOutputElement parent2, Element element2) {
        DOMOutputElement poolHead = this.mParent;
        this.relink(parent2, element2);
        return poolHead;
    }

    protected void addToPool(DOMOutputElement poolHead) {
        this.mParent = poolHead;
    }

    public DOMOutputElement getParent() {
        return this.mParent;
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public String getNameDesc() {
        if (this.mElement != null) {
            return this.mElement.getLocalName();
        }
        return "#error";
    }

    public void setDefaultNsUri(String uri) {
        this.mDefaultNsURI = uri;
        this.mDefaultNsSet = true;
    }

    protected void setRootNsContext(NamespaceContext ctxt) {
        String defURI;
        this.mRootNsContext = ctxt;
        if (!this.mDefaultNsSet && (defURI = ctxt.getNamespaceURI("")) != null && defURI.length() > 0) {
            this.mDefaultNsURI = defURI;
        }
    }

    protected void appendNode(Node n) {
        if (this.mRootNode != null) {
            this.mRootNode.appendChild(n);
        } else {
            this.mElement.appendChild(n);
        }
    }

    protected void addAttribute(String pname, String value2) {
        this.mElement.setAttribute(pname, value2);
    }

    protected void addAttribute(String uri, String qname, String value2) {
        this.mElement.setAttributeNS(uri, qname, value2);
    }

    public void appendChild(Node n) {
        this.mElement.appendChild(n);
    }
}

