/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dom.DOMOutputElement;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.dom.DOMWrappingWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WstxDOMWrappingWriter
extends DOMWrappingWriter {
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final WriterConfig mConfig;
    protected DOMOutputElement mCurrElem;
    protected DOMOutputElement mOpenElement;
    protected int[] mAutoNsSeq;
    protected String mSuggestedDefNs = null;
    protected String mAutomaticNsPrefix;
    HashMap mSuggestedPrefixes = null;

    private WstxDOMWrappingWriter(WriterConfig cfg, Node treeRoot) throws XMLStreamException {
        super(treeRoot, cfg.willSupportNamespaces(), cfg.automaticNamespacesEnabled());
        this.mConfig = cfg;
        this.mAutoNsSeq = null;
        this.mAutomaticNsPrefix = this.mNsRepairing ? this.mConfig.getAutomaticNsPrefix() : null;
        switch (treeRoot.getNodeType()) {
            case 9: 
            case 11: {
                this.mCurrElem = DOMOutputElement.createRoot(treeRoot);
                this.mOpenElement = null;
                break;
            }
            case 1: {
                DOMOutputElement root2 = DOMOutputElement.createRoot(treeRoot);
                Element elem2 = (Element)treeRoot;
                this.mOpenElement = this.mCurrElem = root2.createChild(elem2);
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
    }

    public static WstxDOMWrappingWriter createFrom(WriterConfig cfg, DOMResult dst) throws XMLStreamException {
        Node rootNode = dst.getNode();
        return new WstxDOMWrappingWriter(cfg, rootNode);
    }

    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this.mCurrElem;
    }

    public String getPrefix(String uri) {
        String prefix2;
        if (!this.mNsAware) {
            return null;
        }
        if (this.mNsContext != null && (prefix2 = this.mNsContext.getPrefix(uri)) != null) {
            return prefix2;
        }
        return this.mCurrElem.getPrefix(uri);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public void setDefaultNamespace(String uri) {
        this.mSuggestedDefNs = uri == null || uri.length() == 0 ? null : uri;
    }

    public void setPrefix(String prefix2, String uri) throws XMLStreamException {
        if (prefix2 == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix2.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (prefix2.equals("xml")) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else {
            if (prefix2.equals("xmlns")) {
                if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                    WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
                }
                return;
            }
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix2);
            } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                WstxDOMWrappingWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix2);
            }
        }
        if (this.mSuggestedPrefixes == null) {
            this.mSuggestedPrefixes = new HashMap(16);
        }
        this.mSuggestedPrefixes.put(uri, prefix2);
    }

    public void writeAttribute(String localName, String value2) throws XMLStreamException {
        this.outputAttribute(null, null, localName, value2);
    }

    public void writeAttribute(String nsURI, String localName, String value2) throws XMLStreamException {
        this.outputAttribute(nsURI, null, localName, value2);
    }

    public void writeAttribute(String prefix2, String nsURI, String localName, String value2) throws XMLStreamException {
        this.outputAttribute(nsURI, prefix2, localName, value2);
    }

    public void writeDefaultNamespace(String nsURI) {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        this.setDefaultNamespace(nsURI);
        this.mOpenElement.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName);
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.createStartElem(nsURI, null, localName, true);
    }

    public void writeEmptyElement(String prefix2, String localName, String nsURI) throws XMLStreamException {
        if (prefix2 == null) {
            prefix2 = "";
        }
        this.createStartElem(nsURI, prefix2, localName, true);
    }

    public void writeEndDocument() {
        this.mOpenElement = null;
        this.mCurrElem = null;
    }

    public void writeEndElement() {
        if (this.mCurrElem == null || this.mCurrElem.isRoot()) {
            throw new IllegalStateException("No open start element to close");
        }
        this.mOpenElement = null;
        this.mCurrElem = this.mCurrElem.getParent();
    }

    public void writeNamespace(String prefix2, String nsURI) throws XMLStreamException {
        if (prefix2 == null || prefix2.length() == 0) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this.mNsAware) {
            WstxDOMWrappingWriter.throwOutputError("Can not write namespaces with non-namespace writer.");
        }
        this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", prefix2, nsURI);
        this.mCurrElem.addPrefix(prefix2, nsURI);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName);
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.createStartElem(nsURI, null, localName, false);
    }

    public void writeStartElement(String prefix2, String localName, String nsURI) throws XMLStreamException {
        this.createStartElem(nsURI, prefix2, localName, false);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value2) {
        return this.mConfig.setProperty(name, value2);
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        if (this.mCurrElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    protected void appendLeaf(Node n) throws IllegalStateException {
        this.mCurrElem.appendNode(n);
        this.mOpenElement = null;
    }

    protected void createStartElem(String nsURI, String prefix2, String localName, boolean isEmpty2) throws XMLStreamException {
        DOMOutputElement elem2;
        if (!this.mNsAware) {
            if (nsURI != null && nsURI.length() > 0) {
                WstxDOMWrappingWriter.throwOutputError("Can not specify non-empty uri/prefix in non-namespace mode");
            }
            elem2 = this.mCurrElem.createAndAttachChild(this.mDocument.createElement(localName));
        } else if (this.mNsRepairing) {
            String actPrefix = this.validateElemPrefix(prefix2, nsURI, this.mCurrElem);
            if (actPrefix != null) {
                elem2 = actPrefix.length() != 0 ? this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, actPrefix + ":" + localName)) : this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
            } else {
                boolean hasPrefix;
                if (prefix2 == null) {
                    prefix2 = "";
                }
                boolean bl = hasPrefix = (actPrefix = this.generateElemPrefix(prefix2, nsURI, this.mCurrElem)).length() != 0;
                if (hasPrefix) {
                    localName = actPrefix + ":" + localName;
                }
                this.mOpenElement = elem2 = this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
                if (hasPrefix) {
                    this.writeNamespace(actPrefix, nsURI);
                    elem2.addPrefix(actPrefix, nsURI);
                } else {
                    this.writeDefaultNamespace(nsURI);
                    elem2.setDefaultNsUri(nsURI);
                }
            }
        } else {
            if (prefix2 == null && nsURI != null && nsURI.length() > 0) {
                if (nsURI == null) {
                    nsURI = "";
                }
                String string2 = prefix2 = this.mSuggestedPrefixes == null ? null : (String)this.mSuggestedPrefixes.get(nsURI);
                if (prefix2 == null) {
                    WstxDOMWrappingWriter.throwOutputError("Can not find prefix for namespace \"" + nsURI + "\"");
                }
            }
            if (prefix2 != null && prefix2.length() != 0) {
                localName = prefix2 + ":" + localName;
            }
            elem2 = this.mCurrElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
        }
        this.mOpenElement = elem2;
        if (!isEmpty2) {
            this.mCurrElem = elem2;
        }
    }

    protected void outputAttribute(String nsURI, String prefix2, String localName, String value2) throws XMLStreamException {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                prefix2 = this.findOrCreateAttrPrefix(prefix2, nsURI, this.mOpenElement);
            }
            if (prefix2 != null && prefix2.length() > 0) {
                localName = prefix2 + ":" + localName;
            }
            this.mOpenElement.addAttribute(nsURI, localName, value2);
        } else {
            if (prefix2 != null && prefix2.length() > 0) {
                localName = prefix2 + ":" + localName;
            }
            this.mOpenElement.addAttribute(localName, value2);
        }
    }

    private final String validateElemPrefix(String prefix2, String nsURI, DOMOutputElement elem2) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            String currURL = elem2.getDefaultNsUri();
            if (currURL == null || currURL.length() == 0) {
                return "";
            }
            return null;
        }
        int status = elem2.isPrefixValid(prefix2, nsURI, true);
        if (status == 1) {
            return prefix2;
        }
        return null;
    }

    protected final String findElemPrefix(String nsURI, DOMOutputElement elem2) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            String currDefNsURI = elem2.getDefaultNsUri();
            if (currDefNsURI != null && currDefNsURI.length() > 0) {
                return null;
            }
            return "";
        }
        return this.mCurrElem.getPrefix(nsURI);
    }

    protected final String generateElemPrefix(String suggPrefix, String nsURI, DOMOutputElement elem2) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            return "";
        }
        if (suggPrefix == null) {
            if (this.mSuggestedDefNs != null && this.mSuggestedDefNs.equals(nsURI)) {
                suggPrefix = "";
            } else {
                String string2 = suggPrefix = this.mSuggestedPrefixes == null ? null : (String)this.mSuggestedPrefixes.get(nsURI);
                if (suggPrefix == null) {
                    if (this.mAutoNsSeq == null) {
                        this.mAutoNsSeq = new int[1];
                        this.mAutoNsSeq[0] = 1;
                    }
                    suggPrefix = elem2.generateMapping(this.mAutomaticNsPrefix, nsURI, this.mAutoNsSeq);
                }
            }
        }
        return suggPrefix;
    }

    protected final String findOrCreateAttrPrefix(String suggPrefix, String nsURI, DOMOutputElement elem2) throws XMLStreamException {
        String prefix2;
        if (nsURI == null || nsURI.length() == 0) {
            return null;
        }
        if (suggPrefix != null) {
            int status = elem2.isPrefixValid(suggPrefix, nsURI, false);
            if (status == 1) {
                return suggPrefix;
            }
            if (status == 0) {
                elem2.addPrefix(suggPrefix, nsURI);
                this.writeNamespace(suggPrefix, nsURI);
                return suggPrefix;
            }
        }
        if ((prefix2 = elem2.getExplicitPrefix(nsURI)) != null) {
            return prefix2;
        }
        if (suggPrefix != null) {
            prefix2 = suggPrefix;
        } else if (this.mSuggestedPrefixes != null) {
            prefix2 = (String)this.mSuggestedPrefixes.get(nsURI);
        }
        if (prefix2 != null && (prefix2.length() == 0 || elem2.getNamespaceURI(prefix2) != null)) {
            prefix2 = null;
        }
        if (prefix2 == null) {
            if (this.mAutoNsSeq == null) {
                this.mAutoNsSeq = new int[1];
                this.mAutoNsSeq[0] = 1;
            }
            prefix2 = this.mCurrElem.generateMapping(this.mAutomaticNsPrefix, nsURI, this.mAutoNsSeq);
        }
        elem2.addPrefix(prefix2, nsURI);
        this.writeNamespace(prefix2, nsURI);
        return prefix2;
    }
}

