/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.XMLStreamException;

public final class DTDNmTokensAttr
extends DTDAttribute {
    public DTDNmTokensAttr(PrefixedName name, DefaultAttrValue defValue, int specIndex, boolean nsAware, boolean xml11) {
        super(name, defValue, specIndex, nsAware, xml11);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDNmTokensAttr(this.mName, this.mDefValue, specIndex, this.mCfgNsAware, this.mCfgXml11);
    }

    public int getValueType() {
        return 9;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start2, int end2, boolean normalize2) throws XMLStreamException {
        while (start2 < end2 && WstxInputData.isSpaceChar(cbuf[start2])) {
            ++start2;
        }
        if (start2 >= end2) {
            return this.reportValidationProblem(v, "Empty NMTOKENS value");
        }
        if (!normalize2) {
            while (start2 < end2) {
                char c2 = cbuf[start2];
                if (!WstxInputData.isSpaceChar(c2) && !WstxInputData.isNameChar(c2, this.mCfgNsAware, this.mCfgXml11)) {
                    return this.reportInvalidChar(v, c2, "not valid as NMTOKENS character");
                }
                ++start2;
            }
            return null;
        }
        --end2;
        while (end2 > start2 && WstxInputData.isSpaceChar(cbuf[end2])) {
            --end2;
        }
        StringBuffer sb = null;
        while (start2 <= end2) {
            char c3;
            int i;
            for (i = start2; i <= end2 && !WstxInputData.isSpaceChar(c3 = cbuf[i]); ++i) {
                if (WstxInputData.isNameChar(c3, this.mCfgNsAware, this.mCfgXml11)) continue;
                return this.reportInvalidChar(v, c3, "not valid as an NMTOKENS character");
            }
            if (sb == null) {
                sb = new StringBuffer(end2 - start2 + 1);
            } else {
                sb.append(' ');
            }
            sb.append(cbuf, start2, i - start2);
            for (start2 = i + 1; start2 <= end2 && WstxInputData.isSpaceChar(cbuf[start2]); ++start2) {
            }
        }
        return sb.toString();
    }

    public void validateDefault(InputProblemReporter rep2, boolean normalize2) throws XMLStreamException {
        String defValue = this.mDefValue.getValue();
        int len2 = defValue.length();
        StringBuffer sb = null;
        int count2 = 0;
        int start2 = 0;
        block0: while (start2 < len2) {
            char c2 = defValue.charAt(start2);
            while (WstxInputData.isSpaceChar(c2)) {
                if (++start2 >= len2) break block0;
                c2 = defValue.charAt(start2);
            }
            int i = start2 + 1;
            while (++i < len2 && !WstxInputData.isSpaceChar(c2 = defValue.charAt(i))) {
            }
            ++count2;
            String token2 = defValue.substring(start2, i);
            int illegalIx = WstxInputData.findIllegalNmtokenChar(token2, this.mCfgNsAware, this.mCfgXml11);
            if (illegalIx >= 0) {
                this.reportValidationProblem(rep2, "Invalid default value '" + defValue + "'; character #" + illegalIx + " (" + WstxInputData.getCharDesc(defValue.charAt(illegalIx)) + ") not a valid NMTOKENS character");
            }
            if (normalize2) {
                if (sb == null) {
                    sb = new StringBuffer(i - start2 + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(token2);
            }
            start2 = i + 1;
        }
        if (count2 == 0) {
            this.reportValidationProblem(rep2, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKENS value");
            return;
        }
        if (normalize2) {
            this.mDefValue.setValue(sb.toString());
        }
    }
}

