/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.PrefixedNameSet;
import com.ctc.wstx.util.PrefixedName;

public final class SmallPrefixedNameSet
extends PrefixedNameSet {
    final boolean mNsAware;
    final String[] mStrings;

    public SmallPrefixedNameSet(boolean nsAware, PrefixedName[] names) {
        this.mNsAware = nsAware;
        int len2 = names.length;
        if (len2 == 0) {
            throw new IllegalStateException("Trying to construct empty PrefixedNameSet");
        }
        this.mStrings = new String[nsAware ? len2 + len2 : len2];
        int out = 0;
        for (int in2 = 0; in2 < len2; ++in2) {
            PrefixedName nk = names[in2];
            if (nsAware) {
                this.mStrings[out++] = nk.getPrefix();
            }
            this.mStrings[out++] = nk.getLocalName();
        }
    }

    public boolean hasMultiple() {
        return this.mStrings.length > 1;
    }

    public boolean contains(PrefixedName name) {
        int len2 = this.mStrings.length;
        String ln = name.getLocalName();
        String[] strs = this.mStrings;
        if (this.mNsAware) {
            String prefix2 = name.getPrefix();
            if (strs[1] == ln && strs[0] == prefix2) {
                return true;
            }
            for (int i = 2; i < len2; i += 2) {
                if (strs[i + 1] != ln || strs[i] != prefix2) continue;
                return true;
            }
        } else {
            if (strs[0] == ln) {
                return true;
            }
            for (int i = 1; i < len2; ++i) {
                if (strs[i] != ln) continue;
                return true;
            }
        }
        return false;
    }

    public void appendNames(StringBuffer sb, String sep) {
        int i = 0;
        while (i < this.mStrings.length) {
            String prefix2;
            if (i > 0) {
                sb.append(sep);
            }
            if (this.mNsAware && (prefix2 = this.mStrings[i++]) != null) {
                sb.append(prefix2);
                sb.append(':');
            }
            sb.append(this.mStrings[i++]);
        }
    }
}

