/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.BaseStartElement;
import com.ctc.wstx.io.TextEscaper;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.util.BaseNsContext;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.SingletonIterator;
import org.codehaus.stax2.ri.evt.AttributeEventImpl;

public class CompactStartElement
extends BaseStartElement {
    private static final int OFFSET_NS_URI = 1;
    private static final int OFFSET_NS_PREFIX = 2;
    private static final int OFFSET_VALUE = 3;
    final ElemAttrs mAttrs;
    final String[] mRawAttrs;
    private ArrayList mAttrList = null;

    protected CompactStartElement(Location loc, QName name, BaseNsContext nsCtxt, ElemAttrs attrs) {
        super(loc, name, nsCtxt);
        this.mAttrs = attrs;
        this.mRawAttrs = attrs == null ? null : attrs.getRawAttrs();
    }

    public Attribute getAttributeByName(QName name) {
        if (this.mAttrs == null) {
            return null;
        }
        int ix = this.mAttrs.findIndex(name);
        if (ix < 0) {
            return null;
        }
        return this.constructAttr(this.mRawAttrs, ix, !this.mAttrs.isDefault(ix));
    }

    public Iterator getAttributes() {
        if (this.mAttrList == null) {
            if (this.mAttrs == null) {
                return EmptyIterator.getInstance();
            }
            String[] rawAttrs = this.mRawAttrs;
            int rawLen = rawAttrs.length;
            int defOffset = this.mAttrs.getFirstDefaultOffset();
            if (rawLen == 4) {
                return new SingletonIterator(this.constructAttr(rawAttrs, 0, defOffset == 0));
            }
            ArrayList<Attribute> l = new ArrayList<Attribute>(rawLen >> 2);
            for (int i = 0; i < rawLen; i += 4) {
                l.add(this.constructAttr(rawAttrs, i, i >= defOffset));
            }
            this.mAttrList = l;
        }
        return this.mAttrList.iterator();
    }

    protected void outputNsAndAttr(Writer w) throws IOException {
        String[] raw2;
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(w);
        }
        if ((raw2 = this.mRawAttrs) != null) {
            int len2 = raw2.length;
            for (int i = 0; i < len2; i += 4) {
                w.write(32);
                String prefix2 = raw2[i + 2];
                if (prefix2 != null && prefix2.length() > 0) {
                    w.write(prefix2);
                    w.write(58);
                }
                w.write(raw2[i]);
                w.write("=\"");
                TextEscaper.writeEscapedAttrValue(w, raw2[i + 3]);
                w.write(34);
            }
        }
    }

    protected void outputNsAndAttr(XMLStreamWriter w) throws XMLStreamException {
        String[] raw2;
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(w);
        }
        if ((raw2 = this.mRawAttrs) != null) {
            int len2 = raw2.length;
            for (int i = 0; i < len2; i += 4) {
                String ln = raw2[i];
                String prefix2 = raw2[i + 2];
                String nsURI = raw2[i + 1];
                w.writeAttribute(prefix2, nsURI, ln, raw2[i + 3]);
            }
        }
    }

    public Attribute constructAttr(String[] raw2, int rawIndex, boolean isDef) {
        return new AttributeEventImpl(this.mLocation, raw2[rawIndex], raw2[rawIndex + 1], raw2[rawIndex + 2], raw2[rawIndex + 3], isDef);
    }
}

