/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class AsciiReader
extends BaseReader {
    boolean mXml11 = false;
    int mCharCount = 0;

    public AsciiReader(ReaderConfig cfg, InputStream in2, byte[] buf, int ptr, int len2, boolean recycleBuffer) {
        super(cfg, in2, buf, ptr, len2, recycleBuffer);
    }

    public void setXmlCompliancy(int xmlVersion) {
        this.mXml11 = xmlVersion == 272;
    }

    public int read(char[] cbuf, int start2, int len2) throws IOException {
        if (start2 < 0 || start2 + len2 > cbuf.length) {
            this.reportBounds(cbuf, start2, len2);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (len2 < 1) {
            return 0;
        }
        int avail = this.mByteBufferEnd - this.mBytePtr;
        if (avail <= 0) {
            this.mCharCount += this.mByteBufferEnd;
            int count2 = this.readBytes();
            if (count2 <= 0) {
                if (count2 == 0) {
                    this.reportStrangeStream();
                }
                this.freeBuffers();
                return -1;
            }
            avail = count2;
        }
        if (len2 > avail) {
            len2 = avail;
        }
        int i = this.mBytePtr;
        int last2 = i + len2;
        while (i < last2) {
            char c2;
            if ((c2 = (char)this.mByteBuffer[i++]) >= '\u007f') {
                if (c2 > '\u007f') {
                    this.reportInvalidAscii(c2);
                } else if (this.mXml11) {
                    int pos = this.mCharCount + this.mBytePtr;
                    this.reportInvalidXml11(c2, pos, pos);
                }
            }
            cbuf[start2++] = c2;
        }
        this.mBytePtr = last2;
        return len2;
    }

    private void reportInvalidAscii(char c2) throws IOException {
        throw new CharConversionException("Invalid ascii byte; value above 7-bit ascii range (" + c2 + "; at pos #" + (this.mCharCount + this.mBytePtr) + ")");
    }
}

