/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseInputSource;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.io.WstxInputSource;
import java.net.URL;
import javax.xml.stream.Location;

public final class CharArraySource
extends BaseInputSource {
    int mOffset;
    final Location mContentStart;

    CharArraySource(WstxInputSource parent2, String fromEntity, char[] chars, int offset2, int len2, Location loc, URL src) {
        super(parent2, fromEntity, loc.getPublicId(), loc.getSystemId(), src);
        this.mBuffer = chars;
        this.mOffset = offset2;
        this.mInputLast = offset2 + len2;
        this.mContentStart = loc;
    }

    public boolean fromInternalEntity() {
        return true;
    }

    protected void doInitInputLocation(WstxInputData reader2) {
        reader2.mCurrInputProcessed = this.mContentStart.getCharacterOffset();
        reader2.mCurrInputRow = this.mContentStart.getLineNumber();
        reader2.mCurrInputRowStart = -this.mContentStart.getColumnNumber() + 1;
    }

    public int readInto(WstxInputData reader2) {
        if (this.mBuffer == null) {
            return -1;
        }
        int len2 = this.mInputLast - this.mOffset;
        if (len2 < 1) {
            return -1;
        }
        reader2.mInputBuffer = this.mBuffer;
        reader2.mInputPtr = this.mOffset;
        reader2.mInputEnd = this.mInputLast;
        this.mOffset = this.mInputLast;
        return len2;
    }

    public boolean readMore(WstxInputData reader2, int minAmount) {
        int len2;
        if (reader2.mInputPtr >= reader2.mInputEnd && (len2 = this.mInputLast - this.mOffset) >= minAmount) {
            return this.readInto(reader2) > 0;
        }
        return false;
    }

    public void close() {
        this.mBuffer = null;
    }

    public void closeCompletely() {
        this.close();
    }
}

