/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.AsciiReader;
import com.ctc.wstx.io.BaseReader;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.ISOLatinReader;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.UTF32Reader;
import com.ctc.wstx.io.UTF8Reader;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class DefaultInputResolver {
    private DefaultInputResolver() {
    }

    public static WstxInputSource resolveEntity(WstxInputSource parent2, URL pathCtxt, String entityName, String publicId, String systemId, XMLResolver customResolver, ReaderConfig cfg, int xmlVersion) throws IOException, XMLStreamException {
        Object source;
        if (pathCtxt == null && (pathCtxt = parent2.getSource()) == null) {
            pathCtxt = URLUtil.urlFromCurrentDir();
        }
        if (customResolver != null && (source = customResolver.resolveEntity(publicId, systemId, pathCtxt.toExternalForm(), entityName)) != null) {
            return DefaultInputResolver.sourceFrom(parent2, cfg, entityName, xmlVersion, source);
        }
        if (systemId == null) {
            throw new XMLStreamException("Can not resolve " + (entityName == null ? "[External DTD subset]" : "entity '" + entityName + "'") + " without a system id (public id '" + publicId + "')");
        }
        URL url = URLUtil.urlFromSystemId(systemId, pathCtxt);
        return DefaultInputResolver.sourceFromURL(parent2, cfg, entityName, xmlVersion, url, publicId);
    }

    public static WstxInputSource resolveEntityUsing(WstxInputSource refCtxt, String entityName, String publicId, String systemId, XMLResolver resolver2, ReaderConfig cfg, int xmlVersion) throws IOException, XMLStreamException {
        Object source;
        URL ctxt;
        URL uRL = ctxt = refCtxt == null ? null : refCtxt.getSource();
        if (ctxt == null) {
            ctxt = URLUtil.urlFromCurrentDir();
        }
        return (source = resolver2.resolveEntity(publicId, systemId, ctxt.toExternalForm(), entityName)) == null ? null : DefaultInputResolver.sourceFrom(refCtxt, cfg, entityName, xmlVersion, source);
    }

    protected static WstxInputSource sourceFrom(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, Object o) throws IllegalArgumentException, IOException, XMLStreamException {
        if (o instanceof Source) {
            if (o instanceof StreamSource) {
                return DefaultInputResolver.sourceFromSS(parent2, cfg, refName, xmlVersion, (StreamSource)o);
            }
            throw new IllegalArgumentException("Can not use other Source objects than StreamSource: got " + o.getClass());
        }
        if (o instanceof URL) {
            return DefaultInputResolver.sourceFromURL(parent2, cfg, refName, xmlVersion, (URL)o, null);
        }
        if (o instanceof InputStream) {
            return DefaultInputResolver.sourceFromIS(parent2, cfg, refName, xmlVersion, (InputStream)o, null, null);
        }
        if (o instanceof Reader) {
            return DefaultInputResolver.sourceFromR(parent2, cfg, refName, xmlVersion, (Reader)o, null, null);
        }
        if (o instanceof String) {
            return DefaultInputResolver.sourceFromString(parent2, cfg, refName, xmlVersion, (String)o);
        }
        if (o instanceof File) {
            URL u = ((File)o).toURL();
            return DefaultInputResolver.sourceFromURL(parent2, cfg, refName, xmlVersion, u, null);
        }
        throw new IllegalArgumentException("Unrecognized input argument type for sourceFrom(): " + o.getClass());
    }

    public static Reader constructOptimizedReader(ReaderConfig cfg, InputStream in2, boolean isXml11, String encoding) throws XMLStreamException {
        BaseReader r;
        int inputBufLen = cfg.getInputBufferLength();
        String normEnc = CharsetNames.normalize(encoding);
        boolean recycleBuffer = true;
        if (normEnc == "UTF-8") {
            r = new UTF8Reader(cfg, in2, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc == "ISO-8859-1") {
            r = new ISOLatinReader(cfg, in2, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc == "US-ASCII") {
            r = new AsciiReader(cfg, in2, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc.startsWith("UTF-32")) {
            boolean isBE = normEnc == "UTF-32BE";
            r = new UTF32Reader(cfg, in2, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer, isBE);
        } else {
            try {
                return new InputStreamReader(in2, encoding);
            }
            catch (UnsupportedEncodingException ex2) {
                throw new XMLStreamException("[unsupported encoding]: " + ex2);
            }
        }
        if (isXml11) {
            r.setXmlCompliancy(272);
        }
        return r;
    }

    private static WstxInputSource sourceFromSS(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, StreamSource ssrc) throws IOException, XMLStreamException {
        InputBootstrapper bs;
        URL url;
        Reader r = ssrc.getReader();
        String pubId = ssrc.getPublicId();
        String sysId = ssrc.getSystemId();
        URL ctxt = parent2 == null ? null : parent2.getSource();
        URL uRL = url = sysId == null || sysId.length() == 0 ? null : URLUtil.urlFromSystemId(sysId, ctxt);
        if (r == null) {
            InputStream in2 = ssrc.getInputStream();
            if (in2 == null) {
                if (url == null) {
                    throw new IllegalArgumentException("Can not create Stax reader for a StreamSource -- neither reader, input stream nor system id was set.");
                }
                in2 = URLUtil.inputStreamFromURL(url);
            }
            bs = StreamBootstrapper.getInstance(pubId, sysId, in2);
        } else {
            bs = ReaderBootstrapper.getInstance(pubId, sysId, r, null);
        }
        Reader r2 = ((InputBootstrapper)bs).bootstrapInput(cfg, false, xmlVersion);
        return InputSourceFactory.constructEntitySource(cfg, parent2, refName, bs, pubId, sysId, xmlVersion, url == null ? ctxt : url, r2);
    }

    private static WstxInputSource sourceFromURL(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, URL url, String pubId) throws IOException, XMLStreamException {
        InputStream in2 = URLUtil.inputStreamFromURL(url);
        String sysId = url.toExternalForm();
        StreamBootstrapper bs = StreamBootstrapper.getInstance(pubId, sysId, in2);
        Reader r = bs.bootstrapInput(cfg, false, xmlVersion);
        return InputSourceFactory.constructEntitySource(cfg, parent2, refName, bs, pubId, sysId, xmlVersion, url, r);
    }

    public static WstxInputSource sourceFromString(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, String refContent) throws IOException, XMLStreamException {
        return DefaultInputResolver.sourceFromR(parent2, cfg, refName, xmlVersion, new StringReader(refContent), null, refName);
    }

    private static WstxInputSource sourceFromIS(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, InputStream is2, String pubId, String sysId) throws IOException, XMLStreamException {
        StreamBootstrapper bs = StreamBootstrapper.getInstance(pubId, sysId, is2);
        Reader r = bs.bootstrapInput(cfg, false, xmlVersion);
        URL ctxt = parent2.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId(sysId, ctxt);
        }
        return InputSourceFactory.constructEntitySource(cfg, parent2, refName, bs, pubId, sysId, xmlVersion, ctxt, r);
    }

    private static WstxInputSource sourceFromR(WstxInputSource parent2, ReaderConfig cfg, String refName, int xmlVersion, Reader r, String pubId, String sysId) throws IOException, XMLStreamException {
        URL ctxt;
        ReaderBootstrapper rbs = ReaderBootstrapper.getInstance(pubId, sysId, r, null);
        Reader r2 = rbs.bootstrapInput(cfg, false, xmlVersion);
        URL uRL = ctxt = parent2 == null ? null : parent2.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId(sysId, ctxt);
        }
        return InputSourceFactory.constructEntitySource(cfg, parent2, refName, rbs, pubId, sysId, xmlVersion, ctxt, r2);
    }
}

