/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import java.io.IOException;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    final ReaderConfig mConfig;
    final InputStream mIn;
    byte[] mData;
    int mPtr;
    final int mEnd;

    public MergedStream(ReaderConfig cfg, InputStream in2, byte[] buf, int start2, int end2) {
        this.mConfig = cfg;
        this.mIn = in2;
        this.mData = buf;
        this.mPtr = start2;
        this.mEnd = end2;
    }

    public int available() throws IOException {
        if (this.mData != null) {
            return this.mEnd - this.mPtr;
        }
        return this.mIn.available();
    }

    public void close() throws IOException {
        this.freeMergedBuffer();
        this.mIn.close();
    }

    public void mark(int readlimit) {
        if (this.mData == null) {
            this.mIn.mark(readlimit);
        }
    }

    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    public int read() throws IOException {
        if (this.mData != null) {
            int c2 = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return c2;
        }
        return this.mIn.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len2) throws IOException {
        if (this.mData != null) {
            int avail = this.mEnd - this.mPtr;
            if (len2 > avail) {
                len2 = avail;
            }
            System.arraycopy(this.mData, this.mPtr, b, off, len2);
            this.mPtr += len2;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return len2;
        }
        return this.mIn.read(b, off, len2);
    }

    public void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    public long skip(long n) throws IOException {
        long count2 = 0L;
        if (this.mData != null) {
            int amount = this.mEnd - this.mPtr;
            if ((long)amount > n) {
                this.mPtr += (int)n;
                return n;
            }
            this.freeMergedBuffer();
            count2 += (long)amount;
            n -= (long)amount;
        }
        if (n > 0L) {
            count2 += this.mIn.skip(n);
        }
        return count2;
    }

    private void freeMergedBuffer() {
        if (this.mData != null) {
            byte[] data2 = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(data2);
            }
        }
    }
}

