/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sr.Attribute;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sw.XmlWriter;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.InternCache;
import com.ctc.wstx.util.StringUtil;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.XMLValidator;

public final class AttributeCollector {
    static final int INT_SPACE = 32;
    protected static final int LONG_ATTR_LIST_LEN = 4;
    protected static final int EXP_ATTR_COUNT = 12;
    protected static final int EXP_NS_COUNT = 6;
    protected static final int XMLID_IX_DISABLED = -2;
    protected static final int XMLID_IX_NONE = -1;
    protected static final InternCache sInternCache = InternCache.getInstance();
    final String mXmlIdPrefix;
    final String mXmlIdLocalName;
    protected Attribute[] mAttributes;
    protected int mAttrCount;
    protected int mNonDefCount;
    protected Attribute[] mNamespaces;
    protected int mNsCount;
    protected boolean mDefaultNsDeclared = false;
    protected int mXmlIdAttrIndex;
    protected TextBuilder mValueBuilder = null;
    private final TextBuilder mNamespaceBuilder = new TextBuilder(6);
    protected int[] mAttrMap = null;
    protected int mAttrHashSize;
    protected int mAttrSpillEnd;

    protected AttributeCollector(ReaderConfig cfg, boolean nsAware) {
        int n = this.mXmlIdAttrIndex = cfg.willDoXmlIdTyping() ? -1 : -2;
        if (nsAware) {
            this.mXmlIdPrefix = "xml";
            this.mXmlIdLocalName = "id";
        } else {
            this.mXmlIdPrefix = null;
            this.mXmlIdLocalName = "xml:id";
        }
    }

    public void reset() {
        if (this.mNsCount > 0) {
            this.mNamespaceBuilder.reset();
            this.mDefaultNsDeclared = false;
            this.mNsCount = 0;
        }
        if (this.mAttrCount > 0) {
            this.mValueBuilder.reset();
            this.mAttrCount = 0;
            if (this.mXmlIdAttrIndex >= 0) {
                this.mXmlIdAttrIndex = -1;
            }
        }
    }

    public void normalizeSpacesInValue(int index2) {
        char[] attrCB = this.mValueBuilder.getCharBuffer();
        String normValue = StringUtil.normalizeSpaces(attrCB, this.getValueStartOffset(index2), this.getValueStartOffset(index2 + 1));
        if (normValue != null) {
            this.mAttributes[index2].setValue(normValue);
        }
    }

    protected int getNsCount() {
        return this.mNsCount;
    }

    public boolean hasDefaultNs() {
        return this.mDefaultNsDeclared;
    }

    public final int getCount() {
        return this.mAttrCount;
    }

    public int getSpecifiedCount() {
        return this.mNonDefCount;
    }

    public String getNsPrefix(int index2) {
        if (index2 < 0 || index2 >= this.mNsCount) {
            this.throwIndex(index2);
        }
        return this.mNamespaces[index2].mLocalName;
    }

    public String getNsURI(int index2) {
        if (index2 < 0 || index2 >= this.mNsCount) {
            this.throwIndex(index2);
        }
        return this.mNamespaces[index2].mNamespaceURI;
    }

    public String getPrefix(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttributes[index2].mPrefix;
    }

    public String getLocalName(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttributes[index2].mLocalName;
    }

    public String getURI(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttributes[index2].mNamespaceURI;
    }

    public QName getQName(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttributes[index2].getQName();
    }

    public final String getValue(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        String full = this.mValueBuilder.getAllValues();
        Attribute attr = this.mAttributes[index2];
        if (++index2 < this.mAttrCount) {
            int endOffset = this.mAttributes[index2].mValueStartOffset;
            return attr.getValue(full, endOffset);
        }
        return attr.getValue(full);
    }

    public String getValue(String nsURI, String localName) {
        int ix;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return null;
        }
        int hash2 = localName.hashCode();
        if (nsURI != null) {
            if (nsURI.length() == 0) {
                nsURI = null;
            } else {
                hash2 ^= nsURI.hashCode();
            }
        }
        if ((ix = this.mAttrMap[hash2 & hashSize - 1]) == 0) {
            return null;
        }
        if (this.mAttributes[--ix].hasQName(nsURI, localName)) {
            return this.getValue(ix);
        }
        int len2 = this.mAttrSpillEnd;
        for (int i = hashSize; i < len2; i += 2) {
            if (this.mAttrMap[i] != hash2 || !this.mAttributes[ix = this.mAttrMap[i + 1]].hasQName(nsURI, localName)) continue;
            return this.getValue(ix);
        }
        return null;
    }

    public int findIndex(String localName) {
        return this.findIndex(null, localName);
    }

    public int findIndex(String nsURI, String localName) {
        int ix;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return -1;
        }
        int hash2 = localName.hashCode();
        if (nsURI != null) {
            if (nsURI.length() == 0) {
                nsURI = null;
            } else {
                hash2 ^= nsURI.hashCode();
            }
        }
        if ((ix = this.mAttrMap[hash2 & hashSize - 1]) == 0) {
            return -1;
        }
        if (this.mAttributes[--ix].hasQName(nsURI, localName)) {
            return ix;
        }
        int len2 = this.mAttrSpillEnd;
        for (int i = hashSize; i < len2; i += 2) {
            if (this.mAttrMap[i] != hash2 || !this.mAttributes[ix = this.mAttrMap[i + 1]].hasQName(nsURI, localName)) continue;
            return ix;
        }
        return -1;
    }

    public final boolean isSpecified(int index2) {
        return index2 < this.mNonDefCount;
    }

    public final int getXmlIdAttrIndex() {
        return this.mXmlIdAttrIndex;
    }

    public final void decodeValue(int index2, TypedValueDecoder tvd) throws IllegalArgumentException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        char[] buf = this.mValueBuilder.getCharBuffer();
        int start2 = this.mAttributes[index2].mValueStartOffset;
        int end2 = this.getValueStartOffset(index2 + 1);
        while (true) {
            if (start2 >= end2) {
                tvd.handleEmptyValue();
                return;
            }
            if (!StringUtil.isSpace(buf[start2])) break;
            ++start2;
        }
        while (--end2 > start2 && StringUtil.isSpace(buf[end2])) {
        }
        tvd.decode(buf, start2, end2 + 1);
    }

    public final int decodeValues(int index2, TypedArrayDecoder tad, InputProblemReporter rep2) throws XMLStreamException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return AttributeCollector.decodeValues(tad, rep2, this.mValueBuilder.getCharBuffer(), this.mAttributes[index2].mValueStartOffset, this.getValueStartOffset(index2 + 1));
    }

    public final byte[] decodeBinary(int index2, Base64Variant v, CharArrayBase64Decoder dec, InputProblemReporter rep2) throws XMLStreamException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        Attribute attr = this.mAttributes[index2];
        char[] cbuf = this.mValueBuilder.getCharBuffer();
        int start2 = attr.mValueStartOffset;
        int end2 = this.getValueStartOffset(index2 + 1);
        int len2 = end2 - start2;
        dec.init(v, true, cbuf, start2, len2, null);
        try {
            return dec.decodeCompletely();
        }
        catch (IllegalArgumentException iae) {
            String lexical = new String(cbuf, start2, len2);
            throw new TypedXMLStreamException(lexical, iae.getMessage(), rep2.getLocation(), iae);
        }
    }

    private static final int decodeValues(TypedArrayDecoder tad, InputProblemReporter rep2, char[] buf, int ptr, int end2) throws XMLStreamException {
        int count2;
        block5: {
            int start2 = ptr;
            count2 = 0;
            try {
                while (ptr < end2) {
                    while (buf[ptr] <= ' ') {
                        if (++ptr < end2) continue;
                        break block5;
                    }
                    start2 = ptr++;
                    while (ptr < end2 && buf[ptr] > ' ') {
                        ++ptr;
                    }
                    int tokenEnd = ptr++;
                    ++count2;
                    if (!tad.decodeValue(buf, start2, tokenEnd) || AttributeCollector.checkExpand(tad)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                Location loc = rep2.getLocation();
                String lexical = new String(buf, start2, ptr - start2);
                throw new TypedXMLStreamException(lexical, iae.getMessage(), loc, iae);
            }
        }
        return count2;
    }

    private static final boolean checkExpand(TypedArrayDecoder tad) {
        if (tad instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)tad).expand();
            return true;
        }
        return false;
    }

    protected int getValueStartOffset(int index2) {
        if (index2 < this.mAttrCount) {
            return this.mAttributes[index2].mValueStartOffset;
        }
        return this.mValueBuilder.getCharSize();
    }

    protected char[] getSharedValueBuffer() {
        return this.mValueBuilder.getCharBuffer();
    }

    protected Attribute resolveNamespaceDecl(int index2, boolean internURI) {
        String uri;
        Attribute ns = this.mNamespaces[index2];
        String full = this.mNamespaceBuilder.getAllValues();
        if (this.mNsCount == 0) {
            uri = full;
        } else if (++index2 < this.mNsCount) {
            int endOffset = this.mNamespaces[index2].mValueStartOffset;
            uri = ns.getValue(full, endOffset);
        } else {
            uri = ns.getValue(full);
        }
        if (internURI && uri.length() > 0) {
            uri = sInternCache.intern(uri);
        }
        ns.mNamespaceURI = uri;
        return ns;
    }

    public ElemAttrs buildAttrOb() {
        int count2 = this.mAttrCount;
        if (count2 == 0) {
            return null;
        }
        String[] raw2 = new String[count2 << 2];
        for (int i = 0; i < count2; ++i) {
            Attribute attr = this.mAttributes[i];
            int ix = i << 2;
            raw2[ix] = attr.mLocalName;
            raw2[ix + 1] = attr.mNamespaceURI;
            raw2[ix + 2] = attr.mPrefix;
            raw2[ix + 3] = this.getValue(i);
        }
        if (count2 < 4) {
            return new ElemAttrs(raw2, this.mNonDefCount);
        }
        int amapLen = this.mAttrMap.length;
        int[] amap = new int[amapLen];
        System.arraycopy(this.mAttrMap, 0, amap, 0, amapLen);
        return new ElemAttrs(raw2, this.mNonDefCount, amap, this.mAttrHashSize, this.mAttrSpillEnd);
    }

    protected void validateAttribute(int index2, XMLValidator vld) throws XMLStreamException {
        Attribute attr = this.mAttributes[index2];
        String normValue = vld.validateAttribute(attr.mLocalName, attr.mNamespaceURI, attr.mPrefix, this.mValueBuilder.getCharBuffer(), this.getValueStartOffset(index2), this.getValueStartOffset(index2 + 1));
        if (normValue != null) {
            attr.setValue(normValue);
        }
    }

    public final TextBuilder getAttrBuilder(String attrPrefix, String attrLocalName) {
        if (this.mAttrCount == 0) {
            if (this.mAttributes == null) {
                this.allocBuffers();
            }
            this.mAttributes[0] = new Attribute(attrPrefix, attrLocalName, 0);
        } else {
            Attribute curr;
            int valueStart = this.mValueBuilder.getCharSize();
            if (this.mAttrCount >= this.mAttributes.length) {
                this.mAttributes = (Attribute[])DataUtil.growArrayBy50Pct(this.mAttributes);
            }
            if ((curr = this.mAttributes[this.mAttrCount]) == null) {
                this.mAttributes[this.mAttrCount] = new Attribute(attrPrefix, attrLocalName, valueStart);
            } else {
                curr.reset(attrPrefix, attrLocalName, valueStart);
            }
        }
        ++this.mAttrCount;
        if (attrLocalName == this.mXmlIdLocalName && attrPrefix == this.mXmlIdPrefix && this.mXmlIdAttrIndex != -2) {
            this.mXmlIdAttrIndex = this.mAttrCount - 1;
        }
        return this.mValueBuilder;
    }

    public int addDefaultAttribute(String localName, String uri, String prefix2, String value2) {
        int index2;
        int[] map3;
        int attrIndex = this.mAttrCount;
        if (attrIndex < 1) {
            this.initHashArea();
        }
        int hash2 = localName.hashCode();
        if (uri != null && uri.length() > 0) {
            hash2 ^= uri.hashCode();
        }
        if ((map3 = this.mAttrMap)[index2 = hash2 & this.mAttrHashSize - 1] == 0) {
            map3[index2] = attrIndex + 1;
        } else {
            int currIndex = map3[index2] - 1;
            int spillIndex = this.mAttrSpillEnd;
            if ((map3 = this.spillAttr(uri, localName, map3, currIndex, spillIndex, attrIndex, hash2, this.mAttrHashSize)) == null) {
                return -1;
            }
            map3[++spillIndex] = attrIndex;
            this.mAttrMap = map3;
            this.mAttrSpillEnd = ++spillIndex;
        }
        this.getAttrBuilder(prefix2, localName);
        Attribute attr = this.mAttributes[this.mAttrCount - 1];
        attr.mNamespaceURI = uri;
        attr.setValue(value2);
        return this.mAttrCount - 1;
    }

    public final void setNormalizedValue(int index2, String value2) {
        this.mAttributes[index2].setValue(value2);
    }

    public TextBuilder getDefaultNsBuilder() {
        if (this.mDefaultNsDeclared) {
            return null;
        }
        this.mDefaultNsDeclared = true;
        return this.getNsBuilder(null);
    }

    public TextBuilder getNsBuilder(String prefix2) {
        if (this.mNsCount == 0) {
            if (this.mNamespaces == null) {
                this.mNamespaces = new Attribute[6];
            }
            this.mNamespaces[0] = new Attribute(null, prefix2, 0);
        } else {
            int len2 = this.mNsCount;
            if (prefix2 != null) {
                for (int i = 0; i < len2; ++i) {
                    if (prefix2 != this.mNamespaces[i].mLocalName) continue;
                    return null;
                }
            }
            if (len2 >= this.mNamespaces.length) {
                this.mNamespaces = (Attribute[])DataUtil.growArrayBy50Pct(this.mNamespaces);
            }
            int uriStart = this.mNamespaceBuilder.getCharSize();
            Attribute curr = this.mNamespaces[len2];
            if (curr == null) {
                this.mNamespaces[len2] = new Attribute(null, prefix2, uriStart);
            } else {
                curr.reset(null, prefix2, uriStart);
            }
        }
        ++this.mNsCount;
        return this.mNamespaceBuilder;
    }

    public int resolveNamespaces(InputProblemReporter rep2, StringVector ns) throws XMLStreamException {
        int hashCount;
        int attrCount;
        this.mNonDefCount = attrCount = this.mAttrCount;
        if (attrCount < 1) {
            this.mAttrSpillEnd = 0;
            this.mAttrHashSize = 0;
            return this.mXmlIdAttrIndex;
        }
        for (int i = 0; i < attrCount; ++i) {
            Attribute attr = this.mAttributes[i];
            String prefix2 = attr.mPrefix;
            if (prefix2 == null) continue;
            if (prefix2 == "xml") {
                attr.mNamespaceURI = "http://www.w3.org/XML/1998/namespace";
                continue;
            }
            String uri = ns.findLastFromMap(prefix2);
            if (uri == null) {
                rep2.throwParseError(ErrorConsts.ERR_NS_UNDECLARED_FOR_ATTR, prefix2, attr.mLocalName);
            }
            attr.mNamespaceURI = uri;
        }
        int[] map3 = this.mAttrMap;
        int min2 = attrCount + (attrCount >> 2);
        for (hashCount = 4; hashCount < min2; hashCount += hashCount) {
        }
        this.mAttrHashSize = hashCount;
        min2 = hashCount + (hashCount >> 4);
        if (map3 == null || map3.length < min2) {
            map3 = new int[min2];
        } else {
            Arrays.fill(map3, 0, hashCount, 0);
        }
        int mask = hashCount - 1;
        int spillIndex = hashCount;
        for (int i = 0; i < attrCount; ++i) {
            int index2;
            Attribute attr = this.mAttributes[i];
            String name = attr.mLocalName;
            int hash2 = name.hashCode();
            String uri = attr.mNamespaceURI;
            if (uri != null) {
                hash2 ^= uri.hashCode();
            }
            if (map3[index2 = hash2 & mask] == 0) {
                map3[index2] = i + 1;
                continue;
            }
            int currIndex = map3[index2] - 1;
            if ((map3 = this.spillAttr(uri, name, map3, currIndex, spillIndex, attrCount, hash2, hashCount)) == null) {
                this.throwDupAttr(rep2, currIndex);
                continue;
            }
            map3[++spillIndex] = i;
            ++spillIndex;
        }
        this.mAttrSpillEnd = spillIndex;
        this.mAttrMap = map3;
        return this.mXmlIdAttrIndex;
    }

    protected void throwIndex(int index2) {
        throw new IllegalArgumentException("Invalid index " + index2 + "; current element has only " + this.getCount() + " attributes");
    }

    public void writeAttribute(int index2, XmlWriter xw) throws IOException, XMLStreamException {
        Attribute attr = this.mAttributes[index2];
        String ln = attr.mLocalName;
        String prefix2 = attr.mPrefix;
        if (prefix2 == null || prefix2.length() == 0) {
            xw.writeAttribute(ln, this.getValue(index2));
        } else {
            xw.writeAttribute(prefix2, ln, this.getValue(index2));
        }
    }

    protected final void allocBuffers() {
        if (this.mAttributes == null) {
            this.mAttributes = new Attribute[8];
        }
        if (this.mValueBuilder == null) {
            this.mValueBuilder = new TextBuilder(12);
        }
    }

    private int[] spillAttr(String uri, String name, int[] map3, int currIndex, int spillIndex, int attrCount, int hash2, int hashCount) {
        String currURI;
        Attribute oldAttr = this.mAttributes[currIndex];
        if (oldAttr.mLocalName == name && ((currURI = oldAttr.mNamespaceURI) == uri || currURI != null && currURI.equals(uri))) {
            return null;
        }
        if (spillIndex + 1 >= map3.length) {
            map3 = DataUtil.growArrayBy(map3, 8);
        }
        for (int j = hashCount; j < spillIndex; j += 2) {
            String currURI2;
            if (map3[j] != hash2) continue;
            currIndex = map3[j + 1];
            Attribute attr = this.mAttributes[currIndex];
            if (oldAttr.mLocalName != name || (currURI2 = attr.mNamespaceURI) != uri && (currURI2 == null || !currURI2.equals(uri))) continue;
            return null;
        }
        map3[spillIndex] = hash2;
        return map3;
    }

    private void initHashArea() {
        this.mAttrSpillEnd = 4;
        this.mAttrHashSize = 4;
        if (this.mAttrMap == null || this.mAttrMap.length < this.mAttrHashSize) {
            this.mAttrMap = new int[this.mAttrHashSize + 1];
        }
        this.mAttrMap[3] = 0;
        this.mAttrMap[2] = 0;
        this.mAttrMap[1] = 0;
        this.mAttrMap[0] = 0;
        this.allocBuffers();
    }

    protected void throwDupAttr(InputProblemReporter rep2, int index2) throws XMLStreamException {
        rep2.throwParseError("Duplicate attribute '" + this.getQName(index2) + "'.");
    }
}

