/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.util.BaseNsContext;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.SingletonIterator;
import org.codehaus.stax2.ri.evt.NamespaceEventImpl;

public final class CompactNsContext
extends BaseNsContext {
    final Location mLocation;
    final String[] mNamespaces;
    final int mNsLength;
    final int mFirstLocalNs;
    transient ArrayList mNsList;

    public CompactNsContext(Location loc, String defaultNsURI, String[] namespaces, int nsLen, int firstLocal) {
        this.mLocation = loc;
        this.mNamespaces = namespaces;
        this.mNsLength = nsLen;
        this.mFirstLocalNs = firstLocal;
    }

    public String doGetNamespaceURI(String prefix2) {
        String[] ns = this.mNamespaces;
        if (prefix2.length() == 0) {
            for (int i = this.mNsLength - 2; i >= 0; i -= 2) {
                if (ns[i] != null) continue;
                return ns[i + 1];
            }
            return null;
        }
        for (int i = this.mNsLength - 2; i >= 0; i -= 2) {
            if (!prefix2.equals(ns[i])) continue;
            return ns[i + 1];
        }
        return null;
    }

    public String doGetPrefix(String nsURI) {
        String[] ns = this.mNamespaces;
        int len2 = this.mNsLength;
        block0: for (int i = len2 - 1; i > 0; i -= 2) {
            if (!nsURI.equals(ns[i])) continue;
            String prefix2 = ns[i - 1];
            for (int j = i + 1; j < len2; j += 2) {
                if (ns[j] == prefix2) continue block0;
            }
            String uri = ns[i - 1];
            return uri == null ? "" : uri;
        }
        return null;
    }

    public Iterator doGetPrefixes(String nsURI) {
        String[] ns = this.mNamespaces;
        int len2 = this.mNsLength;
        String first2 = null;
        ArrayList<String> all2 = null;
        block0: for (int i = len2 - 1; i > 0; i -= 2) {
            String currNS = ns[i];
            if (currNS != nsURI && !currNS.equals(nsURI)) continue;
            String prefix2 = ns[i - 1];
            for (int j = i + 1; j < len2; j += 2) {
                if (ns[j] == prefix2) continue block0;
            }
            if (prefix2 == null) {
                prefix2 = "";
            }
            if (first2 == null) {
                first2 = prefix2;
                continue;
            }
            if (all2 == null) {
                all2 = new ArrayList<String>();
                all2.add(first2);
            }
            all2.add(prefix2);
        }
        if (all2 != null) {
            return all2.iterator();
        }
        if (first2 != null) {
            return new SingletonIterator(first2);
        }
        return EmptyIterator.getInstance();
    }

    public Iterator getNamespaces() {
        if (this.mNsList == null) {
            int firstLocal = this.mFirstLocalNs;
            int len2 = this.mNsLength - firstLocal;
            if (len2 == 0) {
                return EmptyIterator.getInstance();
            }
            if (len2 == 2) {
                return new SingletonIterator(NamespaceEventImpl.constructNamespace(this.mLocation, this.mNamespaces[firstLocal], this.mNamespaces[firstLocal + 1]));
            }
            ArrayList<NamespaceEventImpl> l = new ArrayList<NamespaceEventImpl>(len2 >> 1);
            String[] ns = this.mNamespaces;
            len2 = this.mNsLength;
            while (firstLocal < len2) {
                l.add(NamespaceEventImpl.constructNamespace(this.mLocation, ns[firstLocal], ns[firstLocal + 1]));
                firstLocal += 2;
            }
            this.mNsList = l;
        }
        return this.mNsList.iterator();
    }

    public void outputNamespaceDeclarations(Writer w) throws IOException {
        String[] ns = this.mNamespaces;
        int len2 = this.mNsLength;
        for (int i = this.mFirstLocalNs; i < len2; i += 2) {
            w.write(32);
            w.write("xmlns");
            String prefix2 = ns[i];
            if (prefix2 != null && prefix2.length() > 0) {
                w.write(58);
                w.write(prefix2);
            }
            w.write("=\"");
            w.write(ns[i + 1]);
            w.write(34);
        }
    }

    public void outputNamespaceDeclarations(XMLStreamWriter w) throws XMLStreamException {
        String[] ns = this.mNamespaces;
        int len2 = this.mNsLength;
        for (int i = this.mFirstLocalNs; i < len2; i += 2) {
            String nsURI = ns[i + 1];
            String prefix2 = ns[i];
            if (prefix2 != null && prefix2.length() > 0) {
                w.writeNamespace(prefix2, nsURI);
                continue;
            }
            w.writeDefaultNamespace(nsURI);
        }
    }
}

